/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsAt;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class Bib2GlsProgenitor
extends Bib2GlsEntry
implements Bib2GlsMultiEntry {
    private Vector<Bib2GlsEntry> progeny = new Vector();

    public Bib2GlsProgenitor(Bib2Gls bib2Gls) {
        this(bib2Gls, "progenitor");
    }

    public Bib2GlsProgenitor(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("progeny") == null || this.progeny.size() == 0) {
            this.missingFieldWarning("adoptparents");
        }
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("name")) {
            return this.getOriginalId();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("name")) {
            if (!this.bib2gls.useInterpreter()) {
                this.bib2gls.warningMessage("warning.interpreter.needed.fallback", string, this.getId());
                return null;
            }
            String string2 = this.getOriginalId();
            BibValueList bibValueList = new BibValueList();
            bibValueList.add(new BibUserString(this.bib2gls.getInterpreterListener().createGroup(string2)));
            return bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    protected void initMissingFields() {
        if (this.getResource().getLabelPrefix() != null && this.getFieldValue("name") == null) {
            this.putField("name", this.getOriginalId());
        }
    }

    @Override
    protected Vector<String> processSpecialFields(boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException, Bib2GlsException {
        vector = super.processSpecialFields(bl, stringArray, string, vector);
        for (String string2 : Bib2Gls.SPAWN_SPECIAL_FIELDS) {
            vector = this.processField(string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    @Override
    public void populate(BibParser bibParser) throws IOException {
        Object object;
        BibValueList bibValueList = this.getField("adoptparents");
        if (bibValueList == null && (object = this.resource.getOriginalField("adoptparents")) != null) {
            bibValueList = this.getField((String)object);
        }
        if (bibValueList == null) {
            return;
        }
        object = bibParser.getParser();
        TeXObjectList teXObjectList = bibValueList.expand((TeXParser)object);
        String string = teXObjectList.toString((TeXParser)object);
        if (this.resource.isInterpretLabelFieldsEnabled() && string.matches("(?s).*[\\\\\\{\\}].*")) {
            string = this.bib2gls.interpret(string, bibValueList, true);
            teXObjectList = ((TeXParser)object).getListener().createString(string);
        }
        CsvList csvList = CsvList.getList((TeXParser)object, teXObjectList);
        teXObjectList = new TeXObjectList();
        String string2 = this.getOriginalId();
        String string3 = this.processLabel(string2);
        String string4 = this.resource.getAdoptedParentField();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < csvList.size(); ++i) {
            String string5 = csvList.getValue(i).toString((TeXParser)object).trim();
            String string6 = null;
            string6 = this.getEntryType().startsWith("spawn") ? this.getEntryType().substring(5) : "index";
            String string7 = string5 + "." + this.getOriginalId();
            this.bib2gls.debugMessage("message.spawning", string7, this.getOriginalId());
            Bib2GlsEntry bib2GlsEntry = Bib2GlsAt.createBib2GlsEntry(this.bib2gls, "spawned" + string6);
            if (bib2GlsEntry == null) {
                throw new NullPointerException();
            }
            this.progeny.add(bib2GlsEntry);
            bib2GlsEntry.setId(this.getPrefix(), string7);
            bib2GlsEntry.setBase(this.getBaseFile());
            bib2GlsEntry.setOriginalEntryType(this.getOriginalEntryType());
            for (String string8 : this.getKeySet()) {
                if (string8.equals("alias") || string8.equals("parent") || (bibValueList = this.getField(string8)) == null) continue;
                bib2GlsEntry.putField(string8, (BibValueList)bibValueList.clone());
            }
            bib2GlsEntry.putField("progenitor", string3);
            bib2GlsEntry.putField(string4, string5);
            bibValueList = new BibValueList();
            bibValueList.add(new BibUserString(bibParser.createString(string3)));
            bib2GlsEntry.putField("progenitor", bibValueList);
            bibValueList = new BibValueList();
            bibValueList.add(new BibUserString(bibParser.createString(string5)));
            bib2GlsEntry.putField(string4, bibValueList);
            this.addDependency(bib2GlsEntry.getId());
            if (teXObjectList.size() > 0) {
                teXObjectList.add(bibParser.getOther(44));
                stringBuilder.append(',');
            }
            String string8 = bib2GlsEntry.getId();
            teXObjectList.addAll(bibParser.createString(string8));
            stringBuilder.append(string8);
            bibParser.addBibData(bib2GlsEntry);
            if (!this.bib2gls.isDebuggingOn()) continue;
            for (String string9 : bib2GlsEntry.getKeySet()) {
                bibValueList = bib2GlsEntry.getField(string9);
                this.bib2gls.debug(String.format("%s={%s}", string9, bibValueList == null ? "" : bibValueList.expand((TeXParser)object).toString((TeXParser)object)));
            }
        }
        bibValueList = new BibValueList();
        bibValueList.add(new BibUserString(teXObjectList));
        this.putField("progeny", bibValueList);
        this.putField("progeny", stringBuilder.toString());
    }

    @Override
    public void writeExtraFields(PrintWriter printWriter) throws IOException {
        String string = this.getFieldValue("progeny");
        if (string == null) {
            this.bib2gls.debugMessage("message.entry.lost.field", this.getId(), "progeny");
        } else {
            printWriter.println(String.format("\\GlsXtrSetField{%s}{progeny}{%s}", this.getId(), string));
        }
    }
}

