# Makefile for the web2c library.
INCLUDE=$(INCLUDE);../../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include "../kpathsea.mk"

DEFS = $(DEFS) -DMAKE_TEX_DLL -DHAVE_CONFIG_H -DOEM

library = lib

# We don't make `texmfmp.o', since TeX, Metafont, and MetaPost need to
# use different routine names, hence they need different .o files. Maybe
# we should change this via #define's someday ...
objects = \
#	$(objdir)\alloca.obj \
	$(objdir)\basechsuffix.obj $(objdir)\oem.obj                     \
	$(objdir)\chartostring.obj $(objdir)\coredump.obj                \
	$(objdir)\eofeoln.obj $(objdir)\fprintreal.obj                   \
	$(objdir)\inputint.obj $(objdir)\input2int.obj                   \
	$(objdir)\main.obj $(objdir)\openclose.obj                       \
	$(objdir)\printversion.obj $(objdir)\uexit.obj                   \
	$(objdir)\usage.obj $(objdir)\version.obj $(objdir)\zround.obj

default all: $(objdir) $(objdir)\$(library).lib
$(objdir)\$(library).lib: $(objects)
	-@$(RM) $@
	$(archive_command) $(objects)

# Do not use CPPFLAGS for this, because including config.h might
# result in a conflicting decl of xmalloc. How annoying.
$(objdir)\alloca.obj: alloca.c 
	$(compile) -DHAVE_CONFIG_H $(srcdir)/alloca.c

#Makefile: Makefile.in ../config.status
#	cd ..; $(SHELL) config.status

!include <make/clean.mak>
!include <make/tkpathsea.mak>
!include <make/rdepend.mak>
!include "./depend.mak"

# Local Variables:
# mode: Makefile
# End:
