/* usage.c: Output a help message (from help.h).

   Written in 1995 by K. Berry.  Public domain.  */

#include "config.h"

/* We're passed in zero for STATUS if this is from --help, else nonzero
   if it was from some kind of error.  In the latter case, we say `See
   HELP_STR --help for more information.', i.e., STR is supposed to be
   the program name.  */

void
usage P2C(int, status,  const_string, str)
{
  fprintf (stderr, "Try `%s --help' for more information.\n", str);
  uexit (status);
}

void
usagelong PVAR1C(int, status, ap)
{
  extern KPSEDLL char *kpse_bug_address;
  const_string *str, *p;

  while ((str = va_arg (ap, const_string *)) != NULL)
    {
	  for (p = str; *p; p++)
	  fputs (*p, stdout);
	  putchar ('\n');
	}
  va_end(ap);
  fputs (kpse_bug_address, stdout);
  uexit (status);
}}
