/* help.h: help messages for web2c programs.

   This is included by everyone, from cpascal.h.  This is better than
   putting the help messages directly in the change files because (1)
   multiline strings aren't supported by tangle, and it would be a pain
   to make up a new syntax for them in web2c, and (2) when a help msg
   changes, we need only recompile, not retangle or reconvert.  The
   downside is that everything gets recompiled when any msg changes, but
   that's better than having umpteen separate tiny files.  (For one
   thing, the messages have a lot in common, so it's nice to have them
   in one place.)

Copyright (C) 1995, 96 Karl Berry.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef HELP_H
#define HELP_H

#ifdef BIBTEX
const_string BIBTEXHELP[] = {
  "Usage: bibtex [OPTION]... AUXFILE[.aux]\n",
  "  Write bibliography for entries in AUXFILE to AUXFILE.bbl.\n",
  "\n",
  "-min-crossrefs=NUMBER  include item after NUMBER cross-refs; default 2\n",
  "-terse                 do not print progress reports\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* BIBTEX */

#ifdef DVICOPY
const_string DVICOPYHELP[] = {
  "Usage: dvicopy [OPTION]... [INDVI[.dvi] [OUTDVI[.dvi]]]\n",
  "  Expand virtual font references in INDVI to OUTDVI.\n",
  "  Defaults are standard input and standard output, respectively.\n",
  "\n",
  "-magnification=NUMBER  override existing magnification with NUMBER\n",
  "-max-pages=NUMBER      process NUMBER pages; default one million\n",
  "-page-start=PAGE-SPEC  start at PAGE-SPEC, for example `2' or `5.*.-2'\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* DVICOPY */

#ifdef DVITOMP
const_string DVITOMPHELP[] = {
  "Usage: dvitomp [OPTION]... DVIFILE[.dvi] [MPXFILE[.mpx]]\n",
  "  Translate DVIFILE to the MetaPost MPXFILE.\n",
  "  Default MPXFILE is basename of DVIFILE extended with `.mpx'.\n",
  "\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* DVITOMP */

#ifdef DVITYPE
const_string DVITYPEHELP[] = {
  "Usage: dvitype [OPTION]... DVIFILE[.dvi]\n",
  "  Verify and translate DVIFILE to human-readable form,\n",
  "  written to standard output.\n",
  "\n",
  "-dpi=REAL              set resolution to REAL pixels per inch; default 300.0\n",
  "-magnification=NUMBER  override existing magnification with NUMBER\n",
  "-max-pages=NUMBER      process NUMBER pages; default one million\n",
  "-output-level=NUMBER   verbosity level, from 0 to 4; default 4\n",
  "-page-start=PAGE-SPEC  start at PAGE-SPEC, for example `2' or `5.*.-2'\n",
  "-show-opcodes          show numeric opcodes (in decimal)\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* DVITYPE */

#ifdef eTeX
extern const_string ETEXHELP[];
#endif /* eTeX */

#ifdef GFTODVI
const_string GFTODVIHELP[] = {
  "Usage: gftodvi [OPTION]... GFNAME\n",
  "  Translate each character in GFNAME to a page in a DVI file,\n",
  "  which is named with the basename of GFNAME extended with `.dvi'.\n",
  "\n",
  "-overflow-label-offset=REAL  override 2.1in offset for overflow labels\n",
  "-help                        display this help and exit\n",
  "-verbose                     display progress reports\n",
  "-version                     output version information and exit\n",
  NULL
};
#endif /* GFTODVI */

#ifdef GFTOPK
const_string GFTOPKHELP[] = {
  "Usage: gftopk [OPTION]... GFNAME [PKFILE]\n",
  "  Translate the bitmap font GFNAME to PKFILE.\n",
  "  Default PKFILE is basename of GFNAME extended with `pk'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-verbose    display progress reports\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* GFTOPK */

#ifdef GFTYPE
const_string GFTYPEHELP[] = {
  "Usage: gftype [OPTION]... GFNAME\n",
  "  Verify and translate the bitmap font GFNAME to human-readable form,\n",
  "  written to standard output.\n",
  "\n",
  "-images       show characters as pixels\n",
  "-mnemonics    translate all GF commands\n",
  "-help         display this help and exit\n",
  "-version      output version information and exit\n",
  NULL
};
#endif /* GFTYPE */

#ifdef MF
extern const_string MFHELP[];
#endif /* MF */

#ifdef MFT
const_string MFTHELP[] = {
  "Usage: mft [OPTION]... MFNAME[.mf]\n",
  "  Translate MFNAME to TeX for printing, using the mftmac.tex macros.\n",
  "  Output goes to basename of MFNAME extended with `.tex'.\n",
  "\n",
  "-change=CHFILE  apply the change file CHFILE as with tangle and weave\n",
  "-style=MFTNAME  use MFTNAME instead of plain.mft\n",
  "-help           display this help and exit\n",
  "-version        output version information and exit\n",
  NULL
};
#endif /* MFT */

#ifdef MP
extern const_string MPHELP[];
#endif /* MP */

#ifdef ODVICOPY
const_string ODVICOPYHELP[] = {
  "Usage: odvicopy [OPTION]... [INDVI[.dvi] [OUTDVI[.dvi]]]\n",
  "  Expand virtual font references in INDVI to OUTDVI.\n",
  "  Defaults are standard input and standard output, respectively.\n",
  "\n",
  "-magnification=NUMBER  override existing magnification with NUMBER\n",
  "-max-pages=NUMBER      process NUMBER pages; default one million\n",
  "-page-start=PAGE-SPEC  start at PAGE-SPEC, for example `2' or `5.*.-2'\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* ODVICOPY */

#ifdef ODVITYPE
const_string ODVITYPEHELP[] = {
  "Usage: odvitype [OPTION]... DVIFILE[.dvi]\n",
  "  Verify and translate DVIFILE to human-readable form,\n",
  "  written to standard output.\n",
  "\n",
  "-dpi=REAL              set resolution to REAL pixels per inch; default 300.0\n",
  "-magnification=NUMBER  override existing magnification with NUMBER\n",
  "-max-pages=NUMBER      process NUMBER pages; default one million\n",
  "-output-level=NUMBER   verbosity level, from 0 to 4; default 4\n",
  "-page-start=PAGE-SPEC  start at PAGE-SPEC, for example `2' or `5.*.-2'\n",
  "-show-opcodes          show numeric opcodes (in decimal)\n",
  "-help                  display this help and exit\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* ODVITYPE */

#ifdef OFM2OPL
const_string OFM2OPLHELP[] = {
  "Usage: ofm2opl [OPTION]... OFMNAME[.ofm] [OPLFILE[.opl]]\n",
  "  Translate the font metrics OFMNAME to human-readable property list file\n",
  "  OPLFILE or standard output.\n",
  "\n",
  "-charcode-format=TYPE  output character codes according to TYPE,\n",
  "                        either `hex' or `ascii'; default is hex,\n",
  "                        ascii = ascii letters and digits, hex for all else\n",
  "-help                  display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* OFM2OPL */

#ifdef Omega
extern const_string OMEGAHELP[];
#endif /* Omega */

#ifdef OPL2OFM
const_string OPL2OFMHELP[] = {
  "Usage: opl2ofm [OPTION]... OPLFILE[.opl] [OFMFILE[.ofm]]\n",
  "  Translate the property list OPLFILE to OFMFILE.\n",
  "  Default OFMFILE is basename of OPLFILE extended with `.ofm'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-verbose    display progress reports\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* OPL2OFM */

#if defined (OTANGLE) || defined (OTANGLEBOOT)
const_string OTANGLEHELP[] = {
  "Usage: otangle [OPTION]... WEBFILE[.web] [CHANGEFILE[.ch]]\n",
  "  Tangle WEBFILE with CHANGEFILE into a Pascal program.\n",
  "  Default CHANGEFILE is /dev/null;\n",
  "  Pascal output goes to the basename of WEBFILE extended with `.p',\n",
  "  and a string pool file, if necessary, to the same extended with `.pool'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* OTANGLE */

#ifdef OVF2OVP
const_string OVF2OVPHELP[] = {
  "Usage: ovf2ovp [OPTION]... OVFNAME[.ovf] [OFMNAME[.ofm] [OVPFILE[.ovp]]]\n",
  "  Translate OVFNAME and companion OFMNAME to human-readable\n",
  "  virtual property list file OVPFILE or standard output.\n",
  "  If OFMNAME is not specified, OVFNAME (with `.ovf' removed) is used.\n",
  "\n",
  "-charcode-format=TYPE  output character codes according to TYPE,\n",
  "                        either `hex' or `ascii'; default is hex,\n",
  "                        ascii = ascii letters and digits, hex for all else\n",
  "-help                  display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* OVF2OVP */

#ifdef OVP2OVF
const_string OVP2OVFHELP[] = {
  "Usage: ovp2ovf [OPTION]... OVPFILE[.ovp] [OVFFILE[.ovf] [OFMFILE[.ofm]]]\n",
  "  Translate OVPFILE to OVFFILE and companion OFMFILE.\n",
  "  Default OVFFILE is basename of OVPFILE extended with `.ovf'.\n",
  "  Default OFMFILE is OVFFILE extended with `.ofm'.\n",
  "\n",
  "-help                  display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* OVP2OVF */

#ifdef PATGEN
const_string PATGENHELP[] = {
  "Usage: patgen [OPTION]... DICTIONARY PATTERNS OUTPUT TRANSLATE\n",
  "  Generate the OUTPUT hyphenation file for use with TeX\n",
  "  from the DICTIONARY, PATTERNS, and TRANSLATE files.\n",
  "\n",
  "-help           display this help and exit\n",
  "-version        output version information and exit\n",
  NULL
};
#endif /* PATGEN */

#ifdef pdfTeX
extern const_string PDFTEXHELP[];
#endif /* pdfTeX */

#ifdef pdfeTeX
extern const_string PDFETEXHELP[];
#endif /* pdfeTeX */

#ifdef PKTOGF
const_string PKTOGFHELP[] = {
  "Usage: pktogf [OPTION]... PKNAME [GFFILE]\n",
  "  Translate the bitmap font PKNAME to GFFILE.\n",
  "  Default GFFILE is basename of PKNAME extended with `gf'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-verbose    display progress reports\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* PKTOGF */

#ifdef PKTYPE
const_string PKTYPEHELP[] = {
  "Usage: pktype [OPTION]... PKNAME\n",
  "  Verify and translate the bitmap font PKNAME to human-readable form,\n",
  "  written to standard output.\n",
  "\n",
  "-help       display this help and exit\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* PKTYPE */

#ifdef PLTOTF
const_string PLTOTFHELP[] = {
  "Usage: pltotf [OPTION]... PLFILE[.pl] [TFMFILE[.tfm]]\n",
  "  Translate the property list PLFILE to TFMFILE.\n",
  "  Default TFMFILE is basename of PLFILE extended with `.tfm'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-verbose    display progress reports\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* PLTOTF */

#ifdef POOLTYPE
const_string POOLTYPEHELP[] = {
  "Usage: pooltype [OPTION]... POOLFILE[.pool]\n",
  "  Display the string number of each string in POOLFILE.\n",
  "\n",
  "-help       display this help and exit\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* POOLTYPE */

#if defined (TANGLE) || defined (TANGLEBOOT)
const_string TANGLEHELP[] = {
  "Usage: tangle [OPTION]... WEBFILE[.web] [CHANGEFILE[.ch]]\n",
  "  Tangle WEBFILE with CHANGEFILE into a Pascal program.\n",
  "  Default CHANGEFILE is /dev/null;\n",
  "  Pascal output goes to the basename of WEBFILE extended with `.p',\n",
  "  and a string pool file, if necessary, to the same extended with `.pool'.\n",
  "\n",
  "-help       display this help and exit\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* TANGLE */

#ifdef TeX
extern const_string TEXHELP[];
#ifdef IPC
extern const_string TEX_IPC_HELP[];
#endif /* IPC */
#endif /* TeX */
/* FIXME: include help for TCX files.
	"-translate-file=TCXFILE  use TCXFILE for printable chars and translations\n",
*/

#ifdef TFTOPL
const_string TFTOPLHELP[] = {
  "Usage: tftopl [OPTION]... TFMNAME[.tfm] [PLFILE[.pl]]\n",
  "  Translate the font metrics TFMNAME to human-readable property list file\n",
  "  PLFILE or standard output.\n",
  "\n",
  "-charcode-format=TYPE  output character codes according to TYPE,\n",
  "                        either `octal' or `ascii'; default is ascii for\n",
  "                        letters and digits, octal for all else\n",
  "-help                  display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* TFTOPL */

#ifdef VFTOVP
const_string VFTOVPHELP[] = {
  "Usage: vftovp [OPTION]... VFNAME[.vf] [TFMNAME[.tfm] [VPLFILE[.vpl]]]\n",
  "  Translate VFNAME and companion TFMNAME to human-readable\n",
  "  virtual property list file VPLFILE or standard output.\n",
  "  If TFMNAME is not specified, VFNAME (with `.vf' removed) is used.\n",
  "\n",
  "-charcode-format=TYPE  output character codes according to TYPE,\n",
  "                       either `octal' or `ascii'; default is ascii for\n",
  "                        letters and digits, octal for all else\n",
  "-help                   display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* VFTOVP */

#ifdef VPTOVF
const_string VPTOVFHELP[] = {
  "Usage: vptovf [OPTION]... VPLFILE[.vpl] [VFFILE[.vf] [TFMFILE[.tfm]]]\n",
  "  Translate VPLFILE to VFFILE and companion TFMFILE.\n",
  "  Default VFFILE is basename of VPLFILE extended with `.vf'.\n",
  "  Default TFMFILE is VFFILE extended with `.tfm'.\n",
  "\n",
  "-help                  display this help and exit\n",
  "-verbose               display progress reports\n",
  "-version               output version information and exit\n",
  NULL
};
#endif /* VPTOVF */

#ifdef WEAVE
const_string WEAVEHELP[] = {
  "Usage: weave [OPTION]... WEBFILE[.web] [CHANGEFILE[.ch]]\n",
  "  Weave WEBFILE with CHANGEFILE into a TeX document.\n",
  "  Default CHANGEFILE is /dev/null;\n",
  "  TeX output goes to the basename of WEBFILE extended with `.tex'.\n",
  "\n",
  "-x          omit cross-reference information\n",
  "-help       display this help and exit\n",
  "-version    output version information and exit\n",
  NULL
};
#endif /* WEAVE */

#endif /* not HELP_H */

