# Makefile for dvipsk -- kb@mail.tug.org. Public domain.
INCLUDE=$(INCLUDE);../../win32

version = 5.86

# Add -DDEFRES=dpi to DEFS to change the default resolution from 600.
# Add -DSECURE if you will install dvips with special privileges.
# Add -DNO_DEBUG to omit debugging support.
# Add -DNO_EMTEX to omit EMTEX specials.
# Add -DNO_HPS to omit hypertex support.
# Add -DNO_TPIC to omit tpic support.
# 
# For VM/CMS or (perhaps) VMS or DOS compilation, need the corresponding
# subdirectory from the original dvips distribution.  (Maybe dvipsk
# won't work at all on such systems; if you have info one way or the
# other, please let kb@cs.umb.edu know.)

!include <make/paths.mak>
!include <make/common.mak>
!include <make/programs.mak>
!include <make/texi.mak>

KPATHSEA=1
DEFS = $(DEFS) -DHAVE_CONFIG_H
!ifdef KPATHSEA
DEFS = $(DEFS) -DDEFRES=600 -DA4 -DSHIFTLOWCHARS \
	-DKPATHSEA                               \
	-DDOWNLOAD_USING_PDFTEX                  \
	-DNeedFunctionPrototypes

!else
DEFS = $(DEFS) -DDEFRES=600
!endif

# writet1.c is taken from pdftex
pdftexdir = ../web2c/pdftexdir

# The `t[mp]-' business is so that we don't create an empty .pro file,
# if running squeeze fails for some reason.  A dependency on squeeze
# fails here, so we include it below.
.SUFFIXES: .pro .lpro
.lpro.pro:
	.\$(objdir)\squeeze <$< >t-$@
	$(MV) t-$@ $@ && $(RM) t-$@
prologues = tex.pro texps.pro texc.pro special.pro finclude.pro \
            color.pro crop.pro hps.pro

srcfiles = dospecial.c dviinput.c emspecial.c fontdef.c loadfont.c \
	dvips.c tfmload.c download.c prescan.c scanpage.c          \
	skippage.c output.c scalewidth.c dosection.c dopage.c      \
	resident.c search.c unpack.c drawPS.c header.c repack.c  \
	virtualfont.c dpicheck.c finclude.c $(pdftexdir)/writet1.c pprescan.c    \
	papersiz.c color.c bbox.c hps.c flib.c

objects = $(objdir)\dospecial.obj $(objdir)\dviinput.obj   \
	$(objdir)\emspecial.obj $(objdir)\fontdef.obj      \
	$(objdir)\loadfont.obj $(objdir)\dvips.obj         \
	$(objdir)\tfmload.obj $(objdir)\download.obj       \
	$(objdir)\prescan.obj $(objdir)\scanpage.obj       \
	$(objdir)\skippage.obj $(objdir)\output.obj        \
	$(objdir)\scalewidth.obj $(objdir)\dosection.obj   \
	$(objdir)\dopage.obj $(objdir)\resident.obj        \
	$(objdir)\search.obj $(objdir)\unpack.obj          \
	$(objdir)\drawPS.obj $(objdir)\header.obj          \
	$(objdir)\repack.obj $(objdir)\virtualfont.obj     \
	$(objdir)\dpicheck.obj $(objdir)\finclude.obj      \
	$(objdir)\writet1.obj $(objdir)\pprescan.obj       \
	$(objdir)\papersiz.obj $(objdir)\color.obj         \
	$(objdir)\bbox.obj $(objdir)\hps.obj

program = $(objdir)\dvips.exe
programs = $(objdir)\afm2tfm.exe $(program)

manfiles = dvips.1 afm2tfm.1

default all: $(objdir) $(programs) $(prologues) dvips.info

!ifdef KPATHSEA
$(program): $(kpathsea) $(objects) $(objdir)\dvips.res
	$(kpathsea_link) $(objects) $(objdir)\dvips.res $(LOADLIBES)
$(objdir)\afm2tfm.exe: $(kpathsea) $(objdir)\afm2tfm.obj $(objdir)\afm2tfm.res
	$(kpathsea_link) $(objdir)\afm2tfm.obj $(objdir)\afm2tfm.res $(LOADLIBES)
# Omit LOADLIBES since no need to dynamically link with kpathsea.
$(objdir)\squeeze.exe: $(objdir) $(objdir)\squeeze.obj
	$(kpathsea_link) $(objdir)\squeeze.obj $(LOADLIBES)

$(objdir)\writet1.obj: $(pdftexdir)\writet1.c
	$(compile) -I$(pdftexdir) $(pdftexdir)\writet1.c
!else
# where TeX is `rooted'.  Sometimes /usr/local/lib/tex.
# TEXDIR = /usr/lib/tex
TEXDIR = e:/Local/TeX/share/texmf

# another place pk, tfm, and vf files might be found.
# LOCALDIR = /LocalLibrary/Fonts/TeXFonts
LOCALDIR = .

# the default path to search for TFM files 
# (this usually is identical to TeX's defaultfontpath, which omits `.')
# (private fonts are given an explicit directory, which overrides the path)
#   overridden by the environment variable TEXFONTS
# TFMPATH = $(LOCALDIR)/tfm;$(TEXDIR)/fonts/tfm
TFMPATH = .;$(LOCALDIR)/tfm;$(TEXDIR)/fonts/tfm

# the default path to search for PK files (usually omits `.')
# Don't forget to add the directory that
# MakeTeXPK puts the files!  (In this case, /LocalLibrary/Fonts...)
#   overridden by the environment variable TEXPKS or TEXPACKED or PKFONTS
# PKPATH = $(LOCALDIR)/pk;$(TEXDIR)/fonts/pk
PKPATH = .;$(LOCALDIR)/pk;$(TEXDIR)/fonts/pk

# the default path to search for VF files (usually omits `.')
#   overridden by the environment variable VFFONTS
# VFPATH = $(LOCALDIR)/vf;$(TEXDIR)/fonts/vf
VFPATH = .;$(LOCALDIR)/vf;$(TEXDIR)/fonts/vf

# additional directories in which to search for subdirectories to find
# both tfm and pk files
FONTSUBDIRPATH = 

# where the config files go
# CONFIGDIR = $(TEXDIR)/ps
CONFIGDIR = $(TEXDIR)/dvips

# the default path to search for config files
#   overridden by the environment variable TEXCONFIG
# CONFIGPATH = .;$(CONFIGDIR)
CONFIGPATH = .;$(CONFIGDIR)

# the name of your config file
# CONFIGFILE = config.ps
CONFIGFILE = config.ps

# where the header PS files go
# HEADERDIR = $(TEXDIR)/ps
HEADERDIR = $(TEXDIR)/dvips

# the default path to search for header files
# HEADERPATH = .;$(HEADERDIR)
HEADERPATH = .;$(HEADERDIR)

# where epsf.tex and rotate.tex go (usually the TeX macros directory)
# TEXMACRODIR = $(TEXDIR)/inputs
TEXMACRODIR = $(TEXDIR)/inputs

# the default path to search for epsf and psfiles
# (usually the same as TeX's defaultinputpath)
# FIGPATH = .;..;$(TEXDIR)/inputs
FIGPATH = .;..;$(TEXDIR)/inputs

PATHS = -DTFMPATH=\"$(TFMPATH)\" \
	-DPKPATH=\"$(PKPATH)\" \
	-DVFPATH=\"$(VFPATH)\" \
	-DHEADERPATH=\"$(HEADERPATH)\" \
	-DCONFIGPATH=\"$(CONFIGPATH)\" \
        -DCONFIGFILE=\"$(CONFIGFILE)\" \
	-DFONTSUBDIRPATH=\"$(FONTSUBDIRPATH)\" \
	-DFIGPATH=\"$(FIGPATH)\"

DEFS = $(DEFS) $(PATHS)

objects = $(objects) $(objdir)/makefont.obj

$(program): $(objdir) $(objects) $(win32)\dvips.res
	$(link_command) $(objects) $(win32)\dvips.res $(LIBS)
$(objdir)\afm2tfm.exe: $(objdir) $(objdir)\afm2tfm.obj $(win32)\afm2tfm.res
	$(link_command) $(objdir)\afm2tfm.obj $(win32)\afm2tfm.res $(LIBS)
# Omit LOADLIBES since no need to dynamically link with kpathsea.
$(objdir)\squeeze.exe: $(objdir) $(objdir)\squeeze.obj
	$(link_command) $(objdir)\squeeze.obj $(LIBS)
!endif

# resources
!include <make/version.mak>

$(prologues): $(objdir)\squeeze.exe
texc.lpro: texc.script tex.lpro
	$(SED) -f $(win32seddir)/texc-script.sed < .\tex.lpro > $@

!include <make/tkpathsea.mak>
!include <make/man.mak>

check: all
	-@$(RM) mtest.ps
	set TFMFONTS=$(srcdir)/testdata
	set VFFONTS=$(srcdir)/testdata
	-.\$(objdir)\dvips -D 300 $(srcdir)/testdata/dvipstst.xdv -o dvipstst.ps
	$(MV) dvipstst.ps mtest.ps
	-.\$(objdir)\dvips -D 300 $(srcdir)/testdata/dvipstst.xdv -o
	-diff --ignore-all-space $(srcdir)/testdata/dvipstst.xps dvipstst.ps
	-@$(RM) dvipstst.ps mtest.ps

install: install-exec install-data install-info install-man install-doc
	$(POST_INSTALL)
	@echo "Create $(psheaderdir)/base/config.ps if necessary (see ./INSTALL)."
uninstall: uninstall-exec uninstall-data

install-exec: all
	$(mktexdir) $(bindir) $(scriptdir) $(fontdir)
	for %%i in ($(programs)) do $(INSTALL_PROGRAM) %%i $(bindir)\%%~nxi
uninstall-exec:
	for %%i in ($(programs)) do $(RM) $(bindir)\%%~nxi

install-data:
	$(mktexdir) $(mandir) $(infodir) $(psheaderdir)/base $(dvips_plain_macrodir)
# PostScript prologues and encodings.
	for %%h in ($(prologues)) do $(INSTALL_DATA) %%h $(psheaderdir)\base\%%h
	cd $(srcdir)\reencode && \
	  for %%e in (*.enc) do $(INSTALL_DATA) %%e $(psheaderdir)\base\%%e
#	cd ..
# config.ps. Any one config.ps will be wrong for most people, so don't
# install anything by default.
#	if test ! -r $(psheaderdir)/base/config.ps				\
#	   || grep 'original config.ps --' $(psheaderdir)/base/config.ps	\
#	      >/dev/null; then	\
#          $(INSTALL_DATA) $(srcdir)/config.ps $(psheaderdir)/base/config.ps;	\
#        else true; fi
# psfonts.map.
#	if NOT EXIST $(psheaderdir)\base\psfonts.map \
#	  $(INSTALL_DATA) $(srcdir)\psfonts.map $(psheaderdir)\base\psfonts.map
#	grep 'original psfonts.map --' $(psheaderdir)/base/psfonts.map > nul
#	if NOT ERRORLEVEL 0 \
#	  $(INSTALL_DATA) $(srcdir)\psfonts.map $(psheaderdir)\base\psfonts.map
# TeX macros.
!ifdef TETEX
	cd $(srcdir)\tex && for %%m in (blackdvi.tex colordvi.tex epsf.tex rotate.tex) do \
	  $(INSTALL_DATA) %%m $(dvips_plain_macrodir)\%%m
!endif

install-info:: dvips.info
# Info files.
	cd $(srcdir) && for %%i in (dvips.info*) do \
	  $(INSTALL_DATA) %%i $(infodir)\%%i
	$(POSTINSTALL)
	-install-info --version > nul
	if ERRORLEVEL 0 \
	  install-info --info-dir=$(infodir) $(infodir)\dvips.info

install-doc:: dvips.pdf
	$(mktexdir) $(docdir)/dvips $(docdir)/html/dvips
	-$(CP) dvips.pdf $(docdir)\dvips\dvips.pdf & $(RM) dvips.pdf
	$(TEXI2HTML) $(TEXI2HTML_FLAGS) dvips.texi
	-$(CP) *.html $(docdir)\html\dvips & $(RM) *.html

uninstall-data:
	rm -f $(infodir)/dvips.info*
	for h in $(prologues); do rm -f $(psheaderdir)/$$h; done
	cd $(srcdir)\reencode && for %%e in (*.enc) do \
	  $(RM) $(psheaderdir)\base\%%e; \
	  done
	if grep 'original config.ps --' $(psheaderdir)/base/config.ps	\
             >/dev/null 2>&1; then rm -f $(psheaderdir)/base/config.ps;	\
        else true; fi
	if grep 'original psfonts.map --' $(psheaderdir)/base/psfonts.map	\
              >/dev/null 2>&1; then rm -f $(psheaderdir)/base/psfonts.map;	\
        else true; fi
	rm -f $(mandir)/dvips.$(manext) $(mandir)/afm2tfm.$(manext)

distname = dvipsk
program_files = *.texi *.info* *.lpro psfonts.map *.1 texc.script \
  dvips.help $(program).aux $(program).cps dvipstst.dvi
version_files = dvips.h afm2tfm.c dvips.c

pre-dist-$(distname): INSTALL $(program).info $(program).dvi
post-dist-$(distname):
	ln -s `pwd`/contrib `pwd`/tex $(distdir)
	mkdir $(distdir)/reencode; ln -s $(fontname)/*.enc $(distdir)/reencode
	ln -s `pwd`/README.reencode $(distdir)/reencode/README
	rm -f $(distdir)/texc.lpro

!include <make/dist.mak>
!include <make/config.mak>

info: $(program:.exe=).info
dvi: $(program:.exe=).dvi

##ifdef HOSTNAME
##INSTALL: $(program).texi
##	$(MAKEINFO) -D INSTALLONLY --no-headers --no-split --no-validate \
##	  $(MAKEINFO_FLAGS) $< -o $@
##	add-info-toc $@
##$(program).info: dvips.help
##dvips.help: dvips.c
##	./dvips --help | sed s/@/@@/g >$@
##doc: info INSTALL
##endif

!include <make/clean.mak>

extraclean::
	-@$(RM) afm2tfm.ps dvips.ps testdata\*.log

distclean::
	-@$(RM) *.pro texc.lpro
	-@$(RM) c-auto.h

!include <make/rdepend.mak>
!include "./depend.mak"

#
# Local Variables:
# mode: Makefile
# End:
