# Generated by default/object.tt
package Paws::Macie2::TagScopeTerm;
  use Moose;
  has Comparator => (is => 'ro', isa => 'Str', request_name => 'comparator', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has TagValues => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::TagValuePair]', request_name => 'tagValues', traits => ['NameInRequest']);
  has Target => (is => 'ro', isa => 'Str', request_name => 'target', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::TagScopeTerm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::TagScopeTerm object:

  $service_obj->Method(Att1 => { Comparator => $value, ..., Target => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::TagScopeTerm object:

  $result = $service_obj->Method(...);
  $result->Att1->Comparator

=head1 DESCRIPTION

Specifies a tag-based condition that determines whether an S3 object is
included or excluded from a classification job.

=head1 ATTRIBUTES


=head2 Comparator => Str

The operator to use in the condition. Valid values are EQ (equals) or
NE (not equals).


=head2 Key => Str

The object property to use in the condition. The only valid value is
TAG.


=head2 TagValues => ArrayRef[L<Paws::Macie2::TagValuePair>]

The tag keys or tag key and value pairs to use in the condition. To
specify only tag keys in a condition, specify the keys in this array
and set the value for each associated tag value to an empty string.


=head2 Target => Str

The type of object to apply the condition to.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

