=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::ViewProperties;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::CommonSlideViewProperties;
use AsposeSlidesCloud::Object::NormalViewRestoredProperties;
use AsposeSlidesCloud::Object::ResourceBase;
use AsposeSlidesCloud::Object::ResourceUri;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Slides document properties.
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Slides document properties.',
                                  class => 'ViewProperties',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'last_view' => {
    	datatype => 'string',
    	base_name => 'LastView',
    	description => 'Last used view mode.',
    	format => '',
    	read_only => '',
    		},
    'horizontal_bar_state' => {
    	datatype => 'string',
    	base_name => 'HorizontalBarState',
    	description => 'Horizontal bar state.',
    	format => '',
    	read_only => '',
    		},
    'vertical_bar_state' => {
    	datatype => 'string',
    	base_name => 'VerticalBarState',
    	description => 'Vertical bar state.',
    	format => '',
    	read_only => '',
    		},
    'prefer_single_view' => {
    	datatype => 'boolean',
    	base_name => 'PreferSingleView',
    	description => 'True to prefer single view.',
    	format => '',
    	read_only => '',
    		},
    'restored_left' => {
    	datatype => 'NormalViewRestoredProperties',
    	base_name => 'RestoredLeft',
    	description => 'The sizing of the side content region of the normal view, when the region is of a variable restored size.',
    	format => '',
    	read_only => '',
    		},
    'restored_top' => {
    	datatype => 'NormalViewRestoredProperties',
    	base_name => 'RestoredTop',
    	description => 'The sizing of the top slide region of the normal view, when the region is of a variable restored size.',
    	format => '',
    	read_only => '',
    		},
    'slide_view_properties' => {
    	datatype => 'CommonSlideViewProperties',
    	base_name => 'SlideViewProperties',
    	description => 'Slide view mode properties.',
    	format => '',
    	read_only => '',
    		},
    'notes_view_properties' => {
    	datatype => 'CommonSlideViewProperties',
    	base_name => 'NotesViewProperties',
    	description => 'Notes view mode properties.',
    	format => '',
    	read_only => '',
    		},
    'show_comments' => {
    	datatype => 'string',
    	base_name => 'ShowComments',
    	description => 'True if the comments should be shown.',
    	format => '',
    	read_only => '',
    		},
    'grid_spacing' => {
    	datatype => 'double',
    	base_name => 'GridSpacing',
    	description => 'The grid spacing that should be used for the grid underlying the presentation document, in points.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'last_view' => 'string',
    'horizontal_bar_state' => 'string',
    'vertical_bar_state' => 'string',
    'prefer_single_view' => 'boolean',
    'restored_left' => 'NormalViewRestoredProperties',
    'restored_top' => 'NormalViewRestoredProperties',
    'slide_view_properties' => 'CommonSlideViewProperties',
    'notes_view_properties' => 'CommonSlideViewProperties',
    'show_comments' => 'string',
    'grid_spacing' => 'double'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'last_view' => 'LastView',
    'horizontal_bar_state' => 'HorizontalBarState',
    'vertical_bar_state' => 'VerticalBarState',
    'prefer_single_view' => 'PreferSingleView',
    'restored_left' => 'RestoredLeft',
    'restored_top' => 'RestoredTop',
    'slide_view_properties' => 'SlideViewProperties',
    'notes_view_properties' => 'NotesViewProperties',
    'show_comments' => 'ShowComments',
    'grid_spacing' => 'GridSpacing'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
