#!/usr/bin/perl

use strict;
use warnings;
use FindBin;
use lib "$FindBin::Bin/../lib";
use lib "$FindBin::Bin/../t";

# Example showing both the main module and the alias
print "=== Crypt::TimestampedData vs Crypt::TSD ===\n\n";

# Method 1: Using the main module
print "1. Using Crypt::TimestampedData:\n";
use Crypt::TimestampedData;
my $tsd1 = Crypt::TimestampedData->new();
print "   Object: $tsd1\n";
print "   Class: " . ref($tsd1) . "\n\n";

# Method 2: Using the alias
print "2. Using Crypt::TSD (alias):\n";
use Crypt::TSD;
my $tsd2 = Crypt::TSD->new();
print "   Object: $tsd2\n";
print "   Class: " . ref($tsd2) . "\n\n";

# Both are the same class
print "3. Both objects are the same class:\n";
print "   tsd1 isa Crypt::TimestampedData: " . ($tsd1->isa('Crypt::TimestampedData') ? 'YES' : 'NO') . "\n";
print "   tsd1 isa Crypt::TSD: " . ($tsd1->isa('Crypt::TSD') ? 'YES' : 'NO') . "\n";
print "   tsd2 isa Crypt::TimestampedData: " . ($tsd2->isa('Crypt::TimestampedData') ? 'YES' : 'NO') . "\n";
print "   tsd2 isa Crypt::TSD: " . ($tsd2->isa('Crypt::TSD') ? 'YES' : 'NO') . "\n\n";

# Version check
print "4. Version information:\n";
print "   Crypt::TimestampedData version: $Crypt::TimestampedData::VERSION\n";
print "   Crypt::TSD version: $Crypt::TSD::VERSION\n";
print "   Versions match: " . ($Crypt::TimestampedData::VERSION eq $Crypt::TSD::VERSION ? 'YES' : 'NO') . "\n\n";

print "=== Usage Examples ===\n\n";

# Create a simple TSD structure
my $tsd_data = {
    version => 1,
    metaData => {
        hashProtected => 0,
        fileName => 'example.txt',
        mediaType => 'text/plain'
    },
    temporalEvidence => {
        tstEvidence => []
    }
};

print "5. Using Crypt::TSD for TSD operations:\n";

# Encode using alias
my $der = Crypt::TSD->encode_der($tsd_data);
print "   Encoded TSD to DER: " . length($der) . " bytes\n";

# Decode using alias
my $decoded = Crypt::TSD->decode_der($der);
print "   Decoded DER to TSD: " . ($decoded ? 'SUCCESS' : 'FAILED') . "\n";
print "   Version: " . $decoded->{version} . "\n";
print "   Filename: " . $decoded->{metaData}->{fileName} . "\n\n";

print "=== Summary ===\n";
print "Crypt::TSD is a convenient alias for Crypt::TimestampedData.\n";
print "Use whichever name you prefer - they are functionally identical!\n";
