//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_AUXILIARY_LACON_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_AUXILIARY_LACON_HPP

#include <boost/assert.hpp>
#include <boost/numeric/bindings/begin.hpp>
#include <boost/numeric/bindings/detail/array.hpp>
#include <boost/numeric/bindings/is_complex.hpp>
#include <boost/numeric/bindings/is_mutable.hpp>
#include <boost/numeric/bindings/is_real.hpp>
#include <boost/numeric/bindings/lapack/workspace.hpp>
#include <boost/numeric/bindings/remove_imaginary.hpp>
#include <boost/numeric/bindings/size.hpp>
#include <boost/numeric/bindings/stride.hpp>
#include <boost/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for lacon is the netlib-compatible backend.
//
#include <boost/numeric/bindings/lapack/detail/lapack.h>
#include <boost/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost {
namespace numeric {
namespace bindings {
namespace lapack {

//
// The detail namespace contains value-type-overloaded functions that
// dispatch to the appropriate back-end LAPACK-routine.
//
namespace detail {

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * float value-type.
//
inline std::ptrdiff_t lacon( const fortran_int_t n, float* v, float* x,
        fortran_int_t* isgn, float& est, fortran_int_t& kase ) {
    fortran_int_t info(0);
    LAPACK_SLACON( &n, v, x, isgn, &est, &kase );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * double value-type.
//
inline std::ptrdiff_t lacon( const fortran_int_t n, double* v, double* x,
        fortran_int_t* isgn, double& est, fortran_int_t& kase ) {
    fortran_int_t info(0);
    LAPACK_DLACON( &n, v, x, isgn, &est, &kase );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<float> value-type.
//
inline std::ptrdiff_t lacon( const fortran_int_t n, std::complex<float>* v,
        std::complex<float>* x, float& est, fortran_int_t& kase ) {
    fortran_int_t info(0);
    LAPACK_CLACON( &n, v, x, &est, &kase );
    return info;
}

//
// Overloaded function for dispatching to
// * netlib-compatible LAPACK backend (the default), and
// * complex<double> value-type.
//
inline std::ptrdiff_t lacon( const fortran_int_t n, std::complex<double>* v,
        std::complex<double>* x, double& est, fortran_int_t& kase ) {
    fortran_int_t info(0);
    LAPACK_ZLACON( &n, v, x, &est, &kase );
    return info;
}

} // namespace detail

//
// Value-type based template class. Use this class if you need a type
// for dispatching to lacon.
//
template< typename Value, typename Enable = void >
struct lacon_impl {};

//
// This implementation is enabled if Value is a real type.
//
template< typename Value >
struct lacon_impl< Value, typename boost::enable_if< is_real< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename VectorX, typename V, typename ISGN >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, detail::workspace2< V,
            ISGN > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorX >::value) );
        BOOST_ASSERT( bindings::size(work.select(fortran_int_t())) >=
                min_size_isgn( n ));
        BOOST_ASSERT( bindings::size(work.select(real_type())) >=
                min_size_v( n ));
        BOOST_ASSERT( n >= 1 );
        return detail::lacon( n,
                bindings::begin_value(work.select(real_type())),
                bindings::begin_value(x),
                bindings::begin_value(work.select(fortran_int_t())), est,
                kase );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename VectorX >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< real_type > tmp_v( min_size_v( n ) );
        bindings::detail::array<
                fortran_int_t > tmp_isgn( min_size_isgn( n ) );
        return invoke( n, x, est, kase, workspace( tmp_v, tmp_isgn ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename VectorX >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( n, x, est, kase, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array v.
    //
    static std::ptrdiff_t min_size_v( const std::ptrdiff_t n ) {
        return n;
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array isgn.
    //
    static std::ptrdiff_t min_size_isgn( const std::ptrdiff_t n ) {
        return n;
    }
};

//
// This implementation is enabled if Value is a complex type.
//
template< typename Value >
struct lacon_impl< Value, typename boost::enable_if< is_complex< Value > >::type > {

    typedef Value value_type;
    typedef typename remove_imaginary< Value >::type real_type;

    //
    // Static member function for user-defined workspaces, that
    // * Deduces the required arguments for dispatching to LAPACK, and
    // * Asserts that most arguments make sense.
    //
    template< typename VectorX, typename V >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, detail::workspace1<
            V > work ) {
        namespace bindings = ::boost::numeric::bindings;
        BOOST_STATIC_ASSERT( (bindings::is_mutable< VectorX >::value) );
        BOOST_ASSERT( bindings::size(work.select(value_type())) >=
                min_size_v( n ));
        BOOST_ASSERT( n >= 1 );
        return detail::lacon( n,
                bindings::begin_value(work.select(value_type())),
                bindings::begin_value(x), est, kase );
    }

    //
    // Static member function that
    // * Figures out the minimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member function
    // * Enables the unblocked algorithm (BLAS level 2)
    //
    template< typename VectorX >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, minimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        bindings::detail::array< value_type > tmp_v( min_size_v( n ) );
        return invoke( n, x, est, kase, workspace( tmp_v ) );
    }

    //
    // Static member function that
    // * Figures out the optimal workspace requirements, and passes
    //   the results to the user-defined workspace overload of the 
    //   invoke static member
    // * Enables the blocked algorithm (BLAS level 3)
    //
    template< typename VectorX >
    static std::ptrdiff_t invoke( const fortran_int_t n, VectorX& x,
            real_type& est, fortran_int_t& kase, optimal_workspace ) {
        namespace bindings = ::boost::numeric::bindings;
        return invoke( n, x, est, kase, minimal_workspace() );
    }

    //
    // Static member function that returns the minimum size of
    // workspace-array v.
    //
    static std::ptrdiff_t min_size_v( const std::ptrdiff_t n ) {
        return n;
    }
};


//
// Functions for direct use. These functions are overloaded for temporaries,
// so that wrapped types can still be passed and used for write-access. In
// addition, if applicable, they are overloaded for user-defined workspaces.
// Calls to these functions are passed to the lacon_impl classes. In the 
// documentation, most overloads are collapsed to avoid a large number of
// prototypes which are very similar.
//

//
// Overloaded function for lacon. Its overload differs for
// * User-defined workspace
//
template< typename VectorX, typename Workspace >
inline typename boost::enable_if< detail::is_workspace< Workspace >,
        std::ptrdiff_t >::type
lacon( const fortran_int_t n, VectorX& x, typename remove_imaginary<
        typename bindings::value_type< VectorX >::type >::type& est,
        fortran_int_t& kase, Workspace work ) {
    return lacon_impl< typename bindings::value_type<
            VectorX >::type >::invoke( n, x, est, kase, work );
}

//
// Overloaded function for lacon. Its overload differs for
// * Default workspace-type (optimal)
//
template< typename VectorX >
inline typename boost::disable_if< detail::is_workspace< VectorX >,
        std::ptrdiff_t >::type
lacon( const fortran_int_t n, VectorX& x, typename remove_imaginary<
        typename bindings::value_type< VectorX >::type >::type& est,
        fortran_int_t& kase ) {
    return lacon_impl< typename bindings::value_type<
            VectorX >::type >::invoke( n, x, est, kase, optimal_workspace() );
}

} // namespace lapack
} // namespace bindings
} // namespace numeric
} // namespace boost

#endif
