// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT
#![allow(deprecated)]

use crate::{
    ffi, Accessible, AccessibleRole, Adjustment, Align, Buildable, CellArea, CellLayout,
    CellRenderer, ConstraintTarget, IconViewDropPosition, LayoutManager, MovementStep, Orientation,
    Overflow, Scrollable, ScrollablePolicy, SelectionMode, Tooltip, TreeIter, TreeModel, TreePath,
    Widget,
};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkIconView")]
    pub struct IconView(Object<ffi::GtkIconView>) @extends Widget, @implements Accessible, Buildable, ConstraintTarget, CellLayout, Scrollable;

    match fn {
        type_ => || ffi::gtk_icon_view_get_type(),
    }
}

impl IconView {
    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_new")]
    pub fn new() -> IconView {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_icon_view_new()).unsafe_cast() }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area(area: &impl IsA<CellArea>) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model(model: &impl IsA<TreeModel>) -> IconView {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_icon_view_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`IconView`] objects.
    ///
    /// This method returns an instance of [`IconViewBuilder`](crate::builders::IconViewBuilder) which can be used to create [`IconView`] objects.
    pub fn builder() -> IconViewBuilder {
        IconViewBuilder::new()
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_create_drag_icon")]
    pub fn create_drag_icon(&self, path: &TreePath) -> Option<gdk::Paintable> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_create_drag_icon(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_enable_model_drag_dest")]
    pub fn enable_model_drag_dest(&self, formats: &gdk::ContentFormats, actions: gdk::DragAction) {
        unsafe {
            ffi::gtk_icon_view_enable_model_drag_dest(
                self.to_glib_none().0,
                formats.to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_enable_model_drag_source")]
    pub fn enable_model_drag_source(
        &self,
        start_button_mask: gdk::ModifierType,
        formats: &gdk::ContentFormats,
        actions: gdk::DragAction,
    ) {
        unsafe {
            ffi::gtk_icon_view_enable_model_drag_source(
                self.to_glib_none().0,
                start_button_mask.into_glib(),
                formats.to_glib_none().0,
                actions.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_activate_on_single_click")]
    #[doc(alias = "get_activate_on_single_click")]
    #[doc(alias = "activate-on-single-click")]
    pub fn activates_on_single_click(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_activate_on_single_click(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_cell_rect")]
    #[doc(alias = "get_cell_rect")]
    pub fn cell_rect(
        &self,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
    ) -> Option<gdk::Rectangle> {
        unsafe {
            let mut rect = gdk::Rectangle::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_cell_rect(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                rect.to_glib_none_mut().0,
            ));
            if ret {
                Some(rect)
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_column_spacing")]
    #[doc(alias = "get_column_spacing")]
    #[doc(alias = "column-spacing")]
    pub fn column_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_column_spacing(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_columns")]
    #[doc(alias = "get_columns")]
    pub fn columns(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_columns(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_cursor")]
    #[doc(alias = "get_cursor")]
    pub fn cursor(&self) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = std::ptr::null_mut();
            let mut cell = std::ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_cursor(
                self.to_glib_none().0,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_dest_item_at_pos")]
    #[doc(alias = "get_dest_item_at_pos")]
    pub fn dest_item_at_pos(
        &self,
        drag_x: i32,
        drag_y: i32,
    ) -> Option<(TreePath, IconViewDropPosition)> {
        unsafe {
            let mut path = std::ptr::null_mut();
            let mut pos = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_icon_view_get_dest_item_at_pos(
                self.to_glib_none().0,
                drag_x,
                drag_y,
                &mut path,
                pos.as_mut_ptr(),
            ));
            if ret {
                Some((from_glib_full(path), from_glib(pos.assume_init())))
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_drag_dest_item")]
    #[doc(alias = "get_drag_dest_item")]
    pub fn drag_dest_item(&self) -> (Option<TreePath>, IconViewDropPosition) {
        unsafe {
            let mut path = std::ptr::null_mut();
            let mut pos = std::mem::MaybeUninit::uninit();
            ffi::gtk_icon_view_get_drag_dest_item(
                self.to_glib_none().0,
                &mut path,
                pos.as_mut_ptr(),
            );
            (from_glib_full(path), from_glib(pos.assume_init()))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_at_pos")]
    #[doc(alias = "get_item_at_pos")]
    pub fn item_at_pos(&self, x: i32, y: i32) -> Option<(TreePath, CellRenderer)> {
        unsafe {
            let mut path = std::ptr::null_mut();
            let mut cell = std::ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_item_at_pos(
                self.to_glib_none().0,
                x,
                y,
                &mut path,
                &mut cell,
            ));
            if ret {
                Some((from_glib_full(path), from_glib_none(cell)))
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_column")]
    #[doc(alias = "get_item_column")]
    pub fn item_column(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_column(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_orientation")]
    #[doc(alias = "get_item_orientation")]
    #[doc(alias = "item-orientation")]
    pub fn item_orientation(&self) -> Orientation {
        unsafe {
            from_glib(ffi::gtk_icon_view_get_item_orientation(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_padding")]
    #[doc(alias = "get_item_padding")]
    #[doc(alias = "item-padding")]
    pub fn item_padding(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_padding(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_row")]
    #[doc(alias = "get_item_row")]
    pub fn item_row(&self, path: &TreePath) -> i32 {
        unsafe {
            ffi::gtk_icon_view_get_item_row(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            )
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_item_width")]
    #[doc(alias = "get_item_width")]
    #[doc(alias = "item-width")]
    pub fn item_width(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_item_width(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_margin")]
    #[doc(alias = "get_margin")]
    pub fn margin(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_margin(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_markup_column")]
    #[doc(alias = "get_markup_column")]
    #[doc(alias = "markup-column")]
    pub fn markup_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_markup_column(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_model")]
    #[doc(alias = "get_model")]
    pub fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_icon_view_get_model(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_path_at_pos")]
    #[doc(alias = "get_path_at_pos")]
    pub fn path_at_pos(&self, x: i32, y: i32) -> Option<TreePath> {
        unsafe {
            from_glib_full(ffi::gtk_icon_view_get_path_at_pos(
                self.to_glib_none().0,
                x,
                y,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_pixbuf_column")]
    #[doc(alias = "get_pixbuf_column")]
    #[doc(alias = "pixbuf-column")]
    pub fn pixbuf_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_pixbuf_column(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_reorderable")]
    #[doc(alias = "get_reorderable")]
    #[doc(alias = "reorderable")]
    pub fn is_reorderable(&self) -> bool {
        unsafe { from_glib(ffi::gtk_icon_view_get_reorderable(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_row_spacing")]
    #[doc(alias = "get_row_spacing")]
    #[doc(alias = "row-spacing")]
    pub fn row_spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_row_spacing(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_selected_items")]
    #[doc(alias = "get_selected_items")]
    pub fn selected_items(&self) -> Vec<TreePath> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_icon_view_get_selected_items(
                self.to_glib_none().0,
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_selection_mode")]
    #[doc(alias = "get_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn selection_mode(&self) -> SelectionMode {
        unsafe { from_glib(ffi::gtk_icon_view_get_selection_mode(self.to_glib_none().0)) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_spacing")]
    #[doc(alias = "get_spacing")]
    pub fn spacing(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_spacing(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_text_column")]
    #[doc(alias = "get_text_column")]
    #[doc(alias = "text-column")]
    pub fn text_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_text_column(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_tooltip_column")]
    #[doc(alias = "get_tooltip_column")]
    #[doc(alias = "tooltip-column")]
    pub fn tooltip_column(&self) -> i32 {
        unsafe { ffi::gtk_icon_view_get_tooltip_column(self.to_glib_none().0) }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_tooltip_context")]
    #[doc(alias = "get_tooltip_context")]
    pub fn tooltip_context(
        &self,
        x: i32,
        y: i32,
        keyboard_tip: bool,
    ) -> Option<(TreeModel, TreePath, TreeIter)> {
        unsafe {
            let mut model = std::ptr::null_mut();
            let mut path = std::ptr::null_mut();
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_icon_view_get_tooltip_context(
                self.to_glib_none().0,
                x,
                y,
                keyboard_tip.into_glib(),
                &mut model,
                &mut path,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some((from_glib_none(model), from_glib_full(path), iter))
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_get_visible_range")]
    #[doc(alias = "get_visible_range")]
    pub fn visible_range(&self) -> Option<(TreePath, TreePath)> {
        unsafe {
            let mut start_path = std::ptr::null_mut();
            let mut end_path = std::ptr::null_mut();
            let ret = from_glib(ffi::gtk_icon_view_get_visible_range(
                self.to_glib_none().0,
                &mut start_path,
                &mut end_path,
            ));
            if ret {
                Some((from_glib_full(start_path), from_glib_full(end_path)))
            } else {
                None
            }
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_item_activated")]
    pub fn item_activated(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_item_activated(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_path_is_selected")]
    pub fn path_is_selected(&self, path: &TreePath) -> bool {
        unsafe {
            from_glib(ffi::gtk_icon_view_path_is_selected(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            ))
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_scroll_to_path")]
    pub fn scroll_to_path(&self, path: &TreePath, use_align: bool, row_align: f32, col_align: f32) {
        unsafe {
            ffi::gtk_icon_view_scroll_to_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                use_align.into_glib(),
                row_align,
                col_align,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_select_all")]
    pub fn select_all(&self) {
        unsafe {
            ffi::gtk_icon_view_select_all(self.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_select_path")]
    pub fn select_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_select_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_selected_foreach")]
    pub fn selected_foreach<P: FnMut(&IconView, &TreePath)>(&self, func: P) {
        let mut func_data: P = func;
        unsafe extern "C" fn func_func<P: FnMut(&IconView, &TreePath)>(
            icon_view: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            data: glib::ffi::gpointer,
        ) {
            let icon_view = from_glib_borrow(icon_view);
            let path = from_glib_borrow(path);
            let callback = data as *mut P;
            (*callback)(&icon_view, &path)
        }
        let func = Some(func_func::<P> as _);
        let super_callback0: &mut P = &mut func_data;
        unsafe {
            ffi::gtk_icon_view_selected_foreach(
                self.to_glib_none().0,
                func,
                super_callback0 as *mut _ as *mut _,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_activate_on_single_click")]
    #[doc(alias = "activate-on-single-click")]
    pub fn set_activate_on_single_click(&self, single: bool) {
        unsafe {
            ffi::gtk_icon_view_set_activate_on_single_click(
                self.to_glib_none().0,
                single.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_column_spacing")]
    #[doc(alias = "column-spacing")]
    pub fn set_column_spacing(&self, column_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_column_spacing(self.to_glib_none().0, column_spacing);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_columns")]
    #[doc(alias = "columns")]
    pub fn set_columns(&self, columns: i32) {
        unsafe {
            ffi::gtk_icon_view_set_columns(self.to_glib_none().0, columns);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_cursor")]
    pub fn set_cursor(
        &self,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
        start_editing: bool,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_cursor(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
                start_editing.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_drag_dest_item")]
    pub fn set_drag_dest_item(&self, path: Option<&TreePath>, pos: IconViewDropPosition) {
        unsafe {
            ffi::gtk_icon_view_set_drag_dest_item(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                pos.into_glib(),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_item_orientation")]
    #[doc(alias = "item-orientation")]
    pub fn set_item_orientation(&self, orientation: Orientation) {
        unsafe {
            ffi::gtk_icon_view_set_item_orientation(self.to_glib_none().0, orientation.into_glib());
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_item_padding")]
    #[doc(alias = "item-padding")]
    pub fn set_item_padding(&self, item_padding: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_padding(self.to_glib_none().0, item_padding);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_item_width")]
    #[doc(alias = "item-width")]
    pub fn set_item_width(&self, item_width: i32) {
        unsafe {
            ffi::gtk_icon_view_set_item_width(self.to_glib_none().0, item_width);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_margin")]
    #[doc(alias = "margin")]
    pub fn set_margin(&self, margin: i32) {
        unsafe {
            ffi::gtk_icon_view_set_margin(self.to_glib_none().0, margin);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_markup_column")]
    #[doc(alias = "markup-column")]
    pub fn set_markup_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_markup_column(self.to_glib_none().0, column);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_model")]
    #[doc(alias = "model")]
    pub fn set_model(&self, model: Option<&impl IsA<TreeModel>>) {
        unsafe {
            ffi::gtk_icon_view_set_model(
                self.to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_pixbuf_column")]
    #[doc(alias = "pixbuf-column")]
    pub fn set_pixbuf_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_pixbuf_column(self.to_glib_none().0, column);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_reorderable")]
    #[doc(alias = "reorderable")]
    pub fn set_reorderable(&self, reorderable: bool) {
        unsafe {
            ffi::gtk_icon_view_set_reorderable(self.to_glib_none().0, reorderable.into_glib());
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_row_spacing")]
    #[doc(alias = "row-spacing")]
    pub fn set_row_spacing(&self, row_spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_row_spacing(self.to_glib_none().0, row_spacing);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_selection_mode")]
    #[doc(alias = "selection-mode")]
    pub fn set_selection_mode(&self, mode: SelectionMode) {
        unsafe {
            ffi::gtk_icon_view_set_selection_mode(self.to_glib_none().0, mode.into_glib());
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_spacing")]
    #[doc(alias = "spacing")]
    pub fn set_spacing(&self, spacing: i32) {
        unsafe {
            ffi::gtk_icon_view_set_spacing(self.to_glib_none().0, spacing);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_text_column")]
    #[doc(alias = "text-column")]
    pub fn set_text_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_text_column(self.to_glib_none().0, column);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_tooltip_cell")]
    pub fn set_tooltip_cell(
        &self,
        tooltip: &Tooltip,
        path: &TreePath,
        cell: Option<&impl IsA<CellRenderer>>,
    ) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_cell(
                self.to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
                cell.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_tooltip_column")]
    #[doc(alias = "tooltip-column")]
    pub fn set_tooltip_column(&self, column: i32) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_column(self.to_glib_none().0, column);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_set_tooltip_item")]
    pub fn set_tooltip_item(&self, tooltip: &Tooltip, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_set_tooltip_item(
                self.to_glib_none().0,
                tooltip.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_unselect_all")]
    pub fn unselect_all(&self) {
        unsafe {
            ffi::gtk_icon_view_unselect_all(self.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_unselect_path")]
    pub fn unselect_path(&self, path: &TreePath) {
        unsafe {
            ffi::gtk_icon_view_unselect_path(
                self.to_glib_none().0,
                mut_override(path.to_glib_none().0),
            );
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_unset_model_drag_dest")]
    pub fn unset_model_drag_dest(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_dest(self.to_glib_none().0);
        }
    }

    #[cfg_attr(feature = "v4_10", deprecated = "Since 4.10")]
    #[allow(deprecated)]
    #[doc(alias = "gtk_icon_view_unset_model_drag_source")]
    pub fn unset_model_drag_source(&self) {
        unsafe {
            ffi::gtk_icon_view_unset_model_drag_source(self.to_glib_none().0);
        }
    }

    #[doc(alias = "cell-area")]
    pub fn cell_area(&self) -> Option<CellArea> {
        ObjectExt::property(self, "cell-area")
    }

    #[doc(alias = "activate-cursor-item")]
    pub fn connect_activate_cursor_item<F: Fn(&Self) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_cursor_item_trampoline<F: Fn(&IconView) -> bool + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this)).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"activate-cursor-item".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_activate_cursor_item(&self) -> bool {
        self.emit_by_name("activate-cursor-item", &[])
    }

    #[doc(alias = "item-activated")]
    pub fn connect_item_activated<F: Fn(&Self, &TreePath) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn item_activated_trampoline<F: Fn(&IconView, &TreePath) + 'static>(
            this: *mut ffi::GtkIconView,
            path: *mut ffi::GtkTreePath,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(path))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"item-activated".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    item_activated_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "move-cursor")]
    pub fn connect_move_cursor<F: Fn(&Self, MovementStep, i32, bool, bool) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn move_cursor_trampoline<
            F: Fn(&IconView, MovementStep, i32, bool, bool) -> bool + 'static,
        >(
            this: *mut ffi::GtkIconView,
            step: ffi::GtkMovementStep,
            count: std::ffi::c_int,
            extend: glib::ffi::gboolean,
            modify: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                &from_glib_borrow(this),
                from_glib(step),
                count,
                from_glib(extend),
                from_glib(modify),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"move-cursor".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    move_cursor_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_move_cursor(
        &self,
        step: MovementStep,
        count: i32,
        extend: bool,
        modify: bool,
    ) -> bool {
        self.emit_by_name("move-cursor", &[&step, &count, &extend, &modify])
    }

    #[doc(alias = "select-all")]
    pub fn connect_select_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_all_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"select-all".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    select_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_select_all(&self) {
        self.emit_by_name::<()>("select-all", &[]);
    }

    #[doc(alias = "select-cursor-item")]
    pub fn connect_select_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn select_cursor_item_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"select-cursor-item".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    select_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_select_cursor_item(&self) {
        self.emit_by_name::<()>("select-cursor-item", &[]);
    }

    #[doc(alias = "selection-changed")]
    pub fn connect_selection_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn selection_changed_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"selection-changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    selection_changed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "toggle-cursor-item")]
    pub fn connect_toggle_cursor_item<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn toggle_cursor_item_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"toggle-cursor-item".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    toggle_cursor_item_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_toggle_cursor_item(&self) {
        self.emit_by_name::<()>("toggle-cursor-item", &[]);
    }

    #[doc(alias = "unselect-all")]
    pub fn connect_unselect_all<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn unselect_all_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"unselect-all".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    unselect_all_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_unselect_all(&self) {
        self.emit_by_name::<()>("unselect-all", &[]);
    }

    #[doc(alias = "activate-on-single-click")]
    pub fn connect_activate_on_single_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_activate_on_single_click_trampoline<
            F: Fn(&IconView) + 'static,
        >(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::activate-on-single-click".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_activate_on_single_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "column-spacing")]
    pub fn connect_column_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::column-spacing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_column_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "columns")]
    pub fn connect_columns_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_columns_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::columns".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_columns_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-orientation")]
    pub fn connect_item_orientation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_orientation_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::item-orientation".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_item_orientation_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-padding")]
    pub fn connect_item_padding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_padding_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::item-padding".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_item_padding_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "item-width")]
    pub fn connect_item_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_item_width_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::item-width".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_item_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "margin")]
    pub fn connect_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_margin_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::margin".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_margin_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "markup-column")]
    pub fn connect_markup_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_markup_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::markup-column".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_markup_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "model")]
    pub fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::model".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_model_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "pixbuf-column")]
    pub fn connect_pixbuf_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixbuf_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::pixbuf-column".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_pixbuf_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "reorderable")]
    pub fn connect_reorderable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reorderable_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::reorderable".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_reorderable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "row-spacing")]
    pub fn connect_row_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::row-spacing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_row_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "selection-mode")]
    pub fn connect_selection_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selection_mode_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::selection-mode".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_selection_mode_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "spacing")]
    pub fn connect_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_spacing_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::spacing".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_spacing_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "text-column")]
    pub fn connect_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::text-column".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_text_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "tooltip-column")]
    pub fn connect_tooltip_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tooltip_column_trampoline<F: Fn(&IconView) + 'static>(
            this: *mut ffi::GtkIconView,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::tooltip-column".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_tooltip_column_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for IconView {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`IconView`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct IconViewBuilder {
    builder: glib::object::ObjectBuilder<'static, IconView>,
}

impl IconViewBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn activate_on_single_click(self, activate_on_single_click: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("activate-on-single-click", activate_on_single_click),
        }
    }

    pub fn cell_area(self, cell_area: &impl IsA<CellArea>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-area", cell_area.clone().upcast()),
        }
    }

    pub fn column_spacing(self, column_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("column-spacing", column_spacing),
        }
    }

    pub fn columns(self, columns: i32) -> Self {
        Self {
            builder: self.builder.property("columns", columns),
        }
    }

    pub fn item_orientation(self, item_orientation: Orientation) -> Self {
        Self {
            builder: self.builder.property("item-orientation", item_orientation),
        }
    }

    pub fn item_padding(self, item_padding: i32) -> Self {
        Self {
            builder: self.builder.property("item-padding", item_padding),
        }
    }

    pub fn item_width(self, item_width: i32) -> Self {
        Self {
            builder: self.builder.property("item-width", item_width),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn markup_column(self, markup_column: i32) -> Self {
        Self {
            builder: self.builder.property("markup-column", markup_column),
        }
    }

    pub fn model(self, model: &impl IsA<TreeModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    pub fn pixbuf_column(self, pixbuf_column: i32) -> Self {
        Self {
            builder: self.builder.property("pixbuf-column", pixbuf_column),
        }
    }

    pub fn reorderable(self, reorderable: bool) -> Self {
        Self {
            builder: self.builder.property("reorderable", reorderable),
        }
    }

    pub fn row_spacing(self, row_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("row-spacing", row_spacing),
        }
    }

    pub fn selection_mode(self, selection_mode: SelectionMode) -> Self {
        Self {
            builder: self.builder.property("selection-mode", selection_mode),
        }
    }

    pub fn spacing(self, spacing: i32) -> Self {
        Self {
            builder: self.builder.property("spacing", spacing),
        }
    }

    pub fn text_column(self, text_column: i32) -> Self {
        Self {
            builder: self.builder.property("text-column", text_column),
        }
    }

    pub fn tooltip_column(self, tooltip_column: i32) -> Self {
        Self {
            builder: self.builder.property("tooltip-column", tooltip_column),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`IconView`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> IconView {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
