/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef hmac_sha3_512_vectors_h__
#define hmac_sha3_512_vectors_h__

#include "testvectors_base/test-structs.h"

const HmacTestVector kHmacSha3512WycheproofVectors[] = {
    {1, "empty message",
     "5365244bb43f23f18dfc86c09d62db4741138bec1fbddc282d295e0a098eb5c3e37bd6f4c"
     "c16d5ce7d77b1d474a1eb4db313cc0c24e48992ac125196549df9a8",
     "",
     "8327dc85e33898f05724b34a89dfc74f2581b228203ff148f7c86aa328e0e5330c00015d1"
     "d983ab005fbc18d3695f2dd5f304bab7a4b7c34f6d010ca0af1acf5",
     false},

    {2, "short message",
     "00698977f7102c67b594166919aa99dc3e58c7b6697a6422e238d04d2f57b2c74e4e84f5c"
     "4c6b792952df72f1c09244802f0bcf8752efb90e836110703bfa21c",
     "01",
     "84185a2890b3f4c5ef8723c292db676c69104e7ff7def5ecf26928a41626d2b16b063d8a9"
     "df03917498467f5abd7af3c6c732957f67cb800a517b26963142a1d",
     false},

    {3, "short message",
     "ed6dc65dbeaadbdaab530a0d35f19f78a7bd93e698546c82751bf650c2a44fc8529033d08"
     "8febeed288fb4c8132a59df0207687640c76dcdb270ac3af5f042f1",
     "a78f",
     "b4805d3a32d4dcc2e08178889173e65d3fa1d3b3f3bb688a46c8793386e7136e6caa55581"
     "e04dbc01b561b8fa3ab6bf71121df6e5a51aec6b2f253df99d16bf7",
     false},

    {4, "short message",
     "463c5e696da0ec0d784388be775d1d91d94746aa8d3d2c209f56ac95ea54e7288329f9fb4"
     "0be4eef35547e64c61dc51a4a1f3380a2b96420f088655ea9d85b97",
     "e956c1",
     "30d4794d0f072622d4a326dc9957974ab5ee5e403c8e8ed673911b95838331e99ff8dfd16"
     "defedeb696f1c661a0094685dbb6c8604c072a1bb088b9e8cd55d9c",
     false},

    {5, "short message",
     "4bc0d32e945cfdafd20d39be3820f9649727cbda5ab5859953a322cbde1ab7a514d7dcd14"
     "ba90905e70919bb86b85cfeaa375ee2ce2703711b938c8f4ab5f178",
     "b2aa48b3",
     "6daf3dad42636bfd962246b0b314c939a4fd0a9ae46efec848a56bb6b85de6c47b6024364"
     "4aa5e4658a4042f8577b388bdf544e120fb32b1af10f0f84b8ae4ca",
     false},

    {6, "short message",
     "aca47f6350941a0efd8c3bac9064a554be337cde7d192f6fbf86d1b4db09b36531165cbae"
     "0a634206f71fa400df33352fff60e1fba4009ac6671cd37312bdd98",
     "bc993b1db0",
     "d448310d37fbc2c5d26d6ceceb999a2551793691f36019d88db99d041b0cdb6fbdb40c13b"
     "76a235713a59bcbd140c99e5612d3c2ef66dc0fb41586a6c384279a",
     false},

    {7, "short message",
     "b3ecae6f25c2f699f158b3ffcd0a7a575583e4c9cb56b5c22ef4273cde6c6734e84d74007"
     "49c17e47e8cfccafaf8b50c65eb47dfeb273d5d30a1181e37b27ad0",
     "f0361d58291e",
     "5d3b47454f71949a441c59a20b0a56b6b2aa4c256e1c6e128c5eb201c68e63da130ad6959"
     "4126ff789fa471e2e51de73ea57f75ce2a1e2c9d02eabdf55153228",
     false},

    {8, "short message",
     "70ff24a252d65183bdc6b7c88751f850821141a61246727c3240b4f96088ae3278767a822"
     "b65735a28ccebe4c874bcb2c942882cb23f9dd87fe08fbaad5ae72f",
     "e18da3ebf0ffa4",
     "253a4f223cac5e24b4ffb9b21a325d7645192203cacabfe18d3299010a7d203eb1ef53195"
     "47f140840a9742d4907b7fafb4d1ef1b54f26682ac98e3a37c03a89",
     false},

    {9, "short message",
     "dd4e05933d09711ee88cb4c1ceb3600b2b33808bc08d499387b331d9c7af49bc65b55172c"
     "f8083385a940e4b864b7b4b73ddf3bd513a6cbcac73878a879b4d06",
     "66948029351432c3",
     "88db64f580e7e2bcf9329007e2831c6764541331679ea4493b24507dc72a3f9ac8fb5dac7"
     "e08799d139f74a0c163cf0456552ff12d14785f3deb29278c3ba679",
     false},

    {10, "short message",
     "fbd32caf8984fc4376d10daa7288db8e6e74464bdd94b448adab4497b319e9a6dcce542f8"
     "2a7ff2e775d12477c880e460a9eab8efc49fcfc8c5476cb4b08954a",
     "38a2586a2883953cc4",
     "9a0f3c3829a11186c69d88433785b784e1dcbd955be679649a89158396cf91fdf26e73a27"
     "c3bc5325f6710c421d8cbeb5922af2cfeb7232fb6929c00d8190922",
     false},

    {11, "short message",
     "fd4c3f6b2137513616c28ed4d8638f867ad0b97188b73fc9b36f3d52b82d72a49b9dc1b8b"
     "25397eb448054a8d38d838e7a88b4df9c263aea1b968771d5ac5756",
     "86b4e61b3b7d650044ad",
     "e97bd7a78267ac6b575da2f7364448efef8dc7dd4f9a44d0454b021f59957cf620bbae47f"
     "0d3b7dec2bf4d153bada472472685a35228970fc99dcceb14f34dd5",
     false},

    {12, "short message",
     "f95baea535f477d22b405c67d927f59a9e042c46297a1681bcc16fdbe1b2cd59675a22135"
     "1a78075981e7eb4998066768801cbd7a85231114d7f27f9bdf24899",
     "5a34dee4e0982d458efffb",
     "f6d382a7782c1a63ad98897dd2616bf29e46b1e430b7d69d02df4f640c9c1e8faf677633d"
     "86f639f6834e1599927d9aa23f49fd4fb66085eb56968f9b7b9fb3c",
     false},

    {13, "short message",
     "4d76ae95a123207e01c6d22d8b587e63ba682963e50961afff531160a9b9aac6c772c5e8b"
     "f918ddecbeb56455ea64710e51ac21e3bb9af4b24eaa8535b3c2924",
     "2c31f2d986f68a6d6a96c4b0",
     "0e4081af61c51dc831ba0448efa24f0ce6e05bdc38e11ef03a4456164542f28dc38368d30"
     "8dde117087a86aead3b4fd4ad8cff00c5ab93539281bee27f7e5ae1",
     false},

    {14, "short message",
     "0da7fa1f5d217951e3e343cda81f232deb71764eb49e8510bc28dba8eb62afa2a98b6f053"
     "6adb10250c74878fe649f47bbafdf3f722fa150f66e83f65f606ab0",
     "83511de190663c9c4229ace901",
     "bd1000dcd41ed8aac4edbb818884ddbea01c0cb60a202427a977489c310bbb10dd3a96ad8"
     "58702d6ac5edb3431f780c2201920deaf760c719e64c6e390f7911c",
     false},

    {15, "short message",
     "cec9e9f25ed9a017004a7882b1e44e8bd8fa3203c50cb6058455ed4f2a036788d46fcd328"
     "327d0d86b1abae69f7bbb96e3d66373ec8bd45075890879a83f4d33",
     "80dcd8ba66f98b51094144e9b8bd",
     "9920662e0b60073916ec0cb17c9f0a62de7f1f193eb6a9ef52870c93cd9697dfdc13fd2b7"
     "ba7664138b037f7e63023865be898c2f4bec6bde9ea8ee1b69b2563",
     false},

    {16, "short message",
     "bbe25649ecdf54ae0028fb923cc8c28ec00e10e2d44214590781238a143b75d54efb037eb"
     "9f53082a8ab3d8876daf4dbdc2483c4ba222797fe20da3b7730368b",
     "33f630088c0d24cda98caff1a3afc7",
     "00eaa766f4f3d92047b5e85efc9288cb8a5a2b56d2267dbfd5b16d8c918ed9404314aadde"
     "a241bbc966e49b2368232129d1edd06d99bf93bc57291b896bae485",
     false},

    {17, "",
     "f5e2b9e2313f4f807cb3a924a7d4943fc3fb475d8f1a1b40ce09a37770f621af8977729ca"
     "df986c98c75f08a4fab4280538e09e7e51e87a8d62c03411bdb8d24",
     "74ef623c83275ae99745bff7e6142afa",
     "8d0acc11d6c6992ad16a5e7070236a1000b0f1ccd1c98849eeca395a0daf5f404c8d27225"
     "7ecbf8bd84c42de302fe368d6c308e4639f2ecd2d91f3dda6a0d8e6",
     false},

    {18, "",
     "8e323d5fb4752d92a6d905c512b287d07b21ae50002d026ff0388e1593bde9998dd02321e"
     "200d148f5fa2e824b37e9f5a77441794b840bedd552d1051c1ddd8c",
     "4daa229b009b8984354c2ec3e7973e0042",
     "b9395c2b7e360385ccb3da590b17279e121f92fd85660e802e24dd92998b2e531d3aa911c"
     "3ca389b515620b6bd3f97b63df7ebbd10b639799952927d1c2dc360",
     false},

    {19, "",
     "465bc1ab2125cca29729d01df044e393b0677defdd939280a3aa141224efa06457e623056"
     "d02f6c36eca3dfc4a7476dd36b97d0c2d60c7672129189e73b6af8f",
     "dd84599b47ba9ae9f2ad0c8eac678485433eb6b1dfb7c998",
     "7072471ab504696f060a3bded10e657e3bc6bad2e0f8239fd4f17e35174c2acbf059aa7d8"
     "5b3b3adf3d644e0bceba93490a54948138e743091d5225bdbddf6ae",
     false},

    {20, "",
     "b90226798dff2ffb91d1ee4103f26397d0bf84c13c1ec717392c5fe1d4d0f4dc790236d75"
     "9fa1be852e305da585a3dbde0d3912bea60d6b140c25645eb00943f",
     "aa29c372f136993c65ace5e1d62078806eb787913bb35af33371056359d354b2",
     "8d6ef6ea9bf61d3e39535b1f3759c01da28d9ff7370491de117a520188e15a152050371d5"
     "33ff4b927fd91bd33a6c7404cce34ce4701fc7a8f03ebf70ad188ba",
     false},

    {21, "long message",
     "af1bb91775cb40c73983f119c927a2ce8f7b954a6274ecc1cd96019e5c417af4b09437619"
     "4eae71c7f68f3345654d5d9f8198a697b41ae251e82308accd935bd",
     "75ededdfa7f1df1dc144fb195b27e454640e3f897cb564222f05e8aab0c6024f90472afea"
     "6e7254ed25134ea43452a",
     "cd3075b66d5fb6d90cd9384cd1aeea9a2c67a59bc5a71b9b1e5ef5407ed58229baa67d3e9"
     "f9895de320b421a6670210288afe2da4ae4845ab069501185b76ca0",
     false},

    {22, "long message",
     "513e0e7622eabcb6bfc81669dac903df46daea1240f32248bbf4fc61f1f9b13b2c3fe1bcc"
     "97540d30065be9eee41e51748bc42c16a8c8269fbe2b6f625c19228",
     "81d8650937f50871a66af71605ea4fa9d6c5d7a375774c2280eb34aefcee8c0ef83345bc5"
     "47e4de7cbea482369b25a93",
     "f7b263b7c2380d0ba70844d2e6e56dfd68fabf7ec9af5c8ba897ae4e9d308aa28ff7a10ba"
     "4d37525e858074093ae8b15908de22be70e3f0b23dc61c39b17ab39",
     false},

    {23, "long message",
     "627c9a72247d07b0cec8346277468311c7401fc4cecaea8e22e13ece4b352c8f7a7eb1ba8"
     "1ce348a08670438c97b8d9e883614d550f1ff16d636975c59988c2d",
     "118e0468cbb52f93a3396ebfaa114881a98a4101f4ff912ced47ecfc73b27f52205b7a5d4"
     "f3899506f9e34ebf99460da7a",
     "050b55346ab112e0ba62409f3bb48f7099a5098e2ccb2d18e47b5171029f43f9a011fa1b1"
     "34b6412fb9df161abf295405ba3e212657d7420ee831885e71a324b",
     false},

    {24, "long message",
     "1e981d0cbbad5bea9480d836b4704bf3147663b6ea59e1e0a280fb45d9b85d445dc972159"
     "dde301c6f1e66681f95642dbb9a9218c00d0cd724cb02f3bcaea2ea",
     "440dff390688c9fde31c17fdb61c1d13899f9544a986324c34d5eb07bef9a4436297f4a7f"
     "e16de5dd7b24e0c7c129051efe6f2dd0a21aec05c3e3c8f6fa30d9c0cbd60d840d14f0b2a"
     "928bc7189b9de4a6a731151d6b31e6a0ecae75095434737be8c3db11a6a697d0616c78b97"
     "041de",
     "4a7a1d6b15ee94410325362980df659b5f72598faa1963c3f129800439e7a7148f9f1f603"
     "1f7d0f3c0a8b8a248c5f5ea88a3544def2b30553061533ebfb47997",
     false},

    {25, "long message",
     "ee8aea2a52eb7e0c1120ab736b1a825b12610063de9642c594766c020cb87314d8ac94b13"
     "072bfbf3c019b4aacb1d2695cdd7563a26f574e12559906784d853c",
     "a3951f1d18135602fdadceeef5741c24ad22756160d0c55e51b788af952adaeb13e18c24c"
     "6b09672f405d7ec3d49b0bd86c7f8691b6f69af49175423215cf57d7c08a54ab0b0293e68"
     "5c9aa250f1599d78193a00af822dec4b56fdb41f0343ab2cf85ea27bb2e650930f5e8ca83"
     "6833903b053b3e06899b4012a6532978d90",
     "741d2fef6b194913b7b6c5431d36cd80f5985480b37a8198f60e0a96bb56d89780b87d8bc"
     "3feb03d29fecc28dfa285f052eec5d0f9cfcb7c9cfed200ae60d0f8",
     false},

    {26, "long message",
     "ecd1861a12eaee48aef1d7ed278223b50d3416dbff81e976c56ecd4b1a1bc8892b584cbcc"
     "72370ff5e976a6af1790caa32f9ea912855914c0315979578fbf165",
     "5779c56373a8e5db43bd65c0453ce23144230d43666d717a3b59d2e90f0e10732376831d7"
     "281cb23dd5566e5f8c627d00d39650139ceb87cd47e921d65d6c1cc7712ac4bd75bda8828"
     "e68abc968f4160ed91b28946c9d706b0360bbbdd65f47ef9983c50f2d09d05c3674c0943e"
     "a4af54c381089f9b846dd69ce908e0f6eaaaf",
     "e5d84c73db427dbda25d546c5ef17a1a7a7c194b745f42ff6abf5821bfb0a9b778bfc2e0e"
     "74871c7bbf645e3a4f735c135d7a83b15bfee39bd5f6cbd68c91e4f",
     false},

    {27, "long message",
     "71aadbf330ea133b46c939d12e603896902e8df638597c98872dfb5aecd5161bc84095221"
     "de3222367012f45c6d70701e862ab000e782e91b505b21b4e212c38",
     "e6d7b0280d2f7df83fd26562fcdea2597cf687a9c9fa194f655c44d3271b881f28adc436d"
     "b8e0437ff4dc5d38356271c338829c3e2d9ba4ac1777c94886983d4b72c275bc00e4f7b06"
     "c5ce38a2fe549fe53761857f236da705fd03790b41cc6f759f41aa206feca7ba5486f4fc9"
     "d09f35c8e0887241291882010414ae41b8b384a715a409be13da17bfd60d3fbd4b8cb3cc7"
     "c26043807264a20b9a5c02725e742fff03e1806b38af357ebf8c79fc4c38b007bf0613286"
     "cf063e45482375475e6c426d4f70057cd92efcb2dfe86e45bdea399273a5e0f142221fae2"
     "06800555c01b18533295f577e23a9a7a0aa072823002b9096501174d3bc4aac33e0dc600",
     "e6e46495538a977dc006dcdaeb115dad0b88706ad7b80e46f57ea8f910d75c810edc7e7e0"
     "b92d129846aec9baef99a2ae8b580825037db6068f760334519689f",
     false},

    {28, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "617063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {29, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {30, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "627063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {31, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7dc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {32, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "e07063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {33, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ffc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {34, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607163701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {35, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc9b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {36, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063f01a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {37, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b60b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {38, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701b568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {39, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4448c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {40, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "6070637018568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {41, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4748c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {42, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a5685d9228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {43, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c1af71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {44, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559238544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {45, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f70be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {46, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559a28544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {47, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12ff1be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {48, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a56855922a544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {49, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f719e13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {50, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228545d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {51, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be12428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {52, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63b27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {53, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428dbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {54, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63827d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {55, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428ebb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {56, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d6ba27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {57, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13420cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {58, "Flipped bit 504 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a75",
     true},

    {59, "Flipped bit 504 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41981",
     true},

    {60, "Flipped bit 505 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a76",
     true},

    {61, "Flipped bit 505 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41982",
     true},

    {62, "Flipped bit 510 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a34",
     true},

    {63, "Flipped bit 510 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e419c0",
     true},

    {64, "Flipped bit 511 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4af4",
     true},

    {65, "Flipped bit 511 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41900",
     true},

    {66, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "617063701a568559238544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {67, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec8b68b4548c12f70be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {68, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063f01a5685d9228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {69, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b60b4548c1af71be13428cbb4ab9fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {70, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "607063701a5685d9228544d63a27d36efeecab50933a989e8a2f5a6d0741a463e504d4c03"
     "a1be0e8fce99a20368dc5ac0f60d90ca0c48443f81a51d4c8ac4a74",
     true},

    {71, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c1af71be13428cbb4a39fea280421c209345dbf0c985bf6910ddc353f0b20"
     "40df3fffc38be8caf863c1a4b504f0ca89b200451a1c310d3e41980",
     true},

    {72, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "9f8f9c8fe5a97aa6dd7abb29c5d82c11011354af6cc5676175d0a592f8be5b9c1afb2b3fc"
     "5e41f17031665dfc9723a53f09f26f35f3b7bbc07e5ae2b3753b58b",
     true},

    {73, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "80374974bab73ed08e41ecbd7344b546015d7fbde3df6cba240f367a4096ef223cac0f4df"
     "bf20c0003c741735079c3e5b4afb0f35764dffbae5e3cef2c1be67f",
     true},

    {74, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "0000000000000000000000000000000000000000000000000000000",
     true},

    {75, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000000000000"
     "0000000000000000000000000000000000000000000000000000000",
     true},

    {76, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {77, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"
     "fffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {78, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "e0f0e3f09ad605d9a205c456baa7536e7e6c2bd013ba181e0aafdaed87c124e365845440b"
     "a9b60687c691aa0b60d452c8fe0598c204404c3789ad154482ccaf4",
     true},

    {79, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ff48360bc5c841aff13e93c20c3bca397e2200c29ca013c55b7049053fe9905d43d370328"
     "48d737f7cb83e0c2f06bc9acbd0cf8c281ba084d121439053649900",
     true},

    {80, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "",
     "617162711b578458238445d73b26d2efffedaa51923b999f8b2e5b6c0640a562e405d5c13"
     "b1ae1e9fde89b21378cc4ad0e61d80da1c58542f91b50d5c9ad4b75",
     true},

    {81, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec9b78a4449c02e70bf12438dba4bb8ffa381431d219244daf1c884be6811dcc252f1b30"
     "50cf2fefd39bf8dae873d1b4a514e0da99a210550a0c211d2e51881",
     true},

    {82, "empty message",
     "eef6bcf16ef7ae17326a33f22d1406ec1bd3f866505f4b2e4fe8b45bd62ccbd85032a9899"
     "facf2db0c93a2345cb8892afb74db549781211dd8881a8c8e25c171",
     "", "a2408e6044d91093d34c1f283c19c014e739e2911c01baa0a3079e73d7c8e1d2",
     false},

    {83, "short message",
     "838696e6190c874c3717b8be0cf063ca6d60760987d1a33703e7e35eb173e5ae954e741a3"
     "7935139d612149e76f6ab2a370604f5b4a68bee87e309240a9ba3d6",
     "d8", "38497695114208d90af884f6485e942af1e42963c32d8ea0b46a52eca970afef",
     false},

    {84, "short message",
     "fa999ed1cfbc5c43afb16f22d024e3ce645e00b06712c93b946167c9c2c037d192f0f3003"
     "f87c43a71166fe1a3c5824c348673a2f0f3c475706985940f6b02a2",
     "cad2", "6a0d324e2b498d57fdcc1d4b052de9fbc0086627ebd0e9cfed82dbc8b54a0b5f",
     false},

    {85, "short message",
     "b53fced8b7b4aa59d3b56d91e1386763c39e351c2f5ad6a4885e442ad894d5181c5bfe5c0"
     "5280a84ad19d758e359bf8171fe652988fcf9d1458ea17364ca8fa9",
     "d3393c",
     "3f23eabdb750c10f3232a4b396ff97e6df1a4626c1383caafbf5e6aab0c5510a", false},

    {86, "short message",
     "3f0cbeebe391c6491e77c57a05e85a16f0b5294d19f9a7f3390baf7a2051fbf980e041ee4"
     "5c9104a9126a6a7ec182eaec27a99c1a7a3f5a1e8cd8ffde60641dc",
     "bebb0392",
     "ae3ee84825ec607adcad8ad70ce1b6cfc7206f4f9d5046812073f6a3d48ef133", false},

    {87, "short message",
     "4a7f110b92241badc907ba3c61477bab0953a851bf327425e858fc724bd33ede2a4a5018f"
     "e71aab434bda8eb2464a41577c8d570530c460f7c8bc0172f1ee0f1",
     "40a333f4cf",
     "e3a52f9388f9af038298b778123fcdf5ea58712bc5b46f1e4cdcae98f2ab2e09", false},

    {88, "short message",
     "c6c95bf9facab295cebfa4b907855874f57a5c1548576ad8bae694a364f5e58dbb8c8dd49"
     "330b2fdd1b71657d211db2a6569a9f3a356c0c5b3c4efbd5b6777cb",
     "4cf926af475a",
     "29e274b1851fa268e0e02e3b450469ce4a69762e45af8afca567776967955de6", false},

    {89, "short message",
     "0d3387fe59e8e7c43c928dac7913826dec4d63ac3c8ee346ba7caed9505b9e63ff8942cde"
     "90997e8dbeaf6e17ee187c0a84a1853952d866c15f9a32fcee6a82a",
     "2ba3bc3cd64bc6",
     "e049f480934a3ccc5b483874ed6eb992f94557b303f44721f7ba72b6c762b108", false},

    {90, "short message",
     "3cb9ce565388a6f0454a80add86c7e107ea537d7f468a0648930fc37172cf7b4ca9058033"
     "071c354a20a608e2d46e98afe46435a344362989cbaafac18859bba",
     "33ce498e1f94f412",
     "91749d95bc706cb8c1f14f6a61342c44f59a963644b9fd35d58a09e1071e4ee7", false},

    {91, "short message",
     "c25f45ceb2a5597f361445fa41a9019f41a6e6d7f144203f29c0b9fcea362d60894c3cadc"
     "1ce25d53da362e464c11fc6e169e3db2ea1cf40fe08fffb429b1a5b",
     "81978af4795c50f89c",
     "08550f63be595cd9ba3c66e33b19bd2739bdfaa4eec9acdd9823a214538d322e", false},

    {92, "short message",
     "b458764ee273f391cb718f64a1bca64c96a870d9426d6254ee37e5c93898d6a5ef68e9d3b"
     "0e057a3c396faa834a29926a9680cfa903d2a605b85407bb24c8cee",
     "d804dc2a1e146f62b621",
     "d5572726cc7521ef30e0d8390ca521a57f039da4c45f1275fe67c3121c7008b5", false},

    {93, "short message",
     "7cbc5778f70595fc211cee3a93e17ff7f25a1d9f3766f8eb70eb1e08c9420a62bd89e8b7d"
     "834cc854d059afd413e4d9c062a532e015928528c7f5812dfebecac",
     "4017e0ffcaac4c485ce7ec",
     "7e0836625892a37523ee178eb16f785396602fca5addb0006fa6907c530fce0c", false},

    {94, "short message",
     "937b9711d670daa2359920e47dd6d0fb75275105b3ef07bb4a31d3c4b99baa8ff79ee4b4a"
     "1b4a5b250d0fd7b4721e04a7b06035b1d0c9d739597707839018bce",
     "6991810e9788af7aabff8eb4",
     "5b36f377078ce820bd33759a85691efc2053407fd86a3e4946da1e38a4557ab1", false},

    {95, "short message",
     "ad37630a280b1a75ebed1984217150a400a55dca2362a8eaf3c907858d0b45db3e208c316"
     "d033854eb4284f71117d33876e0e203ca922d26f9b76d94cab0d4f3",
     "7c6f2fd83e5691827be38e49a0",
     "c15a7f38007bc32c61d912b30889d6f5c624ad0e6e2e3fa41af2d3295b0259b7", false},

    {96, "short message",
     "526aa2645ab71229e2c60f68bd5bbcf0cea0978a0a9c60cf695e81fecaedecfa0362c2174"
     "7eaa995975208ca35cfa6bc2b95d1c2afcee11275f43add6f026d6c",
     "681bca550fe301f2dcc1e38b53c1",
     "87a7e6448d64e006339487b2d93409f00f1dafc0dbfe35a361da264f251ceb71", false},

    {97, "short message",
     "6026a9047a07ccf197fde09c8b9f15f34bc52472b7d1ea4673b4914a0e1c3aa4cfe8d6ef1"
     "2d4d4019f5ff3ac0adcad7358490874155daf41da2f74aca1cd894a",
     "ce1d869c53041c5f6acdda7a05af15",
     "b44c984a2241527545d9cf755663346ba82841d039a3e2aae56b40020a6be1f4", false},

    {98, "",
     "a03d2c543c302949c51b662f43114c1305a8f6961ae48342803d3690dc18255fab9249655"
     "36a79bc38564c7c97cb8cc0209786e9f76375bf181529cf7f93d954",
     "697617ae31f19b8a6ad4b8489bfc3db1",
     "1827375ec9d32581adfe2347984e33c0fd95362d158fe6a7ca07e084557e2b40", false},

    {99, "",
     "25843665d39c3ae9a7b3e4427e2bf7785281fd2594bdde67860ca9b8fa11646469d1645ae"
     "8ca3825b8c551f9eac3da0660d8c2e2e3bd23d34395c6775dcdfd2e",
     "74082cc5d14db1967442d66aac6092bd23",
     "6bd2e4c2fb8c4849065ebc921b4fbea6de5af848fc9d22ce60b1a3ed536b4eea", false},

    {100, "",
     "4831ab4962a2d2436091cbbf388d2ba042b472a262ed8373c85d047c702adf73a87eb097e"
     "72d91d089b7d1504a7f7d8abb3bc2c44c1340d6c16c84ea9269e64b",
     "2803c2f4e5b4bfccd2b407469a6cb5ef21fd14a682636397",
     "ab6570dd52670051d6879591618a582a15d5bbac995a09d6aeb97e52bbca2296", false},

    {101, "",
     "449bb57d046551e1819b3c994122c3605954317d0d76212284a3328c226732cbf4ecb442a"
     "582c8423888aaed946e5eec2be66e127f1e2e29b66e68b9b4bec4d1",
     "79004e644389a11b709bc0a23cb8592f9fc7960bfa46132cc1ffb9747df37dec",
     "023ffaeb8ee50eb1869f51384011af14c9c99610058a9cc3ba871e3c56fd2ed3", false},

    {102, "long message",
     "ff97b77020861a0ce00eff8de9e701aea8c6de0fffd9b4c1342a416d357fce35a7016c64c"
     "cd38e2bdf674802281c2234153dd83aacb948966dc87ea4718fff75",
     "d7e2d2437b7067a30f04529041960e041e281737d1e0daa8cd50cc0b264716e117aa2fe9a"
     "7e39c2f178c607faa50c2",
     "cee096bbd66cb2a500f279aa34418e7c690dd1f46dbe2348d1fd04190ed78cd5", false},

    {103, "long message",
     "f4daf370c4f437d8a85391ec455e34540be8d32df8dfac05b166ae72ec1cc608f8c177b30"
     "dde8bf07c9d434732c26a6e530b182c7ab21093eb79d0bb5be85e53",
     "f60418f6c54a25fabf518273088619c0741c1c7187de93a0cf6a03f4565f1765de6567545"
     "41b860137f3f8455de7c403",
     "3b260d9bb6d9b18441e07e96c3f3f19a97faec005e98ad3b3566486724dec695", false},

    {104, "long message",
     "3be95e879421ed7856269eef39a2070fae406cec5e30b50d92792df5a37de98595684eaa9"
     "205587ca607eeac8f96592f458f63434b7dc82596d3e4a1a16c3d59",
     "c64f7c970a441c6c503838a491308c783099eac52bd35a217978a64dcec84d34186ab3b74"
     "f20285d6fea2165eab4da3d2c",
     "67329f88b1e99c978ef50b2bccf8a405d4f9ea3f0d10703fe4b335a829f76008", false},

    {105, "long message",
     "b5eb53586b948587db3dd46c43ad65498a5079157562e4074c9c20d097d0c97f19db4661f"
     "b2dd11b87a5ccba2c345642618f561d00bf87dffc66762e45e0156f",
     "9e8ebf96429955d60b925a4111745ec7028de24e694a6d2eee1dbd5e820ab9f00beafde09"
     "f95095933a02f251297282b0cf67c518397655841f230e1d9ae5ba93150d4375dc7c0738b"
     "99850b07d5a442994e68dc813d55edefa6cd063ccb202711d97ba674efa02ddbdc692341e"
     "77cfa",
     "52bb6b6d0018135187e7265883815d904a57434e68a0a868676059adfb5727b5", false},

    {106, "long message",
     "fbc678235d596980268730a7aa8a3c25095f1dbcf7f830990716a510c44e62b1ae8ce095c"
     "65e1852bd8a09f25ab93415ae736f22b2c68ecdf3c0f71e15a057dc",
     "ef395738f2b3bd7a0649eea75e734e5c79baf21358c7ae96c63a58e260266c7bfa869664c"
     "5d10e87c26d0f5edb3b5f73900c1d9a96a5a2c2912506c19dff04e900b8d5d63e1bb606fe"
     "3d5a229b642b1ac59e08a4687a7aade3de16d183131ddd02da988ff826e88b74ba0c5c41c"
     "fcd8570cca59fb3304d588f7f7e63dad47a",
     "fe957b5c1a0f337e9f119c8eb8398d2c5bdedbd1f84af785b5d365e07d4740b4", false},

    {107, "long message",
     "d8437b093e170afc30fb68d873db6dd67ee0372b6c5feb124d548abbd93304a082235a170"
     "a9d326268d0cfc34264d8ebcfcbcc0dc0ea7767b650dbcfc7848f91",
     "0fb91bb043cf3d49341482eacbab92da92117bb6ec03b518a93c9d59e54702c6a21ade4f2"
     "55870cb52da4a24b36856b0cbf8b122d2fd5b0219aeacb6e292c95863921789092d5d65d5"
     "a9389231670e38be31d8b76630650c77edc23773d5ec9189915560ef6f45a4275f85957d8"
     "762916d8147ef43ea6f438d066227354df26c",
     "5e08a2cef9370a6f040788b716e27b6094e4d9f6549ffd6f69ead6610dbd7ac6", false},

    {108, "long message",
     "d29225e3042b43d4eb7a9399f224424b5b4dd99031c8abf609d3a6e3175897134cc7ba8a6"
     "be25d436d41a757a2daa4e1b03f7c3053ee8cada19531d48dab93e0",
     "1fdad8cd37e115ef8131d4619b5d61a9827a11b9c25c5b8220b002d5b7f6e2bc30a7e2f3d"
     "103dbcaf849a255c20ec5d1b40a623e398d76c5b7f07fe305181cd5bee29de3360fed55f6"
     "9063e6a8fd2ef31291e4d7c3908449466b4ff1166959ff1f2e86eb48a7ed11bdcec2fc2df"
     "b6684b36b8d0b68e0f1b23ef11bf5907d4a2b162cec26f31b6d5d9892a27b3fad7a554985"
     "8dad530bae193d9b60d42d7ad2a66476a3ba4bf7a27ff9d0f885a540bf181caad71a235eb"
     "348a23d053ba2db7aed8d7d01d96dc9f780e2e426c72bb63fcb3fff44c14bb7b0f8af3552"
     "d67ee6761092c757627d19c080499c247d13b431699397159b1b71c6274584959d5c30f0",
     "3b28ef1afeba82c4123956e6b902107984b2938d82912e84868c195768769086", false},

    {109, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "617063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {110, "Flipped bit 0 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {111, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "627063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {112, "Flipped bit 1 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7dc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {113, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "e07063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {114, "Flipped bit 7 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ffc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {115, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607163701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {116, "Flipped bit 8 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc9b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {117, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063f01a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {118, "Flipped bit 31 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b60b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {119, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701b568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {120, "Flipped bit 32 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4448c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {121, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "6070637018568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {122, "Flipped bit 33 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4748c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {123, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a5685d9228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {124, "Flipped bit 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c1af71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {125, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559238544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {126, "Flipped bit 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f70be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {127, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559a28544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {128, "Flipped bit 71 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12ff1be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {129, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a56855922a544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {130, "Flipped bit 77 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f719e13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {131, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228545d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {132, "Flipped bit 80 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be12428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {133, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63b27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {134, "Flipped bit 96 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428dbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {135, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63827d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {136, "Flipped bit 97 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428ebb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {137, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d6ba27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {138, "Flipped bit 103 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13420cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {139, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a462",
     true},

    {140, "Flipped bit 248 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910dc", true},

    {141, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a461",
     true},

    {142, "Flipped bit 249 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf6910df", true},

    {143, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a423",
     true},

    {144, "Flipped bit 254 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf69109d", true},

    {145, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a568559228544d63a27d3eefeecab50933a989e8a2f5a6d0741a4e3",
     true},

    {146, "Flipped bit 255 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c12f71be13428cbb4ab9fea280421c209345dbf0c985bf69105d", true},

    {147, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "617063701a568559238544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {148, "Flipped bits 0 and 64 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec8b68b4548c12f70be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {149, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063f01a5685d9228544d63a27d3eefeecab50933a989e8a2f5a6d0741a463",
     true},

    {150, "Flipped bits 31 and 63 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b60b4548c1af71be13428cbb4ab9fea280421c209345dbf0c985bf6910dd", true},

    {151, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "607063701a5685d9228544d63a27d36efeecab50933a989e8a2f5a6d0741a463",
     true},

    {152, "Flipped bits 63 and 127 in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7fc8b68b4548c1af71be13428cbb4a39fea280421c209345dbf0c985bf6910dd", true},

    {153, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "9f8f9c8fe5a97aa6dd7abb29c5d82c11011354af6cc5676175d0a592f8be5b9c",
     true},

    {154, "all bits of tag flipped",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "80374974bab73ed08e41ecbd7344b546015d7fbde3df6cba240f367a4096ef22", true},

    {155, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "0000000000000000000000000000000000000000000000000000000000000000",
     true},

    {156, "Tag changed to all zero",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "0000000000000000000000000000000000000000000000000000000000000000", true},

    {157, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff",
     true},

    {158, "tag changed to all 1",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff", true},

    {159, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "e0f0e3f09ad605d9a205c456baa7536e7e6c2bd013ba181e0aafdaed87c124e3",
     true},

    {160, "msbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "ff48360bc5c841aff13e93c20c3bca397e2200c29ca013c55b7049053fe9905d", true},

    {161, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "", "617162711b578458238445d73b26d2efffedaa51923b999f8b2e5b6c0640a562",
     true},

    {162, "lsbs changed in tag",
     "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232"
     "425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f",
     "000102030405060708090a0b0c0d0e0f",
     "7ec9b78a4449c02e70bf12438dba4bb8ffa381431d219244daf1c884be6811dc", true},

    {163, "short key",
     "14d93759fc28f3319ab74b8167c974e800f032344dc2747ec0f4945061a47827", "",
     "bfbc9e095822745f9bae15ee3418f330e63891a2972fbfe1045165d8b5fbd288061973ed4"
     "0ba310b85e7e6dafb9dfb4c29c4de7969499c67aa2ccaa48c63178f",
     false},

    {164, "short key",
     "9fa371f36fb273d514fd628cb938067a4bae32a19a1e045a7d6d7f6de3751cbf",
     "311bbf722d322cd7a0710f480fc66518",
     "5d6619bd88bdd18aaafe2c3773d8a92e6617e741196d0c2e9d5271fb9abebb72b520bce1e"
     "1f147d861be15734ab25c93437e1058bb44dddb8104185521785099",
     false},

    {165, "short key",
     "6313f1526bc220f20dde1e64ced8597279586d1e15aad05ad591d841b369284f",
     "f744fa3933e16d8bf524afaeb34c715653a9cfb01fa45fe1fb68e701fe1487ca",
     "20df7e320ef62fd4b347193de868516a0b4c245546f1e6b43f5ac42f1cff66a56d214b1bb"
     "f7d32849fee3a2c6dee8a8fe209e6e28c6e2416b9cf95ebc10fc8b8",
     false},

    {166, "short key",
     "1e225cafb90339bba1b24076d4206c3e79c355805d851682bc818baa4f5a7779", "",
     "4e35e7b4b0029d62e3a765c2a41d19f512d77468f8a43860f933f13306bf6204", false},

    {167, "short key",
     "6fa353868c82e5deeedac7f09471a61bf749ab5498239e947e012eee3c82d7c4",
     "aeed3e4d4cb9bbb60d482e98c126c0f5",
     "4b08479a99964744881a02f32435b60bf83ea5036835a0be2b3c6544d502cd95", false},

    {168, "short key",
     "186e248ad824e1eb93329a7fdcd565b6cb4eaf3f85b90b910777128d8c538d27",
     "92ef9ff52f46eccc7e38b9ee19fd2de3b37726c8e6ce9e1b96db5dda4c317902",
     "318cc3d4a8a10830975458cf984196980c0f3f5ff040e3478ae29b287663752f", false},

    {169, "long key",
     "dd1e0bdbb6b60862176484f3669da531455f1cd714f999c29f08b851055fee8d72186d376"
     "c236f4e16cba7a25cba879fb2753deca4459aaebc6f6de625d99af330",
     "",
     "dca1d28776d636773d4397b792323d315dab2fdbf7027e9ce6b216db7a35505686a1ea0a4"
     "10a1473c7c0ca737b4ece05c82e8aa5203db9863677495013dbfd48",
     false},

    {170, "long key",
     "432b311ebcfd46ecfcd3cc706ebd05c787dfbe1855fdcfce8d50c9a00f72b65a8d42acec3"
     "35b4e07d544c92fd7b1d38543ac6e0fc04c26d88de8dd974af69e24d7",
     "36b1fbe8f1335e7c0399c24730906420",
     "c0ce831930455d18917c4e4f097f2000db8b295041ce822cfe67b9106fabf4800916f75fa"
     "00fb9c49eb7cfb7aeaef3170a4575db66161d2035efbc132957f1b3",
     false},

    {171, "long key",
     "17f720f09df5972af9b9c63e10043284608900d50b7955db3b4e2679cb4120be2c9b9e2aa"
     "1a5743eb519792822c326b4d890b5554d1cb0eb71081b7569a2f04df7",
     "57167c2524a55289687b83a40d3a69bc90adc53ad247020b88897f9b95d1516d",
     "677530c17b888f416a303f32a3a8b0d707eafbb65845ccfe0b963b7666601385e0daf21b0"
     "affa1070109e0812135b7e51e001168e08d17da1106e40d47f084f4",
     false},

    {172, "long key",
     "8a0c46eb8a2959e39865330079763341e7439dab149694ee57e0d61ec73d947e1d5301cd9"
     "74e18a5e0d1cf0d2c37e8aadd9fd589d57ef32e47024a99bc3f70c077",
     "", "0fd5265ee5f787925a827b5f68f9f45460afd232db4a7ad6a09c817dac9f1c68",
     false},

    {173, "long key",
     "2877ebb81f80334fd00516337446c5cf5ad4a3a2e197269e5b0ad1889dfe2b4b0aaa676fa"
     "c55b36ce3affc7f1092ab89c53273a837bd5bc94d1a9d9e5b02e9856f",
     "ba448db88f154f775028fdecf9e6752d",
     "1ea78bfb221933ddb7dcf5b08f0ef34771143e2cabc6b0b8d4552fa1286dd5ce", false},

    {174, "long key",
     "21178e26bc28ffc27c06f762ba190a627075856d7ca6feab79ac63149b17126e34fd9e559"
     "0e0e90aac801df09505d8af2dd0a2703b352c573ac9d2cb063927f2af",
     "7d5f1d6b993452b1b53a4375760d10a20d46a0ab9ec3943fc4b07a2ce735e731",
     "e8db4b9925ad01399a25be1b2e9b08288f50bbe7ece18a279134806bef69d9be",
     false}};

#endif  // hmac_sha3_512_vectors_h__
