.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetTransientForHint __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetTransientForHint, XGetTransientForHint \- set or read a window's WM_TRANSIENT_FOR property
.SH SYNTAX
.HP
int XSetTransientForHint\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
Window \fIprop_window\fP\^);
.HP
Status XGetTransientForHint\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
Window *\fIprop_window_return\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIprop_window\fP 1i
Specifies the window that the WM_TRANSIENT_FOR property is to be set to.
.IP \fIprop_window_return\fP 1i
Returns the WM_TRANSIENT_FOR property of the specified window.
.SH DESCRIPTION
The
.B XSetTransientForHint
function sets the WM_TRANSIENT_FOR property of the specified window to the
specified prop_window.
.LP
.B XSetTransientForHint
can generate
.B BadAlloc
and
.B BadWindow
errors.
.LP
The
.B XGetTransientForHint
function returns the WM_TRANSIENT_FOR property for the specified window.
It returns a nonzero status on success;
otherwise, it returns a zero status.
.LP
.B XGetTransientForHint
can generate a
.B BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_TRANSIENT_FOR\s+1
Set by application programs to indicate to the window manager that a transient
top-level window, such as a dialog box.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XAllocClassHint (__libmansuffix__),
.BR XAllocIconSize (__libmansuffix__),
.BR XAllocSizeHints (__libmansuffix__),
.BR XAllocWMHints (__libmansuffix__),
.BR XSetCommand (__libmansuffix__),
.BR XSetTextProperty (__libmansuffix__),
.BR XSetWMClientMachine (__libmansuffix__),
.BR XSetWMColormapWindows (__libmansuffix__),
.BR XSetWMIconName (__libmansuffix__),
.BR XSetWMName (__libmansuffix__),
.BR XSetWMProperties (__libmansuffix__),
.BR XSetWMProtocols (__libmansuffix__),
.BR XStringListToTextProperty (__libmansuffix__)
.br
\fI\*(xL\fP
