'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
'\" t
.TH XGetWindowAttributes __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGetWindowAttributes, XGetGeometry, XWindowAttributes \- get current window attribute or geometry and current window attributes structure
.SH SYNTAX
.HP
Status XGetWindowAttributes\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
XWindowAttributes *\fIwindow_attributes_return\fP\^);
.HP
Status XGetGeometry\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, Window
*\fIroot_return\fP\^, int *\fIx_return\fP\^, int *\fIy_return\fP\^, unsigned
int *\fIwidth_return\fP\^, unsigned int *\fIheight_return\fP\^, unsigned int
*\fIborder_width_return\fP\^, unsigned int *\fIdepth_return\fP\^);
.SH ARGUMENTS
.IP \fIborder_width_return\fP 1i
Returns the border width in pixels.
.IP \fId\fP 1i
Specifies the drawable, which can be a window or a pixmap.
.IP \fIdepth_return\fP 1i
Returns the depth of the drawable (bits per pixel for the object).
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIroot_return\fP 1i
Returns the root window.
.ds Wi
.IP \fIw\fP 1i
Specifies the window whose current attributes you want to obtain.
.IP \fIwidth_return\fP 1i
.br
.ns
.IP \fIheight_return\fP 1i
Return the drawable's dimensions (width and height).
.IP \fIwindow_attributes_return\fP 1i
Returns the specified window's attributes in the
.B XWindowAttributes
structure.
.IP \fIx_return\fP 1i
.br
.ns
.IP \fIy_return\fP 1i
Return the x and y coordinates that define the location of the drawable.
For a window,
these coordinates specify the upper-left outer corner relative to
its parent's origin.
For pixmaps, these coordinates are always zero.
.SH DESCRIPTION
The
.B XGetWindowAttributes
function returns the current attributes for the specified window to an
.B XWindowAttributes
structure.
It returns a nonzero status on success; otherwise, it returns a
zero status.
.LP
.B XGetWindowAttributes
can generate
.B BadDrawable
and
.B BadWindow
errors.
.LP
The
.B XGetGeometry
function returns the root window and the current geometry of the drawable.
The geometry of the drawable includes the x and y coordinates, width and height,
border width, and depth.
These are described in the argument list.
It is legal to pass to this function a window whose class is
.BR InputOnly .
It returns a nonzero status on success; otherwise, it returns a
zero status.
.SH STRUCTURES
The
.B XWindowAttributes
structure contains:
.LP
.EX
typedef struct {
        int x, y;       /\&* location of window */
        int width, height;      /\&* width and height of window */
        int border_width;       /\&* border width of window */
        int depth;      /\&* depth of window */
        Visual *visual; /\&* the associated visual structure */
        Window root;    /\&* root of screen containing window */
        int class;      /\&* InputOutput, InputOnly*/
        int bit_gravity;        /\&* one of the bit gravity values */
        int win_gravity;        /\&* one of the window gravity values */
        int backing_store;      /\&* NotUseful, WhenMapped, Always */
        unsigned long backing_planes;   /\&* planes to be preserved if possible */
        unsigned long backing_pixel;    /\&* value to be used when restoring planes */
        Bool save_under;        /\&* boolean, should bits under be saved? */
        Colormap colormap;      /\&* color map to be associated with window */
        Bool map_installed;     /\&* boolean, is color map currently installed*/
        int map_state;  /\&* IsUnmapped, IsUnviewable, IsViewable */
        long all_event_masks;   /\&* set of events all people have interest in*/
        long your_event_mask;   /\&* my event mask */
        long do_not_propagate_mask;     /\&* set of events that should not propagate */
        Bool override_redirect; /\&* boolean value for override-redirect */
        Screen *screen; /\&* back pointer to correct screen */
} XWindowAttributes;
.EE
.LP
The x and y members are set to the upper-left outer
corner relative to the parent window's origin.
The width and height members are set to the inside size of the window,
not including the border.
The border_width member is set to the window's border width in pixels.
The depth member is set to the depth of the window
(that is, bits per pixel for the object).
The visual member is a pointer to the screen's associated
.B Visual
structure.
The root member is set to the root window of the screen containing the window.
The class member is set to the window's class and can be either
.B InputOutput
or
.BR InputOnly .
.LP
The bit_gravity member is set to the window's bit gravity
and can be one of the following:
.LP
.TS
lw(1.5i) lw(1.5i).
T{
.B ForgetGravity
T}	T{
.B EastGravity
T}
T{
.B NorthWestGravity
T}	T{
.B SouthWestGravity
T}
T{
.B NorthGravity
T}	T{
.B SouthGravity
T}
T{
.B NorthEastGravity
T}	T{
.B SouthEastGravity
T}
T{
.B WestGravity
T}	T{
.B StaticGravity
T}
.B CenterGravity
.TE
.LP
The win_gravity member is set to the window's window gravity
and can be one of the following:
.LP
.TS
lw(1.5i) lw(1.5i).
T{
.B UnmapGravity
T}	T{
.B EastGravity
T}
T{
.B NorthWestGravity
T}	T{
.B SouthWestGravity
T}
T{
.B NorthGravity
T}	T{
.B SouthGravity
T}
T{
.B NorthEastGravity
T}	T{
.B SouthEastGravity
T}
T{
.B WestGravity
T}	T{
.B StaticGravity
T}
.B CenterGravity
.TE
.LP
For additional information on gravity,
see section 3.3.
.LP
The backing_store member is set to indicate how the X server should maintain
the contents of a window
and can be
.BR WhenMapped ,
.BR Always ,
or
.BR NotUseful .
The backing_planes member is set to indicate (with bits set to 1) which bit
planes of the window hold dynamic data that must be preserved in backing_stores
and during save_unders.
The backing_pixel member is set to indicate what values to use
for planes not set in backing_planes.
.LP
The save_under member is set to
.B True
or
.BR False .
The colormap member is set to the colormap for the specified window and can be
a colormap ID or
.BR None .
The map_installed member is set to indicate whether the colormap is
currently installed and can be
.B True
or
.BR False .
The map_state member is set to indicate the state of the window and can be
.BR IsUnmapped ,
.BR IsUnviewable ,
or
.BR IsViewable .
.B IsUnviewable
is used if the window is mapped but some ancestor is unmapped.
.LP
The all_event_masks member is set to the bitwise inclusive OR of all event
masks selected on the window by all clients.
The your_event_mask member is set to the bitwise inclusive OR of all event
masks selected by the querying client.
The do_not_propagate_mask member is set to the bitwise inclusive OR of the
set of events that should not propagate.
.LP
The override_redirect member is set to indicate whether this window overrides
structure control facilities and can be
.B True
or
.BR False .
Window manager clients should ignore the window if this member is
.BR True .
.LP
The screen member is set to a screen pointer that gives you a back pointer
to the correct screen.
This makes it easier to obtain the screen information without
having to loop over the root window fields to see which field matches.
.SH DIAGNOSTICS
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XQueryPointer (__libmansuffix__),
.BR XQueryTree (__libmansuffix__)
.br
\fI\*(xL\fP
