<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_core - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_core</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_core.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisation basique</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_core_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_core.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3
d'Apache HTTPD</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module fournit des fonctionnalits d'autorisation basiques
    permettant d'accorder ou refuser l'accs  certaines zones du site
    web aux utilisateurs authentifis. <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code>
    donne la possibilit d'enregistrer divers fournisseurs
    d'autorisation. Il est en gnral utilis avec un module fournisseur
    d'authentification comme <code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code>, et un
    module d'autorisation comme <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>. Il
    permet aussi l'application d'une logique labore au droulement du
    processus d'autorisation.</p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#authzalias">Cration des alias du fournisseur
d'autorisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#logic">Conteneurs d'autorisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requiredirectives">Les directives Require</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#authmerging">AuthMerging</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authzprovideralias">&lt;AuthzProviderAlias&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#authzsendforbiddenonfailure">AuthzSendForbiddenOnFailure</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#require">Require</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requireall">&lt;RequireAll&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requireany">&lt;RequireAny&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#requirenone">&lt;RequireNone&gt;</a></li>
</ul>
<ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="authzalias" id="authzalias">Cration des alias du fournisseur
d'autorisation</a></h2>

    <p>Il est possible de crer des fournisseurs d'autorisation tendus
    dans le fichier de configuration et de leur assigner un nom d'alias.
    On peut ensuite utiliser ces fournisseurs aliass dans une
    directive <code class="directive"><a href="#require">Require</a></code> de
    la mme manire qu'on le ferait pour des fournisseurs d'autorisation
    de base. En plus de la possibilit de crer et d'aliaser un
    fournisseur tendu, le mme fournisseur d'autorisation tendu peut
    tre rfrenc par plusieurs localisations.
    </p>

    <h3><a name="example" id="example">Exemple</a></h3>
        <p>Dans l'exemple suivant, on cre deux alias de fournisseur
	d'autorisation ldap diffrents bass sur le fournisseur
	d'autorisation ldap-group. Il est ainsi possible pour un seul
	rpertoire de vrifier l'appartenance  un groupe dans plusieurs
	serveurs ldap :
        </p>

        <pre class="prettyprint lang-config">&lt;AuthzProviderAlias ldap-group ldap-group-alias1 cn=my-group,o=ctx&gt;
    AuthLDAPBindDN cn=youruser,o=ctx
    AuthLDAPBindPassword yourpassword
    AuthLDAPURL ldap://ldap.host/o=ctx
&lt;/AuthzProviderAlias&gt;

&lt;AuthzProviderAlias ldap-group ldap-group-alias2 cn=my-other-group,o=dev&gt;
    AuthLDAPBindDN cn=yourotheruser,o=dev
    AuthLDAPBindPassword yourotherpassword
    AuthLDAPURL ldap://other.ldap.host/o=dev?cn
&lt;/AuthzProviderAlias&gt;

Alias "/secure" "/webpages/secure"
&lt;Directory "/webpages/secure"&gt;
    Require all granted
    
    AuthBasicProvider file
    
    AuthType Basic
    AuthName LDAP_Protected_Place
    
    #implied OR operation
    Require ldap-group-alias1
    Require ldap-group-alias2
&lt;/Directory&gt;</pre>

    

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="logic" id="logic">Conteneurs d'autorisation</a></h2>

    <p>Les directives de conteneur d'autorisation <code class="directive"><a href="#requireall">&lt;RequireAll&gt;</a></code>,
    <code class="directive"><a href="#requireany">&lt;RequireAny&gt;</a></code> et <code class="directive"><a href="#requirenone">&lt;RequireNone&gt;</a></code>
    peuvent tre combines entre elles et avec la directive <code class="directive"><a href="#require">Require</a></code> pour confectionner une
    logique d'autorisation complexe.</p>

    <p>L'exemple ci-dessous illustre la logique d'autorisation suivante.
    Pour pouvoir accder  la ressource, l'utilisateur doit tre
    l'utilisateur <code>superadmin</code>, ou appartenir aux deux
    groupes LDAP <code>admins</code> et <code>Administrateurs</code> et
    soit appartenir au groupe <code>ventes</code> ou avoir
    <code>ventes</code> comme valeur de l'attribut LDAP
    <code>dept</code>. De plus, pour pouvoir accder  la ressource,
    l'utilisateur ne doit appartenir ni au groupe <code>temps</code>, ni
    au groupe LDAP <code>Employs temporaires</code>.</p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/mydocs"&gt;
    &lt;RequireAll&gt;
        &lt;RequireAny&gt;
            Require user superadmin
            &lt;RequireAll&gt;
            Require group admins
            Require ldap-group cn=Administrators,o=Airius
                &lt;RequireAny&gt;
                Require group sales
                Require ldap-attribute dept="sales"
                &lt;/RequireAny&gt;
            &lt;/RequireAll&gt;
        &lt;/RequireAny&gt;
        &lt;RequireNone&gt;
            Require group temps
            Require ldap-group cn=Temporary Employees,o=Airius
        &lt;/RequireNone&gt;
    &lt;/RequireAll&gt;
&lt;/Directory&gt;</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="requiredirectives" id="requiredirectives">Les directives Require</a></h2>

  <p>Le module <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> met  disposition des
  fournisseurs d'autorisation gnriques utilisables avec la directive
  <code class="directive"><a href="#require">Require</a></code>.</p>

  <h3><a name="reqenv" id="reqenv">Require env</a></h3>

    <p>Le fournisseur <code>env</code> permet de contrler l'accs au
    serveur en fonction de l'existence d'une <a href="../env.html">variable d'environnement</a>. Lorsque <code>Require
    env <var>env-variable</var></code> est spcifi, la requte se voit
    autoriser l'accs si la variable d'environnement
    <var>env-variable</var> existe. Le serveur permet de dfinir
    facilement des variables d'environnement en fonction des
    caractristiques de la requte du client via les directives fournies
    par le module <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code>. Cette directive Require
    env permet donc de contrler l'accs en fonction des
    valeurs des en-ttes de la requte HTTP tels que
    <code>User-Agent</code> (type de navigateur), <code>Referer</code>,
    entre autres.</p>

    <pre class="prettyprint lang-config">SetEnvIf User-Agent ^KnockKnock/2\.0 let_me_in
&lt;Directory "/docroot"&gt;
    Require env let_me_in
&lt;/Directory&gt;</pre>


    <p>Avec cet exemple, les navigateurs dont la chane user-agent
    commence par <code>KnockKnock/2.0</code> se verront autoriser
    l'accs, alors que tous les autres seront rejets.</p>

    <p>Lorsque le serveur cherche un chemin via une <a class="glossarylink" href="../glossary.html#subrequest" title="voir glossaire">sous-requte</a> interne (par exemple la
   recherche d'un <code class="directive"><a href="../mod/mod_dir.html#directoryindex">DirectoryIndex</a></code>), ou lorsqu'il gnre un
   listing du contenu d'un rpertoire via le module
   <code class="module"><a href="../mod/mod_autoindex.html">mod_autoindex</a></code>, la sous-requte n'hrite pas des
   variables d'environnement spcifiques  la requte. En outre,  cause
   des phases de l'API auxquelles <code class="module"><a href="../mod/mod_setenvif.html">mod_setenvif</a></code> prend
   part, les directives <code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code> ne sont pas values
   sparment dans la sous-requte.</p>

  

  <h3><a name="reqall" id="reqall">Require all</a></h3>

    <p>Le fournisseur <code>all</code> reproduit la fonctionnalit
    prcdemment fournie par les directives 'Allow from all' et 'Deny
    from all'. Il accepte un argument dont les deux valeurs possibles
    sont : 'granted' ou 'denied'. Les exemples suivants autorisent ou
    interdisent l'accs  toutes les requtes.</p>

    <pre class="prettyprint lang-config">Require all granted</pre>


    <pre class="prettyprint lang-config">Require all denied</pre>


  

  <h3><a name="reqmethod" id="reqmethod">Require method</a></h3>

    <p>Le fournisseur <code>method</code> permet d'utiliser la mthode
    HTTP dans le processus d'autorisation. Les mthodes GET et HEAD sont
    ici considres comme quivalentes. La mthode TRACE n'est pas
    supporte par ce fournisseur ; utilisez  la place la directive
    <code class="directive"><a href="../mod/core.html#traceenable">TraceEnable</a></code>.</p>

    <p>Dans l'exemple suivant, seules les mthodes GET, HEAD, POST, et
    OPTIONS sont autorises :</p>

    <pre class="prettyprint lang-config">Require method GET POST OPTIONS</pre>


    <p>Dans l'exemple suivant, les mthodes GET, HEAD, POST, et OPTIONS
    sont autorises sans authentification, alors que toutes les autres
    mthodes ncessitent un utilisateur valide :</p>

    <pre class="prettyprint lang-config">&lt;RequireAny&gt;
    Require method GET POST OPTIONS
    Require valid-user
&lt;/RequireAny&gt;</pre>


  
  <h3><a name="reqexpr" id="reqexpr">Require expr</a></h3>

  <p>Le fournisseur <code>expr</code> permet d'accorder l'autorisation
  d'accs de base en fonction d'expressions arbitraires.</p>

    <pre class="prettyprint lang-config">Require expr "%{TIME_HOUR} -ge 9 &amp;&amp; %{TIME_HOUR} -le 17"</pre>


    <pre class="prettyprint lang-config">&lt;RequireAll&gt;
    Require expr "!(%{QUERY_STRING} =~ /secret/)"
    Require expr "%{REQUEST_URI} in { '/example.cgi', '/other.cgi' }" 
&lt;/RequireAll&gt;</pre>


    <pre class="prettyprint lang-config">Require expr "!(%{QUERY_STRING} =~ /secret/) &amp;&amp; %{REQUEST_URI} in { '/example.cgi', '/other.cgi' }"</pre>


    <p>La syntaxe de l'expression est dcrite dans la documentation de <a href="../expr.html">ap_expr</a>.</p>

    <p>Normalement, l'expression est value avant l'authentification.
    Cependant, si l'expression renvoie false et se rfre  la variable
    <code>%{REMOTE_USER}</code>, le processus d'authentification sera
    engag et l'expression rvalue.</p>

  

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authmerging" id="authmerging">Directive</a> <a name="AuthMerging" id="AuthMerging">AuthMerging</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit la manire dont chaque logique d'autorisation des
sections de configuration se combine avec celles des sections de
configuration prcdentes.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthMerging Off | And | Or</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthMerging Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Lorsque l'autorisation est active, elle est normalement hrite
    par chaque <a href="../sections.html#merging">section de
    configuration</a> suivante,  moins qu'un jeu de directives
    d'autorisations diffrent ne soit spcifi. Il s'agit du
    comportement par dfaut, qui correspond  la dfinition explicite
    <code>AuthMerging Off</code>.</p>

    <p>Dans certaines situations cependant, il peut tre souhaitable de
    combiner la logique d'autorisation d'une section de configuration
    avec celle de la section prcdente lorsque les sections de
    configuration se combinent entre elles. Dans ce cas, deux options
    sont disponibles, <code>And</code> et <code>Or</code>.</p>

    <p>Lorsqu'une section de configuration contient <code>AuthMerging
    And</code> ou <code>AuthMerging Or</code>, sa logique d'autorisation
    se combine avec celle de la section de configuration qui la prcde
    (selon l'ordre gnral des sections de configuration), et qui
    contient aussi une logique d'autorisation, comme si les deux
    sections taient concatnes respectivement dans une directive
    <code class="directive"><a href="#requireall">&lt;RequireAll&gt;</a></code> ou <code class="directive"><a href="#requireany">&lt;RequireAny&gt;</a></code>.</p>

    <div class="note">La dfinition de la directive
    <code class="directive">AuthMerging</code> ne concerne que la section de
    configuration dans laquelle elle apparat. Dans l'exemple suivant,
    seuls les utilisateurs appartenant au groupe <code>alpha</code> sont
    autoriss  accder  <code>/www/docs</code>. Les utilisateurs
    appartenant au groupe <code>alpha</code> ou au groupe
    <code>beta</code> sont autoriss  accder 
    <code>/www/docs/ab</code>. Cependant, la dfinition implicite 
    <code>Off</code> de la directive <code class="directive">AuthMerging</code>
    s'applique  la section de configuration <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> concernant le rpertoire
    <code>/www/docs/ab/gamma</code>, ce qui implique que les directives
    d'autorisation de cette section l'emportent sur celles des sections
    prcdentes. Par voie de consquence, seuls les utilisateurs
    appartenant au groupe <code>gamma</code> sont autoriss  accder 
    <code>/www/docs/ab/gamma</code>.</div>

    <pre class="prettyprint lang-config">&lt;Directory "/www/docs"&gt;
    AuthType Basic
    AuthName Documents
    AuthBasicProvider file
    AuthUserFile "/usr/local/apache/passwd/passwords"
    Require group alpha
&lt;/Directory&gt;

&lt;Directory "/www/docs/ab"&gt;
    AuthMerging Or
    Require group beta
&lt;/Directory&gt;

&lt;Directory "/www/docs/ab/gamma"&gt;
    Require group gamma
&lt;/Directory&gt;</pre>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authzprovideralias" id="authzprovideralias">Directive</a> <a name="AuthzProviderAlias" id="AuthzProviderAlias">&lt;AuthzProviderAlias&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe des directives reprsentant une extension d'un
fournisseur d'autorisation de base qui pourra tre rfrence  l'aide
de l'alias spcifi</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;AuthzProviderAlias <var>fournisseur-de-base Alias
Paramtres-Require</var>&gt;
... &lt;/AuthzProviderAlias&gt;
</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;AuthzProviderAlias&gt;</code> et
    <code>&lt;/AuthzProviderAlias&gt;</code> permettent de regrouper des
    directives d'autorisation auxquelles on pourra faire rfrence 
    l'aide de l'alias spcifi dans une directive <code class="directive"><a href="#require">Require</a></code>.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="authzsendforbiddenonfailure" id="authzsendforbiddenonfailure">Directive</a> <a name="AuthzSendForbiddenOnFailure" id="AuthzSendForbiddenOnFailure">AuthzSendForbiddenOnFailure</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Envoie '403 FORBIDDEN' au lieu de '401 UNAUTHORIZED' si
l'authentification russit et si l'autorisation a t refuse.
</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>AuthzSendForbiddenOnFailure On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>AuthzSendForbiddenOnFailure Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.11 d'Apache HTTPD</td></tr>
</table>
    <p>Par dfaut, si l'authentification russit, alors que
    l'autorisation est refuse, Apache HTTPD renvoie un code de rponse
    HTTP '401 UNAUTHORIZED'. En gnral, les navigateurs proposent alors
    une nouvelle fois  l'utilisateur la bote de dialogue de saisie du
    mot de passe, ce qui n'est pas toujours souhaitable. La directive
    <code class="directive">AuthzSendForbiddenOnFailure</code> permet de changer
    le code de rponse en '403 FORBIDDEN'.</p>

    <div class="warning"><h3>Avertissement de scurit</h3>
    <p>La modification de la rponse en cas de refus d'autorisation
    diminue la scurit du mot de passe, car elle indique  un ventuel
    attaquant que le mot de passe qu'il a saisi tait correct.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="require" id="require">Directive</a> <a name="Require" id="Require">Require</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Vrifie si un utilisateur authentifi a une
autorisation d'accs accorde par un fournisseur
d'autorisation.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>Require [not] <var>nom-entit</var> [<var>nom-entit</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Cette directive permet de vrifier si un utilisateur authentifi
    a l'autorisation d'accs accorde pour un certain fournisseur
    d'autorisation et en tenant compte de certaines restrictions.
    <code class="module"><a href="../mod/mod_authz_core.html">mod_authz_core</a></code> met  disposition les fournisseurs
    d'autorisation gnriques suivants :</p>

    <dl>
      <dt><code>Require all granted</code></dt>
      <dd>L'accs est autoris sans restriction.</dd>

      <dt><code>Require all denied</code></dt>
      <dd>L'accs est systmatiquement refus.</dd>

      <dt><code>Require env <var>env-var</var> [<var>env-var</var>]
      ...</code></dt>
      <dd>L'accs n'est autoris que si l'une au moins des variables
      d'environnement spcifies est dfinie.</dd>

      <dt><code>Require method <var>http-method</var> [<var>http-method</var>]
      ...</code></dt>
      <dd>L'accs n'est autoris que pour les mthodes HTTP spcifies.</dd>

      <dt><code>Require expr <var>expression</var> </code></dt>
      <dd>L'accs est autoris si <var>expression</var> est valu 
      vrai.</dd>
    </dl>

    <p>Voici quelques exemples de syntaxes autorises par
    <code class="module"><a href="../mod/mod_authz_user.html">mod_authz_user</a></code>, <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code> et
    <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> :</p>

    <dl>
      <dt><code>Require user <var>identifiant utilisateur</var>
      [<var>identifiant utilisateur</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs spcifis auront accs  la
      ressource.</dd>

      <dt><code>Require group <var>nom groupe</var> [<var>nom
      groupe</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs appartenant aux groupes spcifis
      auront accs  la ressource.</dd>

      <dt><code>Require valid-user</code></dt>
      <dd>Tous les utilisateurs valides auront accs  la
      ressource.</dd>

      <dt><code>Require ip 10 172.20 192.168.2</code></dt>
      <dd>Les clients dont les adresses IP font partie des tranches
      spcifies auront accs  la ressource.</dd>
    </dl>

    <p>D'autres modules d'autorisation comme
    <code class="module"><a href="../mod/mod_authnz_ldap.html">mod_authnz_ldap</a></code>, <code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code>,
    <code class="module"><a href="../mod/mod_authz_dbd.html">mod_authz_dbd</a></code>,
    <code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code> et <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code>
    implmentent des options de la directive Require.</p>

    <p>Pour qu'une configuration d'authentification et d'autorisation
    fonctionne correctement, la directive <code class="directive">Require</code>
    doit tre accompagne dans la plupart des cas de directives <code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code>, <code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code> et <code class="directive"><a href="../mod/mod_auth_basic.html#authbasicprovider">AuthBasicProvider</a></code> ou <code class="directive"><a href="../mod/mod_auth_digest.html#authdigestprovider">AuthDigestProvider</a></code>, ainsi que
    de directives telles que <code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code> et <code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code> (pour la
    dfinition des utilisateurs et des groupes). Exemple :</p>

    <pre class="prettyprint lang-config">AuthType Basic
AuthName "Restricted Resource"
AuthBasicProvider file
AuthUserFile "/web/users"
AuthGroupFile "/web/groups"
Require group admin</pre>


    <p>Les contrles d'accs appliqus de cette manire sont effectifs
    pour <strong>toutes</strong> les mthodes. <strong>C'est d'ailleurs
    ce que l'on souhaite en gnral.</strong> Si vous voulez n'appliquer
    les contrles d'accs qu' certaines mthodes, tout en laissant les
    autres mthodes sans protection, placez la directive
    <code class="directive">Require</code> dans une section <code class="directive"><a href="../mod/core.html#limit">&lt;Limit&gt;</a></code>.</p>

    <p>Le rsultat de la directive <code class="directive">Require</code> peut
    tre invers en utilisant l'option <code>not</code>. Comme dans le
    cas de l'autre directive d'autorisation inverse <code class="directive">&lt;RequireNone&gt;</code>, si la directive
    <code class="directive">Require</code> est inverse, elle ne peut qu'chouer
    ou produire un rsultat neutre ; elle ne peut donc alors pas
    autoriser une requte de manire indpendante.</p>

    <p>Dans l'exemple suivant, tous les utilisateurs appartenant aux
    groupes <code>alpha</code> et <code>beta</code> ont l'autorisation
    d'accs,  l'exception de ceux appartenant au groupe
    <code>reject</code>.</p>

    <pre class="prettyprint lang-config">&lt;Directory "/www/docs"&gt;
    &lt;RequireAll&gt;
        Require group alpha beta
        Require not group reject
    &lt;/RequireAll&gt;
&lt;/Directory&gt;</pre>


    <p>Lorsque plusieurs directives <code class="directive">Require</code> sont
    places dans une mme <a href="../sections.html#merging">section de
    configuration</a>, et ne se trouvent pas dans une autre directive
    d'autorisation comme <code class="directive"><a href="#requireall">&lt;RequireAll&gt;</a></code>, elles sont implicitement
    contenues dans une directive <code class="directive"><a href="#requireany">&lt;RequireAny&gt;</a></code>. Ainsi, la premire directive
    <code class="directive">Require</code> qui autorise l'accs  un utilisateur
    autorise l'accs pour l'ensemble de la requte, et les directives
    <code class="directive">Require</code> suivantes sont ignores.</p>

    <div class="warning"><h3>Avertissement  propos de la scurit</h3>
    <p>Prettez une attention particulire aux directives d'autorisation
    dfinies
    au sein des sections <code class="directive"><a href="../mod/core.html#location">Location</a></code>
    qui se chevauchent avec des contenus servis depuis le systme de
    fichiers. Par dfaut, les configurations dfinies dans ces <a href="../sections.html#merging">sections</a> l'emportent sur les
    configurations d'autorisations dfinies au sein des sections
    <code class="directive"><a href="../mod/core.html#directory">Directory</a></code> et <code class="directive"><a href="../mod/core.html#files">Files</a></code> sections.</p>
    <p>La directive <code class="directive"><a href="#authmerging">AuthMerging</a></code> permet de contrler
    la manire selon laquelle les configurations d'autorisations sont
    fusionnes au sein des sections prcites.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="../howto/access.html">Tutoriel du contrle d'accs</a></li>
<li><a href="#logic">Conteneurs d'autorisation</a></li>
<li><code class="module"><a href="../mod/mod_authn_core.html">mod_authn_core</a></code></li>
<li><code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="requireall" id="requireall">Directive</a> <a name="RequireAll" id="RequireAll">&lt;RequireAll&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe plusieurs directives d'autorisation dont aucune ne
doit chouer et dont au moins une doit retourner un rsultat positif
pour que la directive globale retourne elle-mme un rsultat
positif.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;RequireAll&gt; ... &lt;/RequireAll&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;RequireAll&gt;</code> et
    <code>&lt;/RequireAll&gt;</code> permettent de regrouper des
    directives d'autorisation dont aucune ne doit chouer, et dont au
    moins une doit retourner un rsultat positif pour que la directive
    <code class="directive">&lt;RequireAll&gt;</code> retourne elle-mme
    un rsultat positif.</p>

    <p>Si aucune des directives contenues dans la directive <code class="directive">&lt;RequireAll&gt;</code> n'choue, et si au moins une
    retourne un rsultat positif, alors la directive <code class="directive">&lt;RequireAll&gt;</code> retourne elle-mme un rsultat
    positif. Si aucune ne retourne un rsultat positif, et si aucune
    n'choue, la directive globale retourne un rsultat neutre. Dans
    tous les autres cas, elle choue.</p>

<h3>Voir aussi</h3>
<ul>
<li><a href="#logic">Conteneurs d'autorisation</a></li>
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="requireany" id="requireany">Directive</a> <a name="RequireAny" id="RequireAny">&lt;RequireAny&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe des directives d'autorisation dont au moins une
doit retourner un rsultat positif pour que la directive globale
retourne elle-mme un rsultat positif.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;RequireAny&gt; ... &lt;/RequireAny&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;RequireAny&gt;</code> et
    <code>&lt;/RequireAny&gt;</code> permettent de regrouper des
    directives d'autorisation dont au moins une doit retourner un
    rsultat positif pour que la directive <code class="directive">&lt;RequireAny&gt;</code> retourne elle-mme un rsultat
    positif.</p>

    <p>Si une ou plusieurs directives contenues dans la directive
    <code class="directive">&lt;RequireAny&gt;</code> retournent un
    rsultat positif, alors la directive <code class="directive">&lt;RequireAny&gt;</code> retourne elle-mme un rsultat
    positif. Si aucune ne retourne un rsultat positif et aucune
    n'choue, la directive globale retourne un rsultat neutre. Dans
    tous les autres cas, elle choue.</p>

    <div class="note">Comme les directives d'autorisation inverses sont incapables
    de retourner un rsultat positif, elles ne peuvent pas impacter de
    manire significative le rsultat d'une directive <code class="directive">&lt;RequireAny&gt;</code> (elles pourraient tout au plus
    faire chouer la directive dans le cas o elles choueraient
    elles-mmes, et o
    toutes les autres directives retourneraient un rsultat neutre).
    C'est pourquoi il n'est pas permis d'utiliser les directives
    d'autorisation inverses dans une directive <code class="directive">&lt;RequireAny&gt;</code>.</div>

<h3>Voir aussi</h3>
<ul>
<li><a href="#logic">Conteneurs d'autorisation</a></li>
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="requirenone" id="requirenone">Directive</a> <a name="RequireNone" id="RequireNone">&lt;RequireNone&gt;</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Regroupe des directives d'autorisation dont aucune ne doit
retourner un rsultat positif pour que la directive globale n'choue
pas.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;RequireNone&gt; ... &lt;/RequireNone&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>AuthConfig</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_authz_core</td></tr>
</table>
    <p>Les balises <code class="directive">&lt;RequireNone&gt;</code> et
    <code>&lt;/RequireNone&gt;</code> permettent de regrouper des
    directives d'autorisation dont aucune ne doit retourner un rsultat
    positif pour que la directive <code class="directive">&lt;RequireNone&gt;</code> n'choue pas.</p>

    <p>Si une ou plusieurs directives contenues dans la directive
    <code class="directive">&lt;RequireNone&gt;</code> retournent un
    rsultat positif, la directive <code class="directive">&lt;RequireNone&gt;</code> chouera. Dans tous les
    autres cas, cette dernire retournera un rsultat neutre. Ainsi,
    comme pour la directive d'autorisation inverse <code>Require
    not</code>, elle ne peut jamais autoriser une requte de manire
    indpendante car elle ne pourra jamais retourner un rsultat
    positif. Par contre, on peut l'utiliser pour restreindre l'ensemble
    des utilisateurs autoriss  accder  une ressource.</p>

    <div class="note">Comme les directives d'autorisation inverses sont incapables
    de retourner un rsultat positif, elles ne peuvent pas impacter de
    manire significative le rsultat d'une directive <code class="directive">&lt;RequireNone&gt;</code>.
    C'est pourquoi il n'est pas permis d'utiliser les directives
    d'autorisation inverses dans une directive <code class="directive">&lt;RequireNone&gt;</code>.</div>

<h3>Voir aussi</h3>
<ul>
<li><a href="#logic">Conteneurs d'autorisation</a></li>
<li><a href="../howto/auth.html">Authentification, autorisation et
contrle d'accs</a></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_core.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_core.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authz_core.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>