/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.columns;

import com.metamatrix.jdbc.sequelink.columns.SequeLinkColumnDescribe;
import com.metamatrix.jdbc.sequelink.columns.SequeLinkDateTimeColumn;
import com.metamatrix.jdbc.sequelink.utilities.BooleanArray;
import com.metamatrix.jdbc.sequelink.utilities.IntArray;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class SequeLinkTimeColumn
extends SequeLinkDateTimeColumn {
    private IntArray array;
    private BooleanArray isNull;

    public SequeLinkTimeColumn(StatementContext statementContext, SequeLinkColumnDescribe sequeLinkColumnDescribe, int n) throws SQLException {
        super(statementContext, sequeLinkColumnDescribe, n, 12);
        this.out = new char[19];
        this.array = new IntArray();
        this.isNull = new BooleanArray();
    }

    protected void setBindInfo() {
        this.sqlnkType = 8;
        this.sqlnkSize = 3;
    }

    protected void readDataFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        int n = sspInputStream.readSSPInt8();
        n <<= 6;
        n |= sspInputStream.readSSPInt8();
        n <<= 6;
        this.array.add(n |= sspInputStream.readSSPInt8());
        this.isNull.add(false);
    }

    protected void readNull() {
        this.array.add(0);
        this.isNull.add(true);
    }

    public void clearData() {
        this.array.reset();
        this.isNull.reset();
    }

    public BaseData getData(int n, int n2, DiagnosticList diagnosticList) throws SQLException {
        if (this.isNull.get(n2)) {
            this.myBaseData.setNull(this.baseDataType);
            return this.myBaseData;
        }
        int n3 = this.array.get(n2);
        int n4 = n3 & 0x3F;
        int n5 = (n3 >>= 6) & 0x3F;
        int n6 = n3 >>= 6;
        switch (n) {
            case 12: {
                Time time = new Time(n6, n5, n4);
                this.myBaseData.setTime(time);
                break;
            }
            case 10: {
                String string = this.getTimeString(n6, n5, n4);
                this.myBaseData.setString(string);
                break;
            }
            case 13: {
                Timestamp timestamp = new Timestamp(70, 0, 1, n6, n5, n4, 0);
                this.myBaseData.setTimestamp(timestamp);
                break;
            }
            default: {
                Time time = new Time(n6, n5, n4);
                this.myBaseData.setTime(time);
            }
        }
        return this.myBaseData;
    }

    private String getTimeString(int n, int n2, int n3) throws SQLException {
        this.pos = 0;
        this.writeInt(n, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n2, 2);
        this.out[this.pos++] = 58;
        this.writeInt(n3, 2);
        return new String(this.out, 0, this.pos);
    }
}

