/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.api.HostInfo;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.socket.ObjectSocket;
import com.metamatrix.common.comm.platform.socket.ObjectSocketFactory;
import com.metamatrix.common.comm.platform.socket.ObjectSocketImpl;
import com.metamatrix.common.comm.platform.socket.SocketConnectionProtocol;
import com.metamatrix.common.comm.platform.socket.SocketLog;
import com.metamatrix.common.comm.platform.socket.SocketUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class ObjectSocketFactoryImpl
implements ObjectSocketFactory {
    private static ObjectSocketFactoryImpl instance;

    private ObjectSocketFactoryImpl() {
    }

    public static synchronized ObjectSocketFactoryImpl getInstance() {
        if (instance == null) {
            instance = new ObjectSocketFactoryImpl();
        }
        return instance;
    }

    public ObjectSocket createObjectSocket(HostInfo hostInfo, SocketLog log, ClassLoader cl, int inputBufferSize, int outputBufferSize, boolean conserveBandwidth, SocketConnectionProtocol protocol) throws IOException, CommunicationException {
        Socket socket = SocketUtil.createSocket(hostInfo.getSSL());
        socket.setReceiveBufferSize(inputBufferSize);
        socket.setSendBufferSize(outputBufferSize);
        socket.setTcpNoDelay(!conserveBandwidth);
        InetSocketAddress address = null;
        address = hostInfo.getInetAddress() != null ? new InetSocketAddress(hostInfo.getInetAddress(), hostInfo.getPortNumber()) : new InetSocketAddress(hostInfo.getHostName(), hostInfo.getPortNumber());
        socket.connect(address);
        ObjectSocketImpl result = new ObjectSocketImpl(socket, log, cl, inputBufferSize, outputBufferSize);
        result.initialize(protocol);
        return result;
    }
}

