/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.auth.MGSSException;
import com.metamatrix.sequelink.auth.MGSSHandle;
import com.metamatrix.sequelink.auth.MGSSToken;
import com.metamatrix.sequelink.ssp.CodecChainedPacket;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspContext;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;
import java.sql.SQLException;

public class CodecAuthenticate
extends CodecChainedPacket {
    MGSSHandle securityHandle;
    int majorReturnCode;
    MGSSToken outputToken;
    MGSSToken inputToken;

    CodecAuthenticate(SspContext sspContext, MGSSHandle mGSSHandle, MGSSToken mGSSToken, int n2) {
        super(37, sspContext);
        this.securityHandle = mGSSHandle;
        this.majorReturnCode = n2;
        this.outputToken = mGSSToken;
    }

    void encodeBody() throws IOException, UtilException {
        this.sos.writeSSPString(this.securityHandle.getMechanism());
        this.sos.writeSSPInt32(this.majorReturnCode);
        this.securityHandle.streamToken(this.sos, this.outputToken);
    }

    void decodeBodyMinus() throws IOException, SQLException {
        this.majorReturnCode = this.sis.readSSPInt32();
    }

    void decodeBodyPlus() throws IOException, SQLException, UtilException {
        try {
            this.inputToken = this.securityHandle.unstreamToken(this.sis);
        }
        catch (MGSSException mGSSException) {
            SQLException sQLException = Message.Gen.getSqlException(7853);
            SQLException sQLException2 = new SQLException(mGSSException.toString(), "08001");
            sQLException.setNextException(sQLException2);
            throw sQLException;
        }
    }

    public MGSSToken getInputToken() {
        return this.inputToken;
    }

    public int getMajorReturnCode() {
        return this.majorReturnCode;
    }
}

