/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseEscapeTranslator;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseSQLColumnSpecification;
import com.metamatrix.jdbc.slbase.BaseSQLEscapeProcessor;
import com.metamatrix.jdbc.slbase.BaseSQLFromSpecificationGenerator;
import com.metamatrix.jdbc.slbase.BaseSQLListManipulator;
import com.metamatrix.jdbc.slbase.BaseSQLListPartManipulator;
import com.metamatrix.jdbc.slbase.BaseSQLParameterProcessor;
import com.metamatrix.jdbc.slbase.BaseSQLParenExpListManipulator;
import com.metamatrix.jdbc.slbase.BaseSQLParser;
import com.metamatrix.jdbc.slbase.BaseSQLPredicateParamProcessor;
import com.metamatrix.jdbc.slbase.BaseSQLStringGenerator;
import com.metamatrix.jdbc.slbase.BaseSQLTableReference;
import com.metamatrix.jdbc.slbase.BaseSQLTreeNode;
import com.metamatrix.jdbc.slbase.BaseSQLTreeNodeSearch;
import com.metamatrix.jdbc.slbase.BaseSQLTreePreOrderTraverser;
import com.metamatrix.slutil.UtilVectorUnsynced;
import java.sql.SQLException;

public final class BaseSQL {
    public static final int PROCESS_NONE = 0;
    public static final int PROCESS_PARAMS = 1;
    public static final int PROCESS_ESCAPES = 2;
    public static final int PROCESS_FULL = 4;
    public static final int PROCESS_PREDICATES = 8;
    public static final int PROCESS_TABLES = 16;
    public static final int SQL_UNKNOWN = 0;
    public static final int SQL_DML_SELECT = 1;
    public static final int SQL_DDL_CREATE_TABLE = 2;
    public static final int SQL_DML_CALL = 3;
    public static final int SQL_DML_INSERT_TABLE = 4;
    public static final int SQL_DML_UPDATE_TABLE = 5;
    private String originalSQL;
    private boolean hasForUpdate = false;
    private boolean hasReadOnly = false;
    BaseEscapeTranslator escapeTranslator;
    private int processLevel;
    private char quote;
    private int type;
    private BaseSQLTreeNode treeRoot;
    private UtilVectorUnsynced createTableColumnSpecificationNodes;
    private BaseSQLListPartManipulator selectListManipulator;
    private boolean hasEscape = false;
    private boolean hasParameter = false;
    private int parameterCount = -1;
    private boolean isBatch = false;
    private UtilVectorUnsynced originalSQLs;
    private int currentBatch = 0;
    private BaseExceptions exceptions;
    private BaseSQLTreeNode updateTableRootNode;
    private BaseSQLTreeNode updateNamesRootNode;
    private BaseSQLTreeNode updateValuesRootNode;
    private BaseSQLTreeNode updateNameValuesRootNode;
    private UtilVectorUnsynced updateNames;
    private int updateNamesCount;
    private UtilVectorUnsynced updateValues;
    private int updateValuesCount;
    private BaseSQLListPartManipulator updateNameValues;
    private int updateNamesValuesCount;
    private UtilVectorUnsynced parameterNodes;
    private UtilVectorUnsynced tableInfo;

    public BaseSQL(String string, int n2, char c2, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        this.originalSQL = string;
        this.processLevel = n2;
        this.quote = c2;
        this.escapeTranslator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.processSQL();
    }

    public BaseSQL(String string, BaseSQL baseSQL) throws SQLException {
        this.originalSQL = string;
        this.processLevel = baseSQL.processLevel;
        this.quote = baseSQL.quote;
        this.escapeTranslator = baseSQL.escapeTranslator;
        this.exceptions = baseSQL.exceptions;
        this.processSQL();
    }

    public BaseSQL(BaseSQL baseSQL, int n2) throws SQLException {
        this.originalSQL = baseSQL.originalSQL;
        this.processLevel = n2;
        this.quote = baseSQL.quote;
        this.escapeTranslator = baseSQL.escapeTranslator;
        this.exceptions = baseSQL.exceptions;
        this.processSQL();
    }

    public BaseSQL(char c2, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        this.quote = c2;
        this.escapeTranslator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.isBatch = true;
    }

    public BaseEscapeTranslator getEscapeTranslator() {
        return this.escapeTranslator;
    }

    public void setEscapeTranslator(BaseEscapeTranslator baseEscapeTranslator) {
        this.escapeTranslator = baseEscapeTranslator;
    }

    public void dumpTree() throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        baseSQLTreePreOrderTraverser.setExceptions(this.exceptions);
        baseSQLTreePreOrderTraverser.traverse(this.treeRoot);
    }

    void processSQL() throws SQLException {
        this.buildSQLTree();
        if (this.escapeTranslator != null && this.hasEscape) {
            BaseSQLEscapeProcessor baseSQLEscapeProcessor = new BaseSQLEscapeProcessor();
            baseSQLEscapeProcessor.processEscapes(this.treeRoot, this.escapeTranslator, this.exceptions);
        }
        this.resultType();
        if (this.hasParameter) {
            this.getParameterCount();
        }
    }

    public boolean nextBatchStatement() throws SQLException {
        boolean bl = false;
        if (this.originalSQLs != null && this.currentBatch < this.originalSQLs.size()) {
            BaseBatchSubStatement baseBatchSubStatement = (BaseBatchSubStatement)this.originalSQLs.elementAt(this.currentBatch);
            this.originalSQL = baseBatchSubStatement.originalSQL;
            this.processLevel = baseBatchSubStatement.processLevel;
            this.processSQL();
            ++this.currentBatch;
        }
        return bl;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public int batchSize() {
        return this.originalSQLs.size();
    }

    public void addToBatch(String string, int n2) {
        if (this.originalSQLs == null) {
            this.originalSQLs = new UtilVectorUnsynced();
        }
        BaseBatchSubStatement baseBatchSubStatement = new BaseBatchSubStatement();
        baseBatchSubStatement.originalSQL = string;
        baseBatchSubStatement.processLevel = n2;
        this.originalSQLs.addElement(baseBatchSubStatement);
    }

    public void clearBatch() {
        this.originalSQLs.setSize(0);
        this.currentBatch = 0;
    }

    public String getOriginal() {
        return this.originalSQL;
    }

    public String getVerb() {
        try {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            return baseSQLStringGenerator.generateSQL(this.treeRoot, true, this.exceptions);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public int getType() {
        return this.type;
    }

    public boolean isStatementSuitableForAutoGeneratedKeys() {
        if ((this.processLevel & 4) != 0) {
            BaseSQLTreeNode baseSQLTreeNode = this.treeRoot;
            if (baseSQLTreeNode.type == 1001) {
                int n2 = 0;
                for (baseSQLTreeNode = baseSQLTreeNode.leftMostChild(); baseSQLTreeNode != null; baseSQLTreeNode = baseSQLTreeNode.getRightSibling()) {
                    if (baseSQLTreeNode.type != 1002) continue;
                    if (++n2 > 1) {
                        return false;
                    }
                    if (baseSQLTreeNode.leftMostChild() == null || baseSQLTreeNode.leftMostChild().type == 1004) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isCallEscapeStatement() {
        BaseSQLTreeNode baseSQLTreeNode = this.treeRoot;
        if (baseSQLTreeNode.type == 1001) {
            baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
            if (baseSQLTreeNode.type == 1002) {
                baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
                if (baseSQLTreeNode.type == 1006) {
                    baseSQLTreeNode = baseSQLTreeNode.leftMostChild();
                    if (baseSQLTreeNode.type == 8210 || baseSQLTreeNode.type == 8209) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String getFormatted() {
        try {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            String string = baseSQLStringGenerator.generateSQL(this.treeRoot, false, this.exceptions);
            return string;
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    void replaceSelectListWithString(String string) throws SQLException {
        this.selectListManipulator = new BaseSQLListPartManipulator();
        this.selectListManipulator.replaceSelectList(this.treeRoot, string, this.exceptions);
        this.selectListManipulator = null;
    }

    void setUpdateTableNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateTableRootNode = baseSQLTreeNode;
    }

    void setUpdateValuesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateValuesRootNode = baseSQLTreeNode;
    }

    void setUpdateNamesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateNamesRootNode = baseSQLTreeNode;
    }

    void setUpdateNameValuesNode(BaseSQLTreeNode baseSQLTreeNode) {
        this.updateNameValuesRootNode = baseSQLTreeNode;
    }

    public String getUpdateTableSpecification() {
        String string = null;
        try {
            if (this.updateTableRootNode != null) {
                BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
                string = baseSQLStringGenerator.generateSQL(this.updateTableRootNode, false, this.exceptions);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String getUpdateColumnSpecification(int n2) {
        try {
            if (this.type == 5) {
                if (this.updateNameValuesRootNode != null && this.updateNameValues == null) {
                    this.updateNameValues = new BaseSQLListPartManipulator();
                    this.updateNamesValuesCount = this.updateNameValues.countElements(this.updateNameValuesRootNode, this.exceptions);
                }
                if (n2 <= this.updateNamesValuesCount) {
                    int n3 = 0;
                    UtilVectorUnsynced utilVectorUnsynced = null;
                    for (int i2 = 0; n3 < n2 && i2 < this.updateNamesValuesCount; ++i2) {
                        utilVectorUnsynced = this.updateNameValues.getElementNodes(i2);
                        if (!this.selectColumnSpecificationContainsNode(utilVectorUnsynced, 1018)) continue;
                        ++n3;
                        if (n3 >= n2) continue;
                        utilVectorUnsynced = null;
                    }
                    if (utilVectorUnsynced != null) {
                        return this.buildFromParts(utilVectorUnsynced, "=");
                    }
                }
            } else if (this.type == 4 && this.updateValuesRootNode != null) {
                if (this.updateNames == null) {
                    this.updateNames = new UtilVectorUnsynced();
                    this.updateNamesCount = this.getFirstTopLevelParenExpListCount(this.updateNamesRootNode, this.updateNames);
                }
                if (this.updateValues == null) {
                    this.updateValues = new UtilVectorUnsynced();
                    this.updateValuesCount = this.getFirstTopLevelParenExpListCount(this.updateValuesRootNode, this.updateValues);
                }
                UtilVectorUnsynced utilVectorUnsynced = null;
                int n4 = 0;
                int n5 = 0;
                if (n2 <= this.updateValuesCount) {
                    while (n5 < n2) {
                        if ((utilVectorUnsynced = this.getFirstTopLevelParenExpListElementNodes(this.updateValues, n4++)) == null) {
                            return null;
                        }
                        if (!this.selectColumnSpecificationContainsNode(utilVectorUnsynced, 1018)) continue;
                        ++n5;
                    }
                }
                if (n4 != 0) {
                    if (n4 > this.updateNamesCount) {
                        return Integer.toString(n4);
                    }
                    utilVectorUnsynced = this.getFirstTopLevelParenExpListElementNodes(this.updateNames, n4 - 1);
                    return this.buildFromParts(utilVectorUnsynced, null);
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    private void buildSQLTree() throws SQLException {
        BaseSQLParser baseSQLParser = null;
        int n2 = 0;
        this.hasParameter = this.containsParameterMarker();
        this.hasEscape = this.containsEscape();
        if ((this.processLevel & 4) != 0) {
            n2 |= 4;
        }
        if ((this.processLevel & 8) != 0) {
            n2 |= 8;
        }
        if ((this.processLevel & 0x10) != 0) {
            n2 |= 0x10;
        }
        if (this.hasParameter) {
            n2 |= 1;
            this.parameterNodes = new UtilVectorUnsynced();
        }
        if (this.hasEscape && ((this.processLevel & 4) != 0 || (this.processLevel & 2) != 0)) {
            n2 |= 2;
        }
        baseSQLParser = new BaseSQLParser(this.escapeTranslator, n2);
        baseSQLParser.setUp(this, this.exceptions);
        this.treeRoot = baseSQLParser.parse(this.originalSQL, '\"');
        this.tableInfo = baseSQLParser.tableInfo;
    }

    public int getParameterCount() {
        try {
            if (this.parameterCount == -1) {
                if (this.hasParameter) {
                    this.parameterNodes = new UtilVectorUnsynced();
                    BaseSQLParameterProcessor baseSQLParameterProcessor = new BaseSQLParameterProcessor();
                    this.parameterNodes = baseSQLParameterProcessor.getParameterNodes(this.treeRoot, this.exceptions);
                    this.parameterCount = this.parameterNodes == null ? 0 : this.parameterNodes.size();
                } else {
                    this.parameterCount = 0;
                }
            }
            return this.parameterCount;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public void setParameter(int n2, String string) {
        if (this.parameterNodes != null) {
            ((BaseSQLTreeNode)this.parameterNodes.elementAt((int)n2)).value = string;
        }
    }

    public String getStringPreceedingParameter(int n2) {
        String string = null;
        if (this.parameterCount > 0) {
            BaseSQLTreeNode baseSQLTreeNode = (BaseSQLTreeNode)this.parameterNodes.elementAt(n2);
            for (baseSQLTreeNode = baseSQLTreeNode.getPrevious(); baseSQLTreeNode != null && baseSQLTreeNode.type == 1020; baseSQLTreeNode = baseSQLTreeNode.getPrevious()) {
            }
            if (baseSQLTreeNode != null) {
                string = baseSQLTreeNode.value;
            }
        }
        return string;
    }

    public boolean resultType() throws SQLException {
        boolean bl;
        String string = this.getVerb();
        if (this.isCallEscapeStatement()) {
            bl = true;
            this.type = 3;
        } else if (string.equalsIgnoreCase("select")) {
            bl = true;
            this.type = 1;
        } else if (string.equalsIgnoreCase("create table")) {
            bl = false;
            this.type = 2;
        } else if (string.equalsIgnoreCase("insert")) {
            bl = false;
            this.type = 4;
        } else if (string.equalsIgnoreCase("update")) {
            bl = false;
            this.type = 5;
        } else {
            bl = false;
            this.type = 0;
        }
        return bl;
    }

    public int getCreateTableColumnSpecificationCount() {
        if (this.getType() != 2) {
            return -1;
        }
        try {
            this.createTableColumnSpecificationNodes = new UtilVectorUnsynced();
            return this.getFirstTopLevelParenExpListCount(this.treeRoot, this.createTableColumnSpecificationNodes);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public UtilVectorUnsynced getCreateTableColumnSpecification(int n2) {
        try {
            if (this.createTableColumnSpecificationNodes == null) {
                return null;
            }
            return this.getFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n2);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public void setCreateTableColumnSpecification(int n2, String string) {
        try {
            if (this.createTableColumnSpecificationNodes != null) {
                this.setFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n2, string);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public int getFirstTopLevelParenExpListCount(BaseSQLTreeNode baseSQLTreeNode, UtilVectorUnsynced utilVectorUnsynced) throws SQLException {
        BaseSQLParenExpListManipulator baseSQLParenExpListManipulator = new BaseSQLParenExpListManipulator();
        utilVectorUnsynced.addElement(baseSQLParenExpListManipulator);
        return baseSQLParenExpListManipulator.countElements(baseSQLTreeNode, this.exceptions);
    }

    public int getFirstTopLevelParenExpListCount(UtilVectorUnsynced utilVectorUnsynced) throws SQLException {
        return this.getFirstTopLevelParenExpListCount(this.treeRoot, utilVectorUnsynced);
    }

    public UtilVectorUnsynced getFirstTopLevelParenExpListElement(UtilVectorUnsynced utilVectorUnsynced, int n2) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        return baseSQLListManipulator.getElement(n2);
    }

    public UtilVectorUnsynced getFirstTopLevelParenExpListElementNodes(UtilVectorUnsynced utilVectorUnsynced, int n2) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        return baseSQLListManipulator.getElementNodes(n2);
    }

    public void setFirstTopLevelParenExpListElement(UtilVectorUnsynced utilVectorUnsynced, int n2, String string) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)utilVectorUnsynced.elementAt(0);
        baseSQLListManipulator.setElement(n2, string + " ", this.exceptions);
    }

    public String getSelectList() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n2 = this.getSelectColumnSpecificationCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                UtilVectorUnsynced utilVectorUnsynced = this.getSelectColumnSpecification(i2);
                int n3 = utilVectorUnsynced.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    stringBuffer.append((String)utilVectorUnsynced.elementAt(i3));
                }
                if (i2 >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
        }
        catch (SQLException sQLException) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getSelectColumnSpecificationCount() throws SQLException {
        if (this.getType() != 1) {
            return -1;
        }
        this.selectListManipulator = new BaseSQLListPartManipulator();
        return this.selectListManipulator.countElements(this.treeRoot, this.exceptions);
    }

    public UtilVectorUnsynced getSelectColumnSpecification(int n2) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return null;
        }
        return this.selectListManipulator.getElement(n2);
    }

    public void setSelectColumnSpecification(int n2, String string) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return;
        }
        this.selectListManipulator.setElement(n2, string + " ", this.exceptions);
    }

    public boolean selectColumnSpecificationContainsValue(UtilVectorUnsynced utilVectorUnsynced, String string) {
        int n2 = utilVectorUnsynced.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string.equalsIgnoreCase((String)utilVectorUnsynced.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    public boolean selectColumnSpecificationContainsNode(UtilVectorUnsynced utilVectorUnsynced, int n2) {
        int n3 = utilVectorUnsynced.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 != ((BaseSQLTreeNode)utilVectorUnsynced.elementAt((int)i2)).type) continue;
            return true;
        }
        return false;
    }

    public String buildFromParts(UtilVectorUnsynced utilVectorUnsynced, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = utilVectorUnsynced.size();
        BaseSQLTreeNode baseSQLTreeNode = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            baseSQLTreeNode = (BaseSQLTreeNode)utilVectorUnsynced.elementAt(i2);
            if (baseSQLTreeNode.value == null) continue;
            if (string != null && string.equals(baseSQLTreeNode.value)) break;
            stringBuffer.append(baseSQLTreeNode.value);
        }
        return stringBuffer.toString();
    }

    public String getSingleTableFromSpecification() throws SQLException {
        String string = null;
        if (this.getType() == 1) {
            BaseSQLFromSpecificationGenerator baseSQLFromSpecificationGenerator = new BaseSQLFromSpecificationGenerator();
            baseSQLFromSpecificationGenerator.generate(this.treeRoot, this.exceptions);
            int n2 = baseSQLFromSpecificationGenerator.getSpecificationObjectCount();
            if (n2 > 0) {
                string = "";
                boolean bl = true;
                int n3 = 1;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string2 = baseSQLFromSpecificationGenerator.getSpecificationObject(i2);
                    char c2 = string2.charAt(0);
                    if (i2 % 2 == 0 && (c2 == '.' || c2 == ':')) {
                        n3 = 0;
                    }
                    if (i2 % 2 == n3 && c2 != '.' && c2 != ':') {
                        bl = false;
                    }
                    if (c2 == ',') {
                        string = null;
                        break;
                    }
                    if (!bl) continue;
                    string = string + string2;
                }
            }
        }
        return string;
    }

    protected boolean lookForSelectNodeType(int n2) {
        boolean bl = false;
        if (this.getType() == 1) {
            BaseSQLTreeNodeSearch baseSQLTreeNodeSearch = new BaseSQLTreeNodeSearch();
            try {
                if (baseSQLTreeNodeSearch.search(this.treeRoot, n2, this.exceptions) != null) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean hasForReadOnly() {
        return this.hasReadOnly;
    }

    void hasForReadOnly(boolean bl) {
        this.hasReadOnly = bl;
    }

    public boolean hasForUpdate() {
        return this.hasForUpdate;
    }

    void hasForUpdate(boolean bl) {
        this.hasForUpdate = bl;
    }

    public boolean hasGroupBy() {
        return this.lookForSelectNodeType(1010);
    }

    public boolean hasWhereClause() {
        boolean bl = false;
        switch (this.getType()) {
            case 1: 
            case 5: {
                BaseSQLTreeNodeSearch baseSQLTreeNodeSearch = new BaseSQLTreeNodeSearch();
                try {
                    if (baseSQLTreeNodeSearch.search(this.treeRoot, 1009, this.exceptions) == null) break;
                    bl = true;
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 2: 
            case 3: {
                bl = false;
                break;
            }
            case 0: 
            case 4: {
                bl = this.originalSQL.toLowerCase().indexOf("where") != -1;
            }
        }
        return bl;
    }

    public boolean hasHaving() {
        return this.lookForSelectNodeType(1013);
    }

    public boolean hasSetOperation() {
        return this.lookForSelectNodeType(1011);
    }

    public boolean hasOrderBy() {
        return this.lookForSelectNodeType(1012);
    }

    public boolean hasAggregateOrParameterInSelectList(String[] stringArray) throws SQLException {
        if (stringArray == null) {
            return false;
        }
        int n2 = this.getSelectColumnSpecificationCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            UtilVectorUnsynced utilVectorUnsynced = this.getSelectColumnSpecification(i2);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!this.selectColumnSpecificationContainsValue(utilVectorUnsynced, stringArray[i3]) && !this.selectColumnSpecificationContainsValue(utilVectorUnsynced, "?")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSelectDistinct() throws SQLException {
        UtilVectorUnsynced utilVectorUnsynced;
        int n2 = this.getSelectColumnSpecificationCount();
        return n2 > 0 && this.selectColumnSpecificationContainsValue(utilVectorUnsynced = this.getSelectColumnSpecification(0), "DISTINCT");
    }

    private boolean containsParameterMarker() {
        return this.originalSQL.indexOf(63) != -1;
    }

    private boolean containsEscape() {
        return this.originalSQL.indexOf(123) != -1;
    }

    public UtilVectorUnsynced getPredicateParamColumnDefinitions() {
        return new BaseSQLPredicateParamProcessor().getDescribeSelectStatements(this.treeRoot, this.exceptions);
    }

    public UtilVectorUnsynced getSelectTables() {
        try {
            if (this.getType() == 1) {
                Object object;
                if (this.tableInfo == null) {
                    object = new BaseSQL(this, 20);
                    this.tableInfo = ((BaseSQL)object).tableInfo;
                }
                if (this.tableInfo != null && this.tableInfo.size() > 0) {
                    object = new UtilVectorUnsynced();
                    int n2 = this.tableInfo.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Object var5_5 = null;
                        BaseSQLTableReference baseSQLTableReference = new BaseSQLTableReference();
                        BaseSQLTreeNode baseSQLTreeNode = (BaseSQLTreeNode)((Object[])this.tableInfo.elementAt(i2))[0];
                        baseSQLTreeNode = baseSQLTreeNode.leftMostChild;
                        while (baseSQLTreeNode != null) {
                            baseSQLTableReference.addPart(baseSQLTreeNode.value);
                            baseSQLTreeNode = baseSQLTreeNode.rightSibling;
                        }
                        baseSQLTreeNode = (BaseSQLTreeNode)((Object[])this.tableInfo.elementAt(i2))[1];
                        if (baseSQLTreeNode != null) {
                            baseSQLTableReference.setCorrelation(baseSQLTreeNode.value);
                        }
                        ((UtilVectorUnsynced)object).add(baseSQLTableReference);
                    }
                    return object;
                }
                return null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    public BaseSQLColumnSpecification[] getSelectColumns() {
        try {
            int n2;
            if (this.getType() == 1 && (n2 = this.getSelectColumnSpecificationCount()) > 0) {
                BaseSQLColumnSpecification[] baseSQLColumnSpecificationArray = new BaseSQLColumnSpecification[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    baseSQLColumnSpecificationArray[i2] = new BaseSQLColumnSpecification(this.getSelectColumnSpecification(i2));
                }
                return baseSQLColumnSpecificationArray;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    class BaseBatchSubStatement {
        String originalSQL;
        int processLevel;

        BaseBatchSubStatement() {
        }
    }
}

