/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.slutil.UtilDebug;
import java.sql.SQLException;

public abstract class BaseImplClob {
    public static final int ASCII_ENCODING = 1;
    public static final int UCS2_ENCODING = 2;
    protected BaseExceptions exceptions;
    public static final String ASCII_ENCODING_NAME = "ISO-8859-1";
    public static final String UCS2_ENCODING_NAME = "UTF-16BE";

    public BaseImplClob(BaseExceptions baseExceptions) {
        UtilDebug.assert("Must supply an exception generator", baseExceptions != null);
        this.exceptions = baseExceptions;
    }

    public boolean supportsSearch() {
        return false;
    }

    public long find(String string, long l2) throws SQLException {
        throw this.exceptions.getException(6003);
    }

    public static int getBytesPerChar(BaseImplClob baseImplClob) {
        UtilDebug.assert("Must supply a BaseImplClob object", baseImplClob != null);
        int n2 = -1;
        switch (baseImplClob.getCharacterEncoding()) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            default: {
                UtilDebug.assert("Invalid character encoding", false);
            }
        }
        return n2;
    }

    public static String getEncodingName(int n2) {
        String string = null;
        switch (n2) {
            case 1: {
                string = ASCII_ENCODING_NAME;
                break;
            }
            case 2: {
                string = UCS2_ENCODING_NAME;
                break;
            }
            default: {
                UtilDebug.assert("Invalid character encoding", false);
            }
        }
        return string;
    }

    public long getMaxChunkSize() {
        return 0L;
    }

    public abstract int readData(byte[] var1, int var2, long var3, int var5) throws SQLException;

    public abstract int writeData(long var1, byte[] var3, int var4, int var5) throws SQLException;

    public abstract void truncate(long var1) throws SQLException;

    public abstract long getLength() throws SQLException;

    public abstract int getCharacterEncoding();

    public abstract void close() throws SQLException;
}

