/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseBlobInputStream;
import com.metamatrix.jdbc.slbase.BaseBlobOutputStream;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplBlob;
import com.metamatrix.jdbc.slbase.BaseImplBlobChunked;
import com.metamatrix.jdbc.slbase.BaseImplBlobSearchable;
import com.metamatrix.jdbc.slbase.BaseImplBlobService;
import com.metamatrix.jdbc.slbase.BaseInputStreamWrapper;
import com.metamatrix.slutil.UtilDebug;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BaseBlob
implements Blob {
    private BaseImplBlob implBlob;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    private boolean deferSearchEmulation;
    BaseConnection connection;
    Object synchronizer;
    BaseExceptions exceptions;

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, BaseExceptions baseExceptions) throws SQLException {
        this(baseImplBlob, baseConnection, true, baseExceptions);
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
    }

    public BaseBlob(BaseImplBlob baseImplBlob, BaseConnection baseConnection, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supply a native Blob implementation", baseImplBlob != null);
        UtilDebug.assert("Must supply a BaseExceptions object", baseExceptions != null);
        this.implBlob = baseImplBlob;
        this.deferSearchEmulation = bl;
        this.exceptions = baseExceptions;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.connection = baseConnection;
        this.synchronizer = baseConnection != null ? baseConnection : this;
        this.chainInBlobServices();
    }

    public BaseImplBlob getNativeImplBlob() {
        BaseImplBlob baseImplBlob = this.implBlob;
        while (baseImplBlob instanceof BaseImplBlobService) {
            baseImplBlob = ((BaseImplBlobService)baseImplBlob).getChainedImplBlob();
        }
        return baseImplBlob;
    }

    void setConnection(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.synchronizer = baseConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implBlob.getLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (l2 <= 0L || n2 < 0) {
            String[] stringArray = new String[]{"Blob.getBytes"};
            throw this.exceptions.getException(6069, stringArray);
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            long l3 = this.length();
            if (l2 - 1L > l3) {
                throw this.exceptions.getException(6077);
            }
            if (l2 - 1L + (long)n2 > l3) {
                try {
                    n2 = new Long(l3 - (l2 - 1L)).intValue();
                }
                catch (Exception exception) {
                    this.exceptions.getException(6065);
                }
            }
            byte[] byArray = new byte[n2];
            this.implBlob.readData(byArray, 0, l2, n2);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream() throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseBlobInputStream baseBlobInputStream = new BaseBlobInputStream(this, this.implBlob, this.exceptions);
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = (int)this.getNativeImplBlob().getMaxChunkSize() > 100 ? new BufferedInputStream(baseBlobInputStream, (int)this.getNativeImplBlob().getMaxChunkSize()) : new BufferedInputStream(baseBlobInputStream);
            long l2 = this.implBlob.getLength();
            baseInputStreamWrapper = new BaseInputStreamWrapper(bufferedInputStream, l2, this.connection, this.exceptions);
            this.setLastInputStream(baseInputStreamWrapper);
            return this.lastInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getBinaryStream(boolean bl) throws SQLException {
        BaseInputStreamWrapper baseInputStreamWrapper = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseBlobInputStream baseBlobInputStream = new BaseBlobInputStream(this, this.implBlob, this.exceptions);
            baseBlobInputStream.closeImplBlobOnClose = bl;
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = (int)this.getNativeImplBlob().getMaxChunkSize() > 100 ? new BufferedInputStream(baseBlobInputStream, (int)this.getNativeImplBlob().getMaxChunkSize()) : new BufferedInputStream(baseBlobInputStream);
            long l2 = this.implBlob.getLength();
            baseInputStreamWrapper = new BaseInputStreamWrapper(bufferedInputStream, l2, this.connection, this.exceptions);
            this.setLastInputStream(baseInputStreamWrapper);
            return this.lastInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l2) throws SQLException {
        if (byArray == null || l2 <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l2 >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.implBlob.find(byArray, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Blob blob, long l2) throws SQLException {
        if (blob == null || l2 <= 0L) {
            String[] stringArray = new String[]{"Blob.position"};
            throw this.exceptions.getException(6069, stringArray);
        }
        if (l2 >= this.length()) {
            throw this.exceptions.getException(6077);
        }
        if (this.deferSearchEmulation) {
            this.deferSearchEmulation = false;
            this.chainInBlobServices();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            int n2;
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            try {
                n2 = new Long(blob.length()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6064);
            }
            return this.implBlob.find(blob.getBytes(1L, n2), l2);
        }
    }

    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (n3 == 0) {
                return 0;
            }
            if (l2 <= 0L || n2 < 0 || n2 + n3 > byArray.length) {
                String[] stringArray = new String[]{"setBytes"};
                throw this.exceptions.getException(6069, stringArray);
            }
            return this.implBlob.writeData(l2, byArray, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setBinaryStream(long l2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l2 <= 0L) {
                String[] stringArray = new String[]{"setBinaryStream"};
                throw this.exceptions.getException(6069, stringArray);
            }
            BaseBlobOutputStream baseBlobOutputStream = new BaseBlobOutputStream(this, this.implBlob, l2, this.synchronizer, this.exceptions);
            this.setLastOutputStream(baseBlobOutputStream);
            return baseBlobOutputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.implBlob == null || this.connection != null && this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (l2 < 0L || l2 > this.length()) {
                String[] stringArray = new String[]{"truncate"};
                throw this.exceptions.getException(6069, stringArray);
            }
            this.implBlob.truncate(l2);
        }
    }

    private void close() throws SQLException {
        this.setLastInputStream(null);
        this.setLastOutputStream(null);
        this.implBlob.close();
    }

    private void chainInBlobServices() throws SQLException {
        int n2 = new Long(this.implBlob.getMaxChunkSize()).intValue();
        if (n2 > 0) {
            this.implBlob = new BaseImplBlobChunked(n2, this.implBlob, this.exceptions);
        }
        if (!this.deferSearchEmulation && !this.implBlob.supportsSearch()) {
            this.implBlob = new BaseImplBlobSearchable(this.implBlob, this.exceptions);
        }
    }

    private void setLastInputStream(InputStream inputStream) {
        if (this.lastInputStream != null) {
            try {
                this.lastInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastInputStream = inputStream;
    }

    private void setLastOutputStream(OutputStream outputStream) {
        if (this.lastOutputStream != null) {
            try {
                this.lastOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.lastOutputStream = outputStream;
    }
}

