/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.qualified;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.PolicyInformation;
import iaik.utils.InternalErrorException;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.qualified.BiometricInfo;
import iaik.x509.extensions.qualified.QCStatements;
import iaik.x509.extensions.qualified.structures.QCStatement;
import iaik.x509.qualified.QualifiedCertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public class QualifiedCertificate
extends X509Certificate {
    private PolicyInformation[] c;
    private QCStatement[] b;
    static Vector a;
    static Vector d;

    public void setQCStatements(QCStatements qCStatements) throws X509ExtensionException {
        this.addExtension(qCStatements);
        this.b = QualifiedCertificate.containsQualifiedQCStatements(qCStatements);
    }

    public void setCertificatePolicies(CertificatePolicies certificatePolicies) throws X509ExtensionException {
        this.addExtension(certificatePolicies);
        this.c = QualifiedCertificate.containsQualifiedPolicyInformations(certificatePolicies);
    }

    public void setBiometricInfo(BiometricInfo biometricInfo) throws X509ExtensionException {
        this.addExtension(biometricInfo);
    }

    public static boolean removeRegisteredQualifiedQCStatementID(ObjectID objectID) {
        return a.removeElement(objectID);
    }

    public static boolean removeRegisteredQualifiedPolicyID(ObjectID objectID) {
        return d.removeElement(objectID);
    }

    public boolean removeExtension(ObjectID objectID) {
        boolean bl = super.removeExtension(objectID);
        if (bl) {
            if (objectID.equals(CertificatePolicies.oid)) {
                this.c = null;
            } else if (objectID.equals(QCStatements.oid)) {
                this.b = null;
            }
        }
        return bl;
    }

    public void removeAllExtensions() {
        super.removeAllExtensions();
        this.c = null;
        this.b = null;
    }

    public static void registerQualifiedQCStatementIDs(ObjectID[] objectIDArray) {
        a.removeAllElements();
        int n2 = 0;
        while (n2 < objectIDArray.length) {
            a.addElement(objectIDArray[n2]);
            ++n2;
        }
    }

    public static boolean registerQualifiedQCStatementID(ObjectID objectID) {
        Enumeration enumeration = a.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return false;
        }
        a.addElement(objectID);
        return true;
    }

    public static void registerQualifiedPolicyIDs(ObjectID[] objectIDArray) {
        d.removeAllElements();
        int n2 = 0;
        while (n2 < objectIDArray.length) {
            d.addElement(objectIDArray[n2]);
            ++n2;
        }
    }

    public static boolean registerQualifiedPolicyID(ObjectID objectID) {
        Enumeration enumeration = d.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return false;
        }
        d.addElement(objectID);
        return true;
    }

    public static boolean isQualifiedQCStatementID(ObjectID objectID) {
        Enumeration enumeration = a.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    public static boolean isQualifiedPolicyID(ObjectID objectID) {
        Enumeration enumeration = d.elements();
        while (enumeration.hasMoreElements()) {
            if (!objectID.equals(enumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private boolean c() {
        V3Extension v3Extension;
        try {
            v3Extension = this.getQCStatements();
            if (v3Extension != null) {
                this.b = QualifiedCertificate.containsQualifiedQCStatements(v3Extension);
            }
        }
        catch (Exception exception) {}
        try {
            v3Extension = (CertificatePolicies)this.getExtension(CertificatePolicies.oid);
            if (v3Extension != null) {
                this.c = QualifiedCertificate.containsQualifiedPolicyInformations((CertificatePolicies)v3Extension);
            }
        }
        catch (Exception exception) {}
        return this.c != null || this.b != null;
    }

    public static QualifiedCertificate isQualifedCertificate(X509Certificate x509Certificate) throws QualifiedCertificateException {
        try {
            return new QualifiedCertificate(x509Certificate.getEncoded());
        }
        catch (CertificateException certificateException) {
            throw new InternalErrorException("Error in reading certificate: " + certificateException.getMessage(), certificateException);
        }
    }

    public static ObjectID[] getRegisteredQualifiedQCStatementIDs() {
        Object[] objectArray = new ObjectID[a.size()];
        a.copyInto(objectArray);
        return objectArray;
    }

    public static ObjectID[] getRegisteredQualifiedPolicyIDs() {
        Object[] objectArray = new ObjectID[d.size()];
        d.copyInto(objectArray);
        return objectArray;
    }

    public QCStatement[] getQualifiedQCStatements() {
        return this.b;
    }

    public PolicyInformation[] getQualifiedPolicyInformations() {
        return this.c;
    }

    public QCStatements getQCStatements() throws X509ExtensionInitException {
        return (QCStatements)this.getExtension(QCStatements.oid);
    }

    public CertificatePolicies getCertificatePolicies() throws X509ExtensionInitException {
        return (CertificatePolicies)this.getExtension(CertificatePolicies.oid);
    }

    public BiometricInfo getBiometricInfo() throws X509ExtensionInitException {
        return (BiometricInfo)this.getExtension(BiometricInfo.oid);
    }

    public static QCStatement[] containsQualifiedQCStatements(QCStatements qCStatements) {
        Object[] objectArray = null;
        Vector<QCStatement> vector = new Vector<QCStatement>();
        QCStatement[] qCStatementArray = qCStatements.getQCStatements();
        int n2 = 0;
        while (n2 < qCStatementArray.length) {
            QCStatement qCStatement = qCStatementArray[n2];
            if (QualifiedCertificate.isQualifiedQCStatementID(qCStatement.getStatementID())) {
                vector.addElement(qCStatement);
            }
            ++n2;
        }
        int n3 = vector.size();
        if (n3 > 0) {
            objectArray = new QCStatement[n3];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static PolicyInformation[] containsQualifiedPolicyInformations(CertificatePolicies certificatePolicies) {
        Object[] objectArray = null;
        Vector<PolicyInformation> vector = new Vector<PolicyInformation>();
        PolicyInformation[] policyInformationArray = certificatePolicies.getPolicyInformation();
        int n2 = 0;
        while (n2 < policyInformationArray.length) {
            PolicyInformation policyInformation = policyInformationArray[n2];
            if (QualifiedCertificate.isQualifiedPolicyID(policyInformation.getPolicyIdentifier())) {
                vector.addElement(policyInformation);
            }
            ++n2;
        }
        int n3 = vector.size();
        if (n3 > 0) {
            objectArray = new PolicyInformation[n3];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public static void clearRegisteredQualifiedQCStatementIDs() {
        a.removeAllElements();
    }

    public static void clearRegisteredQualifiedPolicyIDs() {
        d.removeAllElements();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        super.addExtension(v3Extension);
        if (v3Extension.getObjectID().equals(CertificatePolicies.oid)) {
            this.c = QualifiedCertificate.containsQualifiedPolicyInformations((CertificatePolicies)v3Extension);
            return;
        }
        if (v3Extension.getObjectID().equals(QCStatements.oid)) {
            this.b = QualifiedCertificate.containsQualifiedQCStatements((QCStatements)v3Extension);
        }
    }

    public QualifiedCertificate(byte[] byArray) throws QualifiedCertificateException, CertificateException {
        super(byArray);
        if (!this.c()) {
            throw new QualifiedCertificateException("Initialization failed! No qualified cert!");
        }
    }

    public QualifiedCertificate(InputStream inputStream) throws QualifiedCertificateException, CertificateException, IOException {
        super(inputStream);
        if (!this.c()) {
            throw new QualifiedCertificateException("Initialization failed! No qualified cert!");
        }
    }

    public QualifiedCertificate() {
    }

    static {
        d = new Vector();
        a = new Vector();
    }
}

