/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.net.NetInputStream;
import com.metamatrix.sequelink.net.NetOutputStream;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.net.Session;
import com.metamatrix.sequelink.ssp.AsciiAttribute;
import com.metamatrix.sequelink.ssp.Attribute;
import com.metamatrix.sequelink.ssp.BinaryAttribute;
import com.metamatrix.sequelink.ssp.IntAttribute;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.Ssp;
import com.metamatrix.sequelink.ssp.Ssp7;
import com.metamatrix.sequelink.ssp.Ssp8;
import com.metamatrix.sequelink.ssp.Ssp9;
import com.metamatrix.sequelink.ssp.SspAttributes;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.sequelink.ssp.SspStreamFactory;
import com.metamatrix.slutil.UtilException;
import com.metamatrix.slutil.UtilTransliterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;

public class SspFactory {
    static final int REQUESTED_MINSSP = 1;
    static final int REQUESTED_MAXSSP = 2;
    static final int SELECTED_SSP = 3;
    static final int INFO_CLIENTTYPE = 4;
    static final int INFO_CLIENTVERSION = 5;
    static final int INFO_SERVERTYPE = 6;
    static final int INFO_SERVERVERSION = 7;
    static final int REQUESTED_TYPES = 8;
    static final int SELECTED_TYPES = 9;
    static final int INFO_CHARSET = 10;
    static final int INFO_ENCRYPTION = 11;
    static final int INFO_ENC_INITVECT = 12;
    private static final int kSSP_SUPPORTS_NONE = 0;
    private static final int kSSP_SUPPORTS_INT8 = 1;
    private static final int kSSP_SUPPORTS_INT16 = 2;
    private static final int kSSP_SUPPORTS_INT32 = 4;
    private static final int kSSP_SUPPORTS_CHAR = 8;
    private static final int kSSP_SUPPORTS_BINARY = 16;
    private static final int kSSP_SUPPORTS_REAL = 32;
    private static final int kSSP_SUPPORTS_FLOAT = 64;
    private static final int kSSP_SUPPORTS_TIME = 128;
    private static final int kSSP_SUPPORTS_DATE = 256;
    private static final int kSSP_SUPPORTS_TIMESTAMP = 512;
    private static final int kSSP_SUPPORTS_BCD = 1024;
    static final int kSSP_SUPPORTED_TYPES = 2047;
    private static final int CLIENTTYPE_JDBC = 2;
    private static final int SERVERTYPE_DATAACCESS = 1;
    private static final int SERVERTYPE_ADMIN = 2;
    private static final int ATTR_ENCRYPTION_NONE = 0;
    private static final int ATTR_ENCRYPTION_DES = 1;
    private static final int ATTR_ENCRYPTION_3DES = 2;
    private static final int ATTR_ENCRYPTION_BYTESWAP = 3;
    private static final int SUPPORTED_MINSSP = 7;
    private static final int SUPPORTED_MAXSSP = 9;

    public static final Ssp GetSsp(SspAttributes sspAttributes) throws SQLException {
        Session session = null;
        NetInputStream netInputStream = null;
        try {
            session = new Session();
            session.setNetAttributes(sspAttributes);
            NetOutputStream netOutputStream = session.getNetOutputStream();
            UtilTransliterator utilTransliterator = UtilTransliterator.GetNewTransliterator("ASCII");
            SspOutputStream sspOutputStream = SspStreamFactory.GetOutputStream();
            sspOutputStream.setTransliterator(utilTransliterator);
            sspOutputStream.setOutputStream(netOutputStream);
            SspFactory.CreateRequest(sspOutputStream);
            netInputStream = session.attach(netOutputStream);
            SspInputStream sspInputStream = SspStreamFactory.GetInputStream();
            sspInputStream.setTransliterator(utilTransliterator);
            sspInputStream.setInputStream(netInputStream);
            Ssp ssp = SspFactory.ProcessReply(sspInputStream, session, utilTransliterator);
            return ssp;
        }
        catch (NetworkException networkException) {
            throw Message.NetworkToSqlException(networkException);
        }
        catch (UtilException utilException) {
            SQLException sQLException = Message.Gen.getSqlException(7452);
            Message.Gen.addMessageToSQLException(sQLException, utilException.getMessage());
            throw sQLException;
        }
        finally {
            if (netInputStream != null) {
                netInputStream.close();
            }
        }
    }

    private static final void CreateRequest(SspOutputStream sspOutputStream) throws SQLException {
        try {
            sspOutputStream.writeSequeLink();
            sspOutputStream.writeSSPFullInt32(5);
            IntAttribute intAttribute = new IntAttribute(1, 7);
            ((Attribute)intAttribute).encode(sspOutputStream);
            intAttribute = new IntAttribute(2, 9);
            ((Attribute)intAttribute).encode(sspOutputStream);
            intAttribute = new IntAttribute(4, 2);
            ((Attribute)intAttribute).encode(sspOutputStream);
            intAttribute = new IntAttribute(5, 2);
            ((Attribute)intAttribute).encode(sspOutputStream);
            intAttribute = new IntAttribute(8, 2047);
            ((Attribute)intAttribute).encode(sspOutputStream);
        }
        catch (IOException iOException) {
            throw Message.Gen.getSqlException(7398);
        }
    }

    private static final Ssp ProcessReply(SspInputStream sspInputStream, Session session, UtilTransliterator utilTransliterator) throws SQLException {
        int n = 0;
        int n2 = 0;
        String string = "ASCII";
        try {
            IntAttribute intAttribute;
            Attribute attribute;
            sspInputStream.readSequeLink();
            Hashtable<Integer, Attribute> hashtable = new Hashtable<Integer, Attribute>();
            int n3 = sspInputStream.readSSPFullInt32();
            for (int i = 0; i < n3; ++i) {
                attribute = Attribute.ReadAttribute(sspInputStream);
                if (attribute == null) continue;
                hashtable.put(new Integer(attribute.id), attribute);
            }
            Integer n4 = new Integer(6);
            attribute = (IntAttribute)hashtable.get(n4);
            if (((IntAttribute)attribute).data != 1) {
                throw Message.Gen.getSqlException(7429);
            }
            n4 = new Integer(7);
            attribute = (IntAttribute)hashtable.get(n4);
            if (((IntAttribute)attribute).data < 0x5000000) {
                throw Message.Gen.getSqlException(7429);
            }
            n = ((IntAttribute)attribute).data;
            n4 = new Integer(3);
            attribute = (IntAttribute)hashtable.get(n4);
            if (((IntAttribute)attribute).data < 7 || ((IntAttribute)attribute).data > 9) {
                throw Message.Gen.getSqlException(7429);
            }
            n2 = ((IntAttribute)attribute).data;
            n4 = new Integer(9);
            attribute = (IntAttribute)hashtable.get(n4);
            if ((((IntAttribute)attribute).data & 0x7FF) != 2047) {
                throw Message.Gen.getSqlException(7429);
            }
            if ((((IntAttribute)attribute).data | 0x7FF) != 2047) {
                throw Message.Gen.getSqlException(7429);
            }
            AsciiAttribute asciiAttribute = (AsciiAttribute)hashtable.get(new Integer(10));
            if (asciiAttribute != null) {
                string = asciiAttribute.data;
            }
            if ((intAttribute = (IntAttribute)hashtable.get(new Integer(11))) != null) {
                switch (intAttribute.data) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        BinaryAttribute binaryAttribute = (BinaryAttribute)hashtable.get(new Integer(12));
                        if (binaryAttribute == null) {
                            throw Message.Gen.getSqlException(7450);
                        }
                        if (binaryAttribute.data.length != 8) {
                            Object[] objectArray = new Object[]{new Integer(binaryAttribute.data.length), new Integer(8)};
                            throw Message.Gen.getSqlException(7451, objectArray);
                        }
                        session.setEncryption(0, binaryAttribute.data);
                        break;
                    }
                    case 2: {
                        BinaryAttribute binaryAttribute = (BinaryAttribute)hashtable.get(new Integer(12));
                        if (binaryAttribute == null) {
                            throw Message.Gen.getSqlException(7450);
                        }
                        if (binaryAttribute.data.length != 8) {
                            Object[] objectArray = new Object[]{new Integer(binaryAttribute.data.length), new Integer(8)};
                            throw Message.Gen.getSqlException(7451, objectArray);
                        }
                        session.setEncryption(1, binaryAttribute.data);
                        break;
                    }
                    case 3: {
                        BinaryAttribute binaryAttribute = (BinaryAttribute)hashtable.get(new Integer(12));
                        if (binaryAttribute == null) {
                            throw Message.Gen.getSqlException(7450);
                        }
                        if (binaryAttribute.data.length != 2) {
                            Object[] objectArray = new Object[]{new Integer(binaryAttribute.data.length), new Integer(2)};
                            throw Message.Gen.getSqlException(7451, objectArray);
                        }
                        session.setEncryption(2, binaryAttribute.data);
                        break;
                    }
                    default: {
                        throw Message.Gen.getSqlException(7449);
                    }
                }
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = Message.Gen.getSqlException(7428);
            throw Message.Gen.addMessageToSQLException(sQLException, iOException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw Message.Gen.getSqlException(7429);
        }
        catch (NetworkException networkException) {
            throw Message.NetworkToSqlException(networkException);
        }
        if (n2 == 7) {
            return new Ssp7(session, string, n, utilTransliterator);
        }
        if (n2 == 8) {
            return new Ssp8(session, string, n, utilTransliterator);
        }
        if (n2 == 9) {
            return new Ssp9(session, string, n, utilTransliterator);
        }
        throw new InternalError("SspFactory.ProcessReply - invalid sspVersion");
    }
}

