/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.ssp.CodecChainedPacket;
import com.metamatrix.sequelink.ssp.SspContext;
import com.metamatrix.sequelink.util.UnSyncVector;
import com.metamatrix.sequelink.variables.Variable;
import com.metamatrix.slutil.UtilException;
import java.io.IOException;

public class CodecParams
extends CodecChainedPacket {
    int outputAvailable;
    UnSyncVector inputParameters;
    UnSyncVector outputParameters;
    int serverVersion;

    public CodecParams(int n, SspContext sspContext, UnSyncVector unSyncVector, UnSyncVector unSyncVector2) {
        super(n, sspContext);
        this.inputParameters = unSyncVector;
        this.outputParameters = unSyncVector2;
        this.serverVersion = sspContext.getSsp().getServerVersion();
    }

    protected void writeInputParameters() throws IOException, UtilException {
        if (this.inputParameters == null) {
            return;
        }
        int n = this.inputParameters.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.inputParameters.elementAt(i);
            variable.writeObjectAndIndicatorOn(this.sos);
        }
    }

    protected void readOutputParameters() throws IOException, UtilException {
        this.outputAvailable = this.sis.readSSPFullInt32();
        if (this.outputParameters == null) {
            return;
        }
        if (this.outputAvailable == 1 || this.serverVersion < 0x5050000) {
            int n = this.outputParameters.size();
            for (int i = 0; i < n; ++i) {
                Variable variable = (Variable)this.outputParameters.elementAt(i);
                variable.readObjectAndIndicatorFrom(this.sis);
            }
        }
    }
}

