require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_TGMATH_H)) {
    eval 'sub _TGMATH_H () {1;}' unless defined(&_TGMATH_H);
    eval 'sub __GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION () {1;}' unless defined(&__GLIBC_INTERNAL_STARTING_HEADER_IMPLEMENTATION);
    require 'bits/libc-header-start.ph';
    require 'bits/floatn.ph';
    require 'math.ph';
    require 'complex.ph';
    eval 'sub __HAVE_BUILTIN_TGMATH () { &__GNUC_PREREQ (8, 0);}' unless defined(&__HAVE_BUILTIN_TGMATH);
    if( &__GNUC_PREREQ (2, 7)) {
	if((defined(&__HAVE_FLOAT128X) ? &__HAVE_FLOAT128X : undef)) {
	    die("Unsupported _Float128x type for <tgmath.h>.");
	}
	if((((defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef)  && !(defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)) || ((defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)  && !(defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef)))) {
	    die("Unsupported combination of types for <tgmath.h>.");
	}
	eval 'sub __TGMATH_2_NARROW_D {
	    my($F, $X, $Y) = @_;
    	    eval q(($F   &l ($X, $Y)));
	}' unless defined(&__TGMATH_2_NARROW_D);
	eval 'sub __TGMATH_2_NARROW_F64X {
	    my($F, $X, $Y) = @_;
    	    eval q(($F   &f128 ($X, $Y)));
	}' unless defined(&__TGMATH_2_NARROW_F64X);
	if(!(defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)) {
	    eval 'sub __TGMATH_2_NARROW_F32X {
	        my($F, $X, $Y) = @_;
    		eval q(($F   &f64 ($X, $Y)));
	    }' unless defined(&__TGMATH_2_NARROW_F32X);
	}
	if((defined(&__HAVE_BUILTIN_TGMATH) ? &__HAVE_BUILTIN_TGMATH : undef)) {
	    if((defined(&__HAVE_FLOAT16) ? &__HAVE_FLOAT16 : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F16_ARG {
		    my($X) = @_;
    		    eval q($X   &f16,);
		}' unless defined(&__TG_F16_ARG);
	    } else {
		eval 'sub __TG_F16_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F16_ARG);
	    }
	    if((defined(&__HAVE_FLOAT32) ? &__HAVE_FLOAT32 : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F32_ARG {
		    my($X) = @_;
    		    eval q($X   &f32,);
		}' unless defined(&__TG_F32_ARG);
	    } else {
		eval 'sub __TG_F32_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F32_ARG);
	    }
	    if((defined(&__HAVE_FLOAT64) ? &__HAVE_FLOAT64 : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F64_ARG {
		    my($X) = @_;
    		    eval q($X   &f64,);
		}' unless defined(&__TG_F64_ARG);
	    } else {
		eval 'sub __TG_F64_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F64_ARG);
	    }
	    if((defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F128_ARG {
		    my($X) = @_;
    		    eval q($X   &f128,);
		}' unless defined(&__TG_F128_ARG);
	    } else {
		eval 'sub __TG_F128_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F128_ARG);
	    }
	    if((defined(&__HAVE_FLOAT32X) ? &__HAVE_FLOAT32X : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F32X_ARG {
		    my($X) = @_;
    		    eval q($X   &f32x,);
		}' unless defined(&__TG_F32X_ARG);
	    } else {
		eval 'sub __TG_F32X_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F32X_ARG);
	    }
	    if((defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F64X_ARG {
		    my($X) = @_;
    		    eval q($X   &f64x,);
		}' unless defined(&__TG_F64X_ARG);
	    } else {
		eval 'sub __TG_F64X_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F64X_ARG);
	    }
	    if((defined(&__HAVE_FLOAT128X) ? &__HAVE_FLOAT128X : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		eval 'sub __TG_F128X_ARG {
		    my($X) = @_;
    		    eval q($X   &f128x,);
		}' unless defined(&__TG_F128X_ARG);
	    } else {
		eval 'sub __TG_F128X_ARG {
		    my($X) = @_;
    		    eval q();
		}' unless defined(&__TG_F128X_ARG);
	    }
	    eval 'sub __TGMATH_FUNCS {
	        my($X) = @_;
    		eval q($X   &f, $X, $X   &l,  &__TG_F16_ARG ($X)  &__TG_F32_ARG ($X)  &__TG_F64_ARG ($X)  &__TG_F128_ARG ($X)  &__TG_F32X_ARG ($X)  &__TG_F64X_ARG ($X)  &__TG_F128X_ARG ($X));
	    }' unless defined(&__TGMATH_FUNCS);
	    eval 'sub __TGMATH_RCFUNCS {
	        my($F, $C) = @_;
    		eval q( &__TGMATH_FUNCS ($F)  &__TGMATH_FUNCS ($C));
	    }' unless defined(&__TGMATH_RCFUNCS);
	    eval 'sub __TGMATH_1 {
	        my($F, $X) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_FUNCS ($F) ($X)));
	    }' unless defined(&__TGMATH_1);
	    eval 'sub __TGMATH_2 {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_FUNCS ($F) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2);
	    eval 'sub __TGMATH_2STD {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ($F   &f, $F, $F   &l, ($X), ($Y)));
	    }' unless defined(&__TGMATH_2STD);
	    eval 'sub __TGMATH_3 {
	        my($F, $X, $Y, $Z) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_FUNCS ($F) ($X), ($Y), ($Z)));
	    }' unless defined(&__TGMATH_3);
	    eval 'sub __TGMATH_1C {
	        my($F, $C, $X) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_RCFUNCS ($F, $C) ($X)));
	    }' unless defined(&__TGMATH_1C);
	    eval 'sub __TGMATH_2C {
	        my($F, $C, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_RCFUNCS ($F, $C) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2C);
	    eval 'sub __TGMATH_NARROW_FUNCS_F {
	        my($X) = @_;
    		eval q($X, $X   &l,);
	    }' unless defined(&__TGMATH_NARROW_FUNCS_F);
	    eval 'sub __TGMATH_NARROW_FUNCS_F16 {
	        my($X) = @_;
    		eval q( &__TG_F32_ARG ($X)  &__TG_F64_ARG ($X)  &__TG_F128_ARG ($X)  &__TG_F32X_ARG ($X)  &__TG_F64X_ARG ($X)  &__TG_F128X_ARG ($X));
	    }' unless defined(&__TGMATH_NARROW_FUNCS_F16);
	    eval 'sub __TGMATH_NARROW_FUNCS_F32 {
	        my($X) = @_;
    		eval q( &__TG_F64_ARG ($X)  &__TG_F128_ARG ($X)  &__TG_F32X_ARG ($X)  &__TG_F64X_ARG ($X)  &__TG_F128X_ARG ($X));
	    }' unless defined(&__TGMATH_NARROW_FUNCS_F32);
	    eval 'sub __TGMATH_NARROW_FUNCS_F64 {
	        my($X) = @_;
    		eval q( &__TG_F128_ARG ($X)  &__TG_F64X_ARG ($X)  &__TG_F128X_ARG ($X));
	    }' unless defined(&__TGMATH_NARROW_FUNCS_F64);
	    eval 'sub __TGMATH_NARROW_FUNCS_F32X {
	        my($X) = @_;
    		eval q( &__TG_F64X_ARG ($X)  &__TG_F128X_ARG ($X)  &__TG_F64_ARG ($X)  &__TG_F128_ARG ($X));
	    }' unless defined(&__TGMATH_NARROW_FUNCS_F32X);
	    eval 'sub __TGMATH_2_NARROW_F {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_NARROW_FUNCS_F ($F) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2_NARROW_F);
	    eval 'sub __TGMATH_2_NARROW_F16 {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_NARROW_FUNCS_F16 ($F) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2_NARROW_F16);
	    eval 'sub __TGMATH_2_NARROW_F32 {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_NARROW_FUNCS_F32 ($F) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2_NARROW_F32);
	    eval 'sub __TGMATH_2_NARROW_F64 {
	        my($F, $X, $Y) = @_;
    		eval q( &__builtin_tgmath ( &__TGMATH_NARROW_FUNCS_F64 ($F) ($X), ($Y)));
	    }' unless defined(&__TGMATH_2_NARROW_F64);
	    if((defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)) {
		eval 'sub __TGMATH_2_NARROW_F32X {
		    my($F, $X, $Y) = @_;
    		    eval q( &__builtin_tgmath ( &__TGMATH_NARROW_FUNCS_F32X ($F) ($X), ($Y)));
		}' unless defined(&__TGMATH_2_NARROW_F32X);
	    }
	} else {
	    if(defined(&__NO_LONG_DOUBLE_MATH)) {
		eval 'sub __tgml {
		    my($fct) = @_;
    		    eval q($fct);
		}' unless defined(&__tgml);
	    } else {
		eval 'sub __tgml {
		    my($fct) = @_;
    		    eval q($fct   &l);
		}' unless defined(&__tgml);
	    }
	    if( &__GNUC_PREREQ (3, 1)) {
		eval 'sub __floating_type {
		    my($type) = @_;
    		    eval q(( &__builtin_classify_type ( &__real__ (($type) 0)) == 8));
		}' unless defined(&__floating_type);
		eval 'sub __real_integer_type {
		    my($type) = @_;
    		    eval q(( &__builtin_classify_type (($type) 0) == 1));
		}' unless defined(&__real_integer_type);
		eval 'sub __complex_integer_type {
		    my($type) = @_;
    		    eval q(( &__builtin_classify_type (($type) 0) == 9 &&  &__builtin_classify_type ( &__real__ (($type) 0)) == 1));
		}' unless defined(&__complex_integer_type);
	    } else {
		eval 'sub __floating_type {
		    my($type) = @_;
    		    eval q(((($type) 1.25) != 1));
		}' unless defined(&__floating_type);
		eval 'sub __real_integer_type {
		    my($type) = @_;
    		    eval q(((($type) (1.25+  &_Complex_I)) == 1));
		}' unless defined(&__real_integer_type);
		eval 'sub __complex_integer_type {
		    my($type) = @_;
    		    eval q(((($type) (1.25+  &_Complex_I)) == (1+  &_Complex_I)));
		}' unless defined(&__complex_integer_type);
	    }
	    eval 'sub __expr_is_real {
	        my($E) = @_;
    		eval q(( &__builtin_classify_type ($E) != 9));
	    }' unless defined(&__expr_is_real);
	    eval 'sub __tgmath_real_type_sub {
	        my($T, $E) = @_;
    		eval q( &__typeof__ (*(0? ( &__typeof__ (0? 0: ( &void *) ($E))) 0: ( &__typeof__ (0? ($T *) 0: ( &void *) (!($E)))) 0)));
	    }' unless defined(&__tgmath_real_type_sub);
	    eval 'sub __tgmath_real_type {
	        my($expr) = @_;
    		eval q( &__tgmath_real_type_sub ( &__typeof__ (( &__typeof__ (+($expr))) 0),  &__floating_type ( &__typeof__ (+($expr)))));
	    }' unless defined(&__tgmath_real_type);
	    eval 'sub __tgmath_complex_type_sub {
	        my($T, $E1, $E2, $E3) = @_;
    		eval q( &__typeof__ (*(0? ( &__typeof__ (0? ($T *) 0: ( &void *) (!))) 0: ( &__typeof__ (0? ( &__typeof__ (0? 0: ( &void *) (!($E2)))) 0: ( &__typeof__ (0? ( &_Complex \'double\' *) 0: ( &void *) (!($E3)))) 0)) 0)));
	    }' unless defined(&__tgmath_complex_type_sub);
	    eval 'sub __tgmath_complex_type {
	        my($expr) = @_;
    		eval q( &__tgmath_complex_type_sub ( &__typeof__ (( &__typeof__ (+($expr))) 0),  &__floating_type ( &__typeof__ (+($expr))),  &__real_integer_type ( &__typeof__ (+($expr))),  &__complex_integer_type ( &__typeof__ (+($expr)))));
	    }' unless defined(&__tgmath_complex_type);
	    if(((defined(&__HAVE_DISTINCT_FLOAT16) ? &__HAVE_DISTINCT_FLOAT16 : undef) || (defined(&__HAVE_DISTINCT_FLOAT32) ? &__HAVE_DISTINCT_FLOAT32 : undef) || (defined(&__HAVE_DISTINCT_FLOAT64) ? &__HAVE_DISTINCT_FLOAT64 : undef) || (defined(&__HAVE_DISTINCT_FLOAT32X) ? &__HAVE_DISTINCT_FLOAT32X : undef) || (defined(&__HAVE_DISTINCT_FLOAT64X) ? &__HAVE_DISTINCT_FLOAT64X : undef) || (defined(&__HAVE_DISTINCT_FLOAT128X) ? &__HAVE_DISTINCT_FLOAT128X : undef))) {
		die("Unsupported _FloatN or _FloatNx types for <tgmath.h>.");
	    }
	    if((defined(&__HAVE_DISTINCT_FLOAT128) ? &__HAVE_DISTINCT_FLOAT128 : undef)  &&  &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
		if((!(defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef) || (defined(&__HAVE_FLOAT64X_LONG_DOUBLE) ? &__HAVE_FLOAT64X_LONG_DOUBLE : undef) || !(defined(&__HAVE_FLOATN_NOT_TYPEDEF) ? &__HAVE_FLOATN_NOT_TYPEDEF : undef))) {
		    eval 'sub __TGMATH_F128 {
		        my($arg_comb, $fct, $arg_call) = @_;
    			eval q( &__builtin_types_compatible_p ( &__typeof (+($arg_comb)),  &_Float128) ? $fct   &f128 $arg_call :);
		    }' unless defined(&__TGMATH_F128);
		    eval 'sub __TGMATH_CF128 {
		        my($arg_comb, $fct, $cfct, $arg_call) = @_;
    			eval q( &__builtin_types_compatible_p ( &__typeof (+ &__real__ ($arg_comb)),  &_Float128) ? ( &__expr_is_real ($arg_comb) ? $fct   &f128 $arg_call : $cfct   &f128 $arg_call) :);
		    }' unless defined(&__TGMATH_CF128);
		} else {
		    eval 'sub __TGMATH_F128 {
		        my($arg_comb, $fct, $arg_call) = @_;
    			eval q(( &__builtin_types_compatible_p ( &__typeof (+($arg_comb)),  &_Float128) ||  &__builtin_types_compatible_p ( &__typeof (+($arg_comb)),  &_Float64x)) ? $fct   &f128 $arg_call :);
		    }' unless defined(&__TGMATH_F128);
		    eval 'sub __TGMATH_CF128 {
		        my($arg_comb, $fct, $cfct, $arg_call) = @_;
    			eval q(( &__builtin_types_compatible_p ( &__typeof (+ &__real__ ($arg_comb)),  &_Float128) ||  &__builtin_types_compatible_p ( &__typeof (+ &__real__ ($arg_comb)),  &_Float64x)) ? ( &__expr_is_real ($arg_comb) ? $fct   &f128 $arg_call : $cfct   &f128 $arg_call) :);
		    }' unless defined(&__TGMATH_CF128);
		}
	    } else {
		eval 'sub __TGMATH_F128 {
		    my($arg_comb, $fct, $arg_call) = @_;
    		    eval q();
		}' unless defined(&__TGMATH_F128);
		eval 'sub __TGMATH_CF128 {
		    my($arg_comb, $fct, $cfct, $arg_call) = @_;
    		    eval q();
		}' unless defined(&__TGMATH_CF128);
	    }
	}
	if((defined(&__HAVE_BUILTIN_TGMATH) ? &__HAVE_BUILTIN_TGMATH : undef)) {
	    eval 'sub __TGMATH_UNARY_REAL_ONLY {
	        my($Val, $Fct) = @_;
    		eval q( &__TGMATH_1 ($Fct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_REAL_ONLY);
	    eval 'sub __TGMATH_UNARY_REAL_RET_ONLY {
	        my($Val, $Fct) = @_;
    		eval q( &__TGMATH_1 ($Fct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_REAL_RET_ONLY);
	    eval 'sub __TGMATH_BINARY_FIRST_REAL_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q( &__TGMATH_2 ($Fct, ($Val1), ($Val2)));
	    }' unless defined(&__TGMATH_BINARY_FIRST_REAL_ONLY);
	    eval 'sub __TGMATH_BINARY_FIRST_REAL_STD_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q( &__TGMATH_2STD ($Fct, ($Val1), ($Val2)));
	    }' unless defined(&__TGMATH_BINARY_FIRST_REAL_STD_ONLY);
	    eval 'sub __TGMATH_BINARY_REAL_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q( &__TGMATH_2 ($Fct, ($Val1), ($Val2)));
	    }' unless defined(&__TGMATH_BINARY_REAL_ONLY);
	    eval 'sub __TGMATH_BINARY_REAL_STD_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q( &__TGMATH_2STD ($Fct, ($Val1), ($Val2)));
	    }' unless defined(&__TGMATH_BINARY_REAL_STD_ONLY);
	    eval 'sub __TGMATH_TERNARY_FIRST_SECOND_REAL_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q( &__TGMATH_3 ($Fct, ($Val1), ($Val2), ($Val3)));
	    }' unless defined(&__TGMATH_TERNARY_FIRST_SECOND_REAL_ONLY);
	    eval 'sub __TGMATH_TERNARY_REAL_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q( &__TGMATH_3 ($Fct, ($Val1), ($Val2), ($Val3)));
	    }' unless defined(&__TGMATH_TERNARY_REAL_ONLY);
	    eval 'sub __TGMATH_TERNARY_FIRST_REAL_RET_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q( &__TGMATH_3 ($Fct, ($Val1), ($Val2), ($Val3)));
	    }' unless defined(&__TGMATH_TERNARY_FIRST_REAL_RET_ONLY);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG {
	        my($Val, $Fct, $Cfct) = @_;
    		eval q( &__TGMATH_1C ($Fct, $Cfct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG);
	    eval 'sub __TGMATH_UNARY_IMAG {
	        my($Val, $Cfct) = @_;
    		eval q( &__TGMATH_1 ($Cfct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_IMAG);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG_RET_REAL {
	        my($Val, $Fct, $Cfct) = @_;
    		eval q( &__TGMATH_1C ($Fct, $Cfct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG_RET_REAL);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME {
	        my($Val, $Cfct) = @_;
    		eval q( &__TGMATH_1 ($Cfct, ($Val)));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME);
	    eval 'sub __TGMATH_BINARY_REAL_IMAG {
	        my($Val1, $Val2, $Fct, $Cfct) = @_;
    		eval q( &__TGMATH_2C ($Fct, $Cfct, ($Val1), ($Val2)));
	    }' unless defined(&__TGMATH_BINARY_REAL_IMAG);
	} else {
	    eval 'sub __TGMATH_UNARY_REAL_ONLY {
	        my($Val, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{+($Val)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val) != 8) ? ( &__tgmath_real_type ($Val)) $Fct ($Val) : ($sizeof{+($Val)} == $sizeof{\'float\'}) ? ( &__tgmath_real_type ($Val)) $Fct &f ($Val) :  &__TGMATH_F128 (($Val), ( &__tgmath_real_type ($Val)) $Fct, ($Val)) ( &__tgmath_real_type ($Val))  &__tgml($Fct) ($Val))));
	    }' unless defined(&__TGMATH_UNARY_REAL_ONLY);
	    eval 'sub __TGMATH_UNARY_REAL_RET_ONLY {
	        my($Val, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{+($Val)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val) != 8) ? $Fct ($Val) : ($sizeof{+($Val)} == $sizeof{\'float\'}) ? $Fct &f ($Val) :  &__TGMATH_F128 (($Val), $Fct, ($Val))  &__tgml($Fct) ($Val))));
	    }' unless defined(&__TGMATH_UNARY_REAL_RET_ONLY);
	    eval 'sub __TGMATH_BINARY_FIRST_REAL_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{+($Val1)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8) ? ( &__tgmath_real_type ($Val1)) $Fct ($Val1, $Val2) : ($sizeof{+($Val1)} == $sizeof{\'float\'}) ? ( &__tgmath_real_type ($Val1)) $Fct &f ($Val1, $Val2) :  &__TGMATH_F128 (($Val1), ( &__tgmath_real_type ($Val1)) $Fct, ($Val1, $Val2)) ( &__tgmath_real_type ($Val1))  &__tgml($Fct) ($Val1, $Val2))));
	    }' unless defined(&__TGMATH_BINARY_FIRST_REAL_ONLY);
	    eval 'sub __TGMATH_BINARY_FIRST_REAL_STD_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{+($Val1)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8) ? ( &__tgmath_real_type ($Val1)) $Fct ($Val1, $Val2) : ($sizeof{+($Val1)} == $sizeof{\'float\'}) ? ( &__tgmath_real_type ($Val1)) $Fct &f ($Val1, $Val2) : ( &__tgmath_real_type ($Val1))  &__tgml($Fct) ($Val1, $Val2))));
	    }' unless defined(&__TGMATH_BINARY_FIRST_REAL_STD_ONLY);
	    eval 'sub __TGMATH_BINARY_REAL_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{($Val1) + ($Val2)} > $sizeof{\'double\'}  &&  &__builtin_classify_type (($Val1) + ($Val2)) == 8) ?  &__TGMATH_F128 (($Val1) + ($Val2), ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct, ($Val1, $Val2)) ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0))  &__tgml($Fct) ($Val1, $Val2) : ($sizeof{+($Val1)} == $sizeof{\'double\'} || $sizeof{+($Val2)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8||  &__builtin_classify_type ($Val2) != 8) ? ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct ($Val1, $Val2) : ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct &f ($Val1, $Val2))));
	    }' unless defined(&__TGMATH_BINARY_REAL_ONLY);
	    eval 'sub __TGMATH_BINARY_REAL_STD_ONLY {
	        my($Val1, $Val2, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{($Val1) + ($Val2)} > $sizeof{\'double\'}  &&  &__builtin_classify_type (($Val1) + ($Val2)) == 8) ? ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0))  &__tgml($Fct) ($Val1, $Val2) : ($sizeof{+($Val1)} == $sizeof{\'double\'} || $sizeof{+($Val2)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8||  &__builtin_classify_type ($Val2) != 8) ? ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct ($Val1, $Val2) : ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct &f ($Val1, $Val2))));
	    }' unless defined(&__TGMATH_BINARY_REAL_STD_ONLY);
	    eval 'sub __TGMATH_TERNARY_FIRST_SECOND_REAL_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{($Val1) + ($Val2)} > $sizeof{\'double\'}  &&  &__builtin_classify_type (($Val1) + ($Val2)) == 8) ?  &__TGMATH_F128 (($Val1) + ($Val2), ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct, ($Val1, $Val2, $Val3)) ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0))  &__tgml($Fct) ($Val1, $Val2, $Val3) : ($sizeof{+($Val1)} == $sizeof{\'double\'} || $sizeof{+($Val2)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8||  &__builtin_classify_type ($Val2) != 8) ? ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct ($Val1, $Val2, $Val3) : ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0)) $Fct &f ($Val1, $Val2, $Val3))));
	    }' unless defined(&__TGMATH_TERNARY_FIRST_SECOND_REAL_ONLY);
	    eval 'sub __TGMATH_TERNARY_REAL_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{($Val1) + ($Val2) + ($Val3)} > $sizeof{\'double\'}  &&  &__builtin_classify_type (($Val1) + ($Val2) + ($Val3)) == 8) ?  &__TGMATH_F128 (($Val1) + ($Val2) + ($Val3), ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0+ ( &__tgmath_real_type ($Val3)) 0)) $Fct, ($Val1, $Val2, $Val3)) ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0+ ( &__tgmath_real_type ($Val3)) 0))  &__tgml($Fct) ($Val1, $Val2, $Val3) : ($sizeof{+($Val1)} == $sizeof{\'double\'} || $sizeof{+($Val2)} == $sizeof{\'double\'} || $sizeof{+($Val3)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8||  &__builtin_classify_type ($Val2) != 8||  &__builtin_classify_type ($Val3) != 8) ? ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0+ ( &__tgmath_real_type ($Val3)) 0)) $Fct ($Val1, $Val2, $Val3) : ( &__typeof (( &__tgmath_real_type ($Val1)) 0+ ( &__tgmath_real_type ($Val2)) 0+ ( &__tgmath_real_type ($Val3)) 0)) $Fct &f ($Val1, $Val2, $Val3))));
	    }' unless defined(&__TGMATH_TERNARY_REAL_ONLY);
	    eval 'sub __TGMATH_TERNARY_FIRST_REAL_RET_ONLY {
	        my($Val1, $Val2, $Val3, $Fct) = @_;
    		eval q(( &__extension__ (($sizeof{+($Val1)} == $sizeof{\'double\'} ||  &__builtin_classify_type ($Val1) != 8) ? $Fct ($Val1, $Val2, $Val3) : ($sizeof{+($Val1)} == $sizeof{\'float\'}) ? $Fct &f ($Val1, $Val2, $Val3) :  &__TGMATH_F128 (($Val1), $Fct, ($Val1, $Val2, $Val3))  &__tgml($Fct) ($Val1, $Val2, $Val3))));
	    }' unless defined(&__TGMATH_TERNARY_FIRST_REAL_RET_ONLY);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG {
	        my($Val, $Fct, $Cfct) = @_;
    		eval q(( &__extension__ (($sizeof{+ &__real__ ($Val)} == $sizeof{\'double\'} ||  &__builtin_classify_type ( &__real__ ($Val)) != 8) ? ( &__expr_is_real ($Val) ? ( &__tgmath_complex_type ($Val)) $Fct ($Val) : ( &__tgmath_complex_type ($Val)) $Cfct ($Val)) : ($sizeof{+ &__real__ ($Val)} == $sizeof{\'float\'}) ? ( &__expr_is_real ($Val) ? ( &__tgmath_complex_type ($Val)) $Fct &f ($Val) : ( &__tgmath_complex_type ($Val)) $Cfct &f ($Val)) :  &__TGMATH_CF128 (($Val), ( &__tgmath_complex_type ($Val)) $Fct, ( &__tgmath_complex_type ($Val)) $Cfct, ($Val)) ( &__expr_is_real ($Val) ? ( &__tgmath_complex_type ($Val))  &__tgml($Fct) ($Val) : ( &__tgmath_complex_type ($Val))  &__tgml($Cfct) ($Val)))));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG);
	    eval 'sub __TGMATH_UNARY_IMAG {
	        my($Val, $Cfct) = @_;
    		eval q(( &__extension__ (($sizeof{+ &__real__ ($Val)} == $sizeof{\'double\'} ||  &__builtin_classify_type ( &__real__ ($Val)) != 8) ? ( &__typeof__ (( &__tgmath_real_type ($Val)) 0+  &_Complex_I)) $Cfct ($Val) : ($sizeof{+ &__real__ ($Val)} == $sizeof{\'float\'}) ? ( &__typeof__ (( &__tgmath_real_type ($Val)) 0+  &_Complex_I)) $Cfct &f ($Val) :  &__TGMATH_F128 ( &__real__ ($Val), ( &__typeof__ (( &__tgmath_real_type ($Val)) 0+  &_Complex_I)) $Cfct, ($Val)) ( &__typeof__ (( &__tgmath_real_type ($Val)) 0+  &_Complex_I))  &__tgml($Cfct) ($Val))));
	    }' unless defined(&__TGMATH_UNARY_IMAG);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG_RET_REAL {
	        my($Val, $Fct, $Cfct) = @_;
    		eval q(( &__extension__ (($sizeof{+ &__real__ ($Val)} == $sizeof{\'double\'} ||  &__builtin_classify_type ( &__real__ ($Val)) != 8) ? ( &__expr_is_real ($Val) ? ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Fct ($Val) : ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Cfct ($Val)) : ($sizeof{+ &__real__ ($Val)} == $sizeof{\'float\'}) ? ( &__expr_is_real ($Val) ? ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Fct &f ($Val) : ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Cfct &f ($Val)) :  &__TGMATH_CF128 (($Val), ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Fct, ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0)) $Cfct, ($Val)) ( &__expr_is_real ($Val) ? ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0))  &__tgml($Fct) ($Val) : ( &__typeof__ ( &__real__ ( &__tgmath_real_type ($Val)) 0))  &__tgml($Cfct) ($Val)))));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG_RET_REAL);
	    eval 'sub __TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME {
	        my($Val, $Cfct) = @_;
    		eval q( &__TGMATH_UNARY_REAL_IMAG_RET_REAL (($Val), $Cfct, $Cfct));
	    }' unless defined(&__TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME);
	    eval 'sub __TGMATH_BINARY_REAL_IMAG {
	        my($Val1, $Val2, $Fct, $Cfct) = @_;
    		eval q(( &__extension__ (($sizeof{ &__real__ ($Val1) +  &__real__ ($Val2)} > $sizeof{\'double\'}  &&  &__builtin_classify_type ( &__real__ ($Val1) +  &__real__ ($Val2)) == 8) ?  &__TGMATH_CF128 (($Val1) + ($Val2), ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Fct, ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Cfct, ($Val1, $Val2)) ( &__expr_is_real (($Val1) + ($Val2)) ? ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0))  &__tgml($Fct) ($Val1, $Val2) : ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0))  &__tgml($Cfct) ($Val1, $Val2)) : ($sizeof{+ &__real__ ($Val1)} == $sizeof{\'double\'} || $sizeof{+ &__real__ ($Val2)} == $sizeof{\'double\'} ||  &__builtin_classify_type ( &__real__ ($Val1)) != 8||  &__builtin_classify_type ( &__real__ ($Val2)) != 8) ? ( &__expr_is_real (($Val1) + ($Val2)) ? ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Fct ($Val1, $Val2) : ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Cfct ($Val1, $Val2)) : ( &__expr_is_real (($Val1) + ($Val2)) ? ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Fct &f ($Val1, $Val2) : ( &__typeof (( &__tgmath_complex_type ($Val1)) 0+ ( &__tgmath_complex_type ($Val2)) 0)) $Cfct &f ($Val1, $Val2)))));
	    }' unless defined(&__TGMATH_BINARY_REAL_IMAG);
	    eval 'sub __TGMATH_2_NARROW_F {
	        my($F, $X, $Y) = @_;
    		eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{\'double\'} ? $F   &l ($X, $Y) : $F ($X, $Y))));
	    }' unless defined(&__TGMATH_2_NARROW_F);
	    if((defined(&__HAVE_FLOAT64X_LONG_DOUBLE) ? &__HAVE_FLOAT64X_LONG_DOUBLE : undef)  && (defined(&__HAVE_DISTINCT_FLOAT128) ? &__HAVE_DISTINCT_FLOAT128 : undef)) {
		eval 'sub __TGMATH_2_NARROW_F32 {
		    my($F, $X, $Y) = @_;
    		    eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{ &_Float64} ?  &__TGMATH_F128 (($X) + ($Y), $F, ($X, $Y)) $F   &f64x ($X, $Y) : $F   &f64 ($X, $Y))));
		}' unless defined(&__TGMATH_2_NARROW_F32);
		eval 'sub __TGMATH_2_NARROW_F64 {
		    my($F, $X, $Y) = @_;
    		    eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{ &_Float64} ?  &__TGMATH_F128 (($X) + ($Y), $F, ($X, $Y)) $F   &f64x ($X, $Y) : $F   &f128 ($X, $Y))));
		}' unless defined(&__TGMATH_2_NARROW_F64);
		eval 'sub __TGMATH_2_NARROW_F32X {
		    my($F, $X, $Y) = @_;
    		    eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{ &_Float64} ?  &__TGMATH_F128 (($X) + ($Y), $F, ($X, $Y)) $F   &f64x ($X, $Y) : $F   &f64 ($X, $Y))));
		}' unless defined(&__TGMATH_2_NARROW_F32X);
	    }
 elsif((defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef)) {
		eval 'sub __TGMATH_2_NARROW_F32 {
		    my($F, $X, $Y) = @_;
    		    eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{ &_Float64} ? $F   &f128 ($X, $Y) : $F   &f64 ($X, $Y))));
		}' unless defined(&__TGMATH_2_NARROW_F32);
		eval 'sub __TGMATH_2_NARROW_F64 {
		    my($F, $X, $Y) = @_;
    		    eval q(($F   &f128 ($X, $Y)));
		}' unless defined(&__TGMATH_2_NARROW_F64);
		eval 'sub __TGMATH_2_NARROW_F32X {
		    my($F, $X, $Y) = @_;
    		    eval q(( &__extension__ ($sizeof{( &__tgmath_real_type ($X)) 0+ ( &__tgmath_real_type ($Y)) 0} > $sizeof{ &_Float32x} ? $F   &f64x ($X, $Y) : $F   &f64 ($X, $Y))));
		}' unless defined(&__TGMATH_2_NARROW_F32X);
	    } else {
		eval 'sub __TGMATH_2_NARROW_F32 {
		    my($F, $X, $Y) = @_;
    		    eval q(($F   &f64 ($X, $Y)));
		}' unless defined(&__TGMATH_2_NARROW_F32);
	    }
	}
    } else {
	die("Unsupported compiler; you cannot use <tgmath.h>");
    }
    eval 'sub acos {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &acos,  &cacos));
    }' unless defined(&acos);
    eval 'sub asin {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &asin,  &casin));
    }' unless defined(&asin);
    eval 'sub atan {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &atan,  &catan));
    }' unless defined(&atan);
    eval 'sub atan2 {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &atan2));
    }' unless defined(&atan2);
    eval 'sub cos {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &cos,  &ccos));
    }' unless defined(&cos);
    eval 'sub sin {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &sin,  &csin));
    }' unless defined(&sin);
    eval 'sub tan {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &tan,  &ctan));
    }' unless defined(&tan);
    eval 'sub acosh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &acosh,  &cacosh));
    }' unless defined(&acosh);
    eval 'sub asinh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &asinh,  &casinh));
    }' unless defined(&asinh);
    eval 'sub atanh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &atanh,  &catanh));
    }' unless defined(&atanh);
    eval 'sub cosh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &cosh,  &ccosh));
    }' unless defined(&cosh);
    eval 'sub sinh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &sinh,  &csinh));
    }' unless defined(&sinh);
    eval 'sub tanh {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &tanh,  &ctanh));
    }' unless defined(&tanh);
    eval 'sub exp {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &exp,  &cexp));
    }' unless defined(&exp);
    eval 'sub frexp {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_FIRST_REAL_ONLY ($Val1, $Val2,  &frexp));
    }' unless defined(&frexp);
    eval 'sub ldexp {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_FIRST_REAL_ONLY ($Val1, $Val2,  &ldexp));
    }' unless defined(&ldexp);
    eval 'sub log {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &log,  &clog));
    }' unless defined(&log);
    if(defined(&__USE_GNU)) {
	eval 'sub log10 {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &log10,  &clog10));
	}' unless defined(&log10);
    } else {
	eval 'sub log10 {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &log10));
	}' unless defined(&log10);
    }
    eval 'sub expm1 {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &expm1));
    }' unless defined(&expm1);
    eval 'sub log1p {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &log1p));
    }' unless defined(&log1p);
    eval 'sub logb {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &logb));
    }' unless defined(&logb);
    eval 'sub exp2 {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &exp2));
    }' unless defined(&exp2);
    eval 'sub log2 {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &log2));
    }' unless defined(&log2);
    eval 'sub pow {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_IMAG ($Val1, $Val2,  &pow,  &cpow));
    }' unless defined(&pow);
    eval 'sub sqrt {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG ($Val,  &sqrt,  &csqrt));
    }' unless defined(&sqrt);
    eval 'sub hypot {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &hypot));
    }' unless defined(&hypot);
    eval 'sub cbrt {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &cbrt));
    }' unless defined(&cbrt);
    eval 'sub ceil {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &ceil));
    }' unless defined(&ceil);
    eval 'sub fabs {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG_RET_REAL ($Val,  &fabs,  &cabs));
    }' unless defined(&fabs);
    eval 'sub floor {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &floor));
    }' unless defined(&floor);
    eval 'sub fmod {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fmod));
    }' unless defined(&fmod);
    eval 'sub nearbyint {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &nearbyint));
    }' unless defined(&nearbyint);
    eval 'sub round {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &round));
    }' unless defined(&round);
    eval 'sub trunc {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &trunc));
    }' unless defined(&trunc);
    eval 'sub remquo {
        my($Val1, $Val2, $Val3) = @_;
	    eval q( &__TGMATH_TERNARY_FIRST_SECOND_REAL_ONLY ($Val1, $Val2, $Val3,  &remquo));
    }' unless defined(&remquo);
    eval 'sub lrint {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &lrint));
    }' unless defined(&lrint);
    eval 'sub llrint {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &llrint));
    }' unless defined(&llrint);
    eval 'sub lround {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &lround));
    }' unless defined(&lround);
    eval 'sub llround {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &llround));
    }' unless defined(&llround);
    eval 'sub copysign {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &copysign));
    }' unless defined(&copysign);
    eval 'sub erf {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &erf));
    }' unless defined(&erf);
    eval 'sub erfc {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &erfc));
    }' unless defined(&erfc);
    eval 'sub tgamma {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &tgamma));
    }' unless defined(&tgamma);
    eval 'sub lgamma {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &lgamma));
    }' unless defined(&lgamma);
    eval 'sub rint {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &rint));
    }' unless defined(&rint);
    if( &__GLIBC_USE ((defined(&IEC_60559_BFP_EXT_C2X) ? &IEC_60559_BFP_EXT_C2X : undef))) {
	eval 'sub nextdown {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &nextdown));
	}' unless defined(&nextdown);
	eval 'sub nextup {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &nextup));
	}' unless defined(&nextup);
    }
    eval 'sub nextafter {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &nextafter));
    }' unless defined(&nextafter);
    eval 'sub nexttoward {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_FIRST_REAL_STD_ONLY ($Val1, $Val2,  &nexttoward));
    }' unless defined(&nexttoward);
    eval 'sub remainder {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &remainder));
    }' unless defined(&remainder);
    if(defined(&__USE_MISC)) {
	eval 'sub scalb {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_BINARY_REAL_STD_ONLY ($Val1, $Val2,  &scalb));
	}' unless defined(&scalb);
    }
    eval 'sub scalbn {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_FIRST_REAL_ONLY ($Val1, $Val2,  &scalbn));
    }' unless defined(&scalbn);
    eval 'sub scalbln {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_FIRST_REAL_ONLY ($Val1, $Val2,  &scalbln));
    }' unless defined(&scalbln);
    eval 'sub ilogb {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &ilogb));
    }' unless defined(&ilogb);
    eval 'sub fdim {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fdim));
    }' unless defined(&fdim);
    eval 'sub fmax {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fmax));
    }' unless defined(&fmax);
    eval 'sub fmin {
        my($Val1, $Val2) = @_;
	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fmin));
    }' unless defined(&fmin);
    eval 'sub fma {
        my($Val1, $Val2, $Val3) = @_;
	    eval q( &__TGMATH_TERNARY_REAL_ONLY ($Val1, $Val2, $Val3,  &fma));
    }' unless defined(&fma);
    if( &__GLIBC_USE ((defined(&IEC_60559_BFP_EXT_C2X) ? &IEC_60559_BFP_EXT_C2X : undef))) {
	eval 'sub roundeven {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_ONLY ($Val,  &roundeven));
	}' unless defined(&roundeven);
	eval 'sub fromfp {
	    my($Val1, $Val2, $Val3) = @_;
    	    eval q( &__TGMATH_TERNARY_FIRST_REAL_RET_ONLY ($Val1, $Val2, $Val3,  &fromfp));
	}' unless defined(&fromfp);
	eval 'sub ufromfp {
	    my($Val1, $Val2, $Val3) = @_;
    	    eval q( &__TGMATH_TERNARY_FIRST_REAL_RET_ONLY ($Val1, $Val2, $Val3,  &ufromfp));
	}' unless defined(&ufromfp);
	eval 'sub fromfpx {
	    my($Val1, $Val2, $Val3) = @_;
    	    eval q( &__TGMATH_TERNARY_FIRST_REAL_RET_ONLY ($Val1, $Val2, $Val3,  &fromfpx));
	}' unless defined(&fromfpx);
	eval 'sub ufromfpx {
	    my($Val1, $Val2, $Val3) = @_;
    	    eval q( &__TGMATH_TERNARY_FIRST_REAL_RET_ONLY ($Val1, $Val2, $Val3,  &ufromfpx));
	}' unless defined(&ufromfpx);
	eval 'sub llogb {
	    my($Val) = @_;
    	    eval q( &__TGMATH_UNARY_REAL_RET_ONLY ($Val,  &llogb));
	}' unless defined(&llogb);
	eval 'sub fmaxmag {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fmaxmag));
	}' unless defined(&fmaxmag);
	eval 'sub fminmag {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_BINARY_REAL_ONLY ($Val1, $Val2,  &fminmag));
	}' unless defined(&fminmag);
    }
    eval 'sub carg {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME ($Val,  &carg));
    }' unless defined(&carg);
    eval 'sub conj {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_IMAG ($Val,  &conj));
    }' unless defined(&conj);
    eval 'sub cproj {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_IMAG ($Val,  &cproj));
    }' unless defined(&cproj);
    eval 'sub cimag {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME ($Val,  &cimag));
    }' unless defined(&cimag);
    eval 'sub creal {
        my($Val) = @_;
	    eval q( &__TGMATH_UNARY_REAL_IMAG_RET_REAL_SAME ($Val,  &creal));
    }' unless defined(&creal);
    if( &__GLIBC_USE ((defined(&IEC_60559_BFP_EXT_C2X) ? &IEC_60559_BFP_EXT_C2X : undef))) {
	eval 'sub fadd {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_F ( &fadd, $Val1, $Val2));
	}' unless defined(&fadd);
	eval 'sub dadd {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_D ( &dadd, $Val1, $Val2));
	}' unless defined(&dadd);
	eval 'sub fdiv {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_F ( &fdiv, $Val1, $Val2));
	}' unless defined(&fdiv);
	eval 'sub ddiv {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_D ( &ddiv, $Val1, $Val2));
	}' unless defined(&ddiv);
	eval 'sub fmul {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_F ( &fmul, $Val1, $Val2));
	}' unless defined(&fmul);
	eval 'sub dmul {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_D ( &dmul, $Val1, $Val2));
	}' unless defined(&dmul);
	eval 'sub fsub {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_F ( &fsub, $Val1, $Val2));
	}' unless defined(&fsub);
	eval 'sub dsub {
	    my($Val1, $Val2) = @_;
    	    eval q( &__TGMATH_2_NARROW_D ( &dsub, $Val1, $Val2));
	}' unless defined(&dsub);
    }
    if( &__GLIBC_USE ((defined(&IEC_60559_TYPES_EXT) ? &IEC_60559_TYPES_EXT : undef))) {
	if((defined(&__HAVE_FLOAT16) ? &__HAVE_FLOAT16 : undef)) {
	    eval 'sub f16add {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F16 ( &f16add, $Val1, $Val2));
	    }' unless defined(&f16add);
	    eval 'sub f16div {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F16 ( &f16div, $Val1, $Val2));
	    }' unless defined(&f16div);
	    eval 'sub f16mul {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F16 ( &f16mul, $Val1, $Val2));
	    }' unless defined(&f16mul);
	    eval 'sub f16sub {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F16 ( &f16sub, $Val1, $Val2));
	    }' unless defined(&f16sub);
	}
	if((defined(&__HAVE_FLOAT32) ? &__HAVE_FLOAT32 : undef)) {
	    eval 'sub f32add {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32 ( &f32add, $Val1, $Val2));
	    }' unless defined(&f32add);
	    eval 'sub f32div {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32 ( &f32div, $Val1, $Val2));
	    }' unless defined(&f32div);
	    eval 'sub f32mul {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32 ( &f32mul, $Val1, $Val2));
	    }' unless defined(&f32mul);
	    eval 'sub f32sub {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32 ( &f32sub, $Val1, $Val2));
	    }' unless defined(&f32sub);
	}
	if((defined(&__HAVE_FLOAT64) ? &__HAVE_FLOAT64 : undef)  && ((defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef) || (defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef))) {
	    eval 'sub f64add {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64 ( &f64add, $Val1, $Val2));
	    }' unless defined(&f64add);
	    eval 'sub f64div {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64 ( &f64div, $Val1, $Val2));
	    }' unless defined(&f64div);
	    eval 'sub f64mul {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64 ( &f64mul, $Val1, $Val2));
	    }' unless defined(&f64mul);
	    eval 'sub f64sub {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64 ( &f64sub, $Val1, $Val2));
	    }' unless defined(&f64sub);
	}
	if((defined(&__HAVE_FLOAT32X) ? &__HAVE_FLOAT32X : undef)) {
	    eval 'sub f32xadd {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32X ( &f32xadd, $Val1, $Val2));
	    }' unless defined(&f32xadd);
	    eval 'sub f32xdiv {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32X ( &f32xdiv, $Val1, $Val2));
	    }' unless defined(&f32xdiv);
	    eval 'sub f32xmul {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32X ( &f32xmul, $Val1, $Val2));
	    }' unless defined(&f32xmul);
	    eval 'sub f32xsub {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F32X ( &f32xsub, $Val1, $Val2));
	    }' unless defined(&f32xsub);
	}
	if((defined(&__HAVE_FLOAT64X) ? &__HAVE_FLOAT64X : undef)  && ((defined(&__HAVE_FLOAT128X) ? &__HAVE_FLOAT128X : undef) || (defined(&__HAVE_FLOAT128) ? &__HAVE_FLOAT128 : undef))) {
	    eval 'sub f64xadd {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64X ( &f64xadd, $Val1, $Val2));
	    }' unless defined(&f64xadd);
	    eval 'sub f64xdiv {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64X ( &f64xdiv, $Val1, $Val2));
	    }' unless defined(&f64xdiv);
	    eval 'sub f64xmul {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64X ( &f64xmul, $Val1, $Val2));
	    }' unless defined(&f64xmul);
	    eval 'sub f64xsub {
	        my($Val1, $Val2) = @_;
    		eval q( &__TGMATH_2_NARROW_F64X ( &f64xsub, $Val1, $Val2));
	    }' unless defined(&f64xsub);
	}
    }
}
1;
