# Copyright 2025-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

CRATES="
	adler2@2.0.0
	aead@0.5.2
	age-core@0.11.0
	age@0.11.1
	aho-corasick@1.1.3
	anstream@0.6.14
	anstyle-parse@0.2.4
	anstyle-query@1.1.0
	anstyle-wincon@3.0.3
	anstyle@1.0.8
	anyhow@1.0.86
	arc-swap@1.7.1
	askama@0.12.1
	askama_derive@0.12.5
	askama_escape@0.10.3
	askama_parser@0.2.1
	asn1-rs-derive@0.4.0
	asn1-rs-impl@0.1.0
	asn1-rs@0.5.2
	async-trait@0.1.89
	atomic-waker@1.1.2
	autocfg@1.3.0
	base16@0.2.1
	base64@0.13.1
	base64@0.21.7
	base64@0.22.0
	basic-toml@0.1.9
	bech32@0.9.1
	bimap@0.6.3
	bincode@2.0.1
	bincode_derive@2.0.1
	bitflags@1.3.2
	bitflags@2.5.0
	bitmaps@2.1.0
	bitvec@1.0.1
	block-buffer@0.10.4
	bstr@1.9.1
	bumpalo@3.15.4
	bytes@1.10.0
	camino@1.2.1
	capnp@0.21.7
	capnpc@0.21.4
	cc@1.2.16
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chacha20@0.9.1
	chacha20poly1305@0.10.1
	cipher@0.4.4
	clap@4.5.49
	clap_builder@4.5.49
	clap_derive@4.5.49
	clap_lex@0.7.6
	codespan-reporting@0.12.0
	colorchoice@1.0.0
	console@0.15.8
	console_error_panic_hook@0.1.7
	cookie-factory@0.3.3
	cpufeatures@0.2.12
	crc32fast@1.4.0
	crossbeam-channel@0.5.15
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.19
	crypto-common@0.1.6
	ctrlc@3.4.5
	curve25519-dalek-derive@0.1.1
	curve25519-dalek@4.1.3
	dashmap@6.1.0
	data-encoding@2.5.0
	dbus@0.9.7
	debug-ignore@1.0.5
	der-parser@8.2.0
	deranged@0.3.11
	diff@0.1.13
	digest@0.10.7
	dirs-next@2.0.0
	dirs-sys-next@0.1.2
	displaydoc@0.2.4
	ecow@0.2.6
	either@1.10.0
	embedded-io@0.6.1
	encode_unicode@0.3.6
	endian-type@0.1.2
	equivalent@1.0.1
	errno@0.3.8
	fastrand@2.0.2
	fiat-crypto@0.2.9
	filetime@0.2.23
	find-crate@0.6.3
	fixedbitset@0.5.7
	flate2@1.1.2
	fluent-bundle@0.15.3
	fluent-langneg@0.13.0
	fluent-syntax@0.11.1
	fluent@0.16.1
	fnv@1.0.7
	foldhash@0.1.5
	form_urlencoded@1.2.1
	fs_extra@1.3.0
	fslock@0.2.1
	funty@2.0.0
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	generic-array@0.14.7
	getrandom@0.2.15
	getrandom@0.3.3
	globset@0.4.18
	hashbrown@0.14.3
	hashbrown@0.15.3
	hashbrown@0.16.1
	heck@0.5.0
	hermit-abi@0.3.9
	hexpm@5.0.0
	hkdf@0.12.4
	hmac@0.12.1
	hostname@0.4.1
	http-auth-basic@0.3.3
	http-body-util@0.1.1
	http-body@1.0.0
	http@1.3.1
	httparse@1.10.1
	humansize@2.1.3
	hyper-rustls@0.27.2
	hyper-util@0.1.19
	hyper@1.8.1
	i18n-config@0.4.7
	i18n-embed-fl@0.9.2
	i18n-embed-impl@0.8.4
	i18n-embed@0.15.2
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	id-arena@2.2.1
	idna@1.0.3
	idna_adapter@1.2.0
	ignore@0.4.22
	im@15.1.0
	indexmap@2.12.1
	inout@0.1.3
	insta@1.41.1
	intl-memoizer@0.5.2
	intl_pluralrules@7.0.2
	io_tee@0.1.1
	ipnet@2.9.0
	iri-string@0.7.9
	is_terminal_polyfill@1.70.0
	itertools@0.14.0
	itoa@1.0.11
	js-sys@0.3.83
	lazy_static@1.4.0
	libc@0.2.172
	libdbus-sys@0.2.5
	libm@0.2.8
	libredox@0.1.3
	linked-hash-map@0.5.6
	linux-raw-sys@0.4.13
	litemap@0.7.4
	lock_api@0.4.12
	log@0.4.22
	lsp-server@0.7.8
	lsp-types@0.95.1
	matchers@0.2.0
	memchr@2.7.2
	mime@0.3.17
	mime_guess@2.0.4
	minimal-lexical@0.2.1
	miniz_oxide@0.8.8
	mio@1.0.1
	multimap@0.10.0
	nibble_vec@0.1.0
	nix@0.29.0
	nom@7.1.3
	normpath@1.2.0
	nu-ansi-term@0.50.1
	num-bigint@0.4.6
	num-conv@0.1.0
	num-integer@0.1.46
	num-traits@0.2.19
	oid-registry@0.6.1
	once_cell@1.19.0
	opaque-debug@0.3.1
	opener@0.7.2
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	pathdiff@0.2.3
	pbkdf2@0.12.2
	percent-encoding@2.3.1
	petgraph@0.7.1
	petgraph@0.8.3
	pin-project-internal@1.1.5
	pin-project-lite@0.2.14
	pin-project@1.1.5
	pin-utils@0.1.0
	pkg-config@0.3.30
	poly1305@0.8.0
	powerfmt@0.2.0
	ppv-lite86@0.2.17
	pretty_assertions@1.4.1
	prettyplease@0.2.17
	priority-queue@2.3.1
	proc-macro-error-attr2@2.0.0
	proc-macro-error2@2.0.1
	proc-macro2@1.0.95
	prost-build@0.13.5
	prost-derive@0.13.5
	prost-types@0.13.5
	prost@0.13.5
	psm@0.1.26
	pubgrub@0.3.0
	pulldown-cmark-escape@0.11.0
	pulldown-cmark@0.13.0
	quinn-proto@0.11.8
	quinn-udp@0.5.4
	quinn@0.11.2
	quote@1.0.35
	r-efi@5.2.0
	radium@0.7.0
	radix_trie@0.2.1
	rand@0.8.5
	rand@0.9.2
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	rand_xoshiro@0.6.0
	redox_syscall@0.4.1
	redox_syscall@0.5.7
	redox_users@0.4.5
	regex-automata@0.4.6
	regex-syntax@0.8.3
	regex@1.10.5
	reqwest@0.12.24
	ring@0.17.13
	rpassword@7.4.0
	rtoolbox@0.0.2
	rust-embed-impl@8.5.0
	rust-embed-utils@8.5.0
	rust-embed@8.5.0
	rustc-hash@1.1.0
	rustc-hash@2.0.0
	rustc_version@0.4.1
	rusticata-macros@4.1.0
	rustix@0.38.32
	rustls-pki-types@1.13.1
	rustls-webpki@0.102.2
	rustls@0.23.7
	rustversion@1.0.22
	ryu@1.0.17
	salsa20@0.10.2
	same-file@1.0.6
	scoped-tls@1.0.1
	scopeguard@1.2.0
	scrypt@0.11.0
	secrecy@0.10.3
	self_cell@0.10.3
	self_cell@1.0.4
	semver@1.0.23
	serde-wasm-bindgen@0.6.5
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.145
	serde_repr@0.1.18
	serde_spanned@1.0.2
	serde_urlencoded@0.7.1
	sha2@0.10.8
	sharded-slab@0.1.7
	shlex@1.3.0
	similar@2.5.0
	sized-chunks@0.6.5
	slab@0.4.9
	smallvec@1.13.2
	socket2@0.5.6
	socket2@0.6.0
	spdx@0.10.8
	stable_deref_trait@1.2.0
	stacker@0.1.21
	static_vcruntime@2.0.0
	strsim@0.11.1
	strum@0.27.2
	strum_macros@0.27.2
	subtle@2.5.0
	syn@1.0.109
	syn@2.0.101
	sync_wrapper@1.0.1
	synstructure@0.12.6
	synstructure@0.13.1
	tap@1.0.1
	tar@0.4.44
	tempfile@3.12.0
	termcolor@1.4.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	thread_local@1.1.8
	time-core@0.1.2
	time-macros@0.2.18
	time@0.3.36
	tinystr@0.7.6
	tinyvec@1.6.0
	tinyvec_macros@0.1.1
	tokio-rustls@0.26.0
	tokio@1.48.0
	toml@0.5.11
	toml@0.9.7
	toml_datetime@0.6.9
	toml_datetime@0.7.2
	toml_edit@0.22.26
	toml_parser@1.0.3
	toml_write@0.1.1
	toml_writer@1.0.3
	tower-http@0.6.7
	tower-layer@0.3.3
	tower-service@0.3.3
	tower@0.5.2
	tracing-attributes@0.1.30
	tracing-core@0.1.34
	tracing-log@0.2.0
	tracing-subscriber@0.3.20
	tracing-wasm@0.2.1
	tracing@0.1.41
	try-lock@0.2.5
	type-map@0.5.0
	typenum@1.17.0
	unic-langid-impl@0.9.5
	unic-langid@0.9.5
	unicase@2.7.0
	unicode-ident@1.0.12
	unicode-segmentation@1.12.0
	unicode-width@0.1.11
	unicode-xid@0.2.4
	universal-hash@0.5.1
	untrusted@0.9.0
	unty@0.0.4
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.1
	valuable@0.1.0
	vec1@1.12.1
	version-ranges@0.1.1
	version_check@0.9.4
	virtue@0.0.18
	walkdir@2.5.0
	want@0.3.1
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-futures@0.4.42
	wasm-bindgen-macro-support@0.2.106
	wasm-bindgen-macro@0.2.106
	wasm-bindgen-shared@0.2.106
	wasm-bindgen-test-macro@0.3.42
	wasm-bindgen-test@0.3.42
	wasm-bindgen@0.2.106
	web-sys@0.3.69
	webpki-roots@0.26.1
	webpki-roots@1.0.4
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.6
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-link@0.1.1
	windows-link@0.2.1
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.61.2
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.7.13
	wit-bindgen-rt@0.39.0
	write16@1.0.0
	writeable@0.5.5
	wyz@0.5.1
	x25519-dalek@2.0.1
	x509-parser@0.15.1
	xattr@1.3.1
	xxhash-rust@0.8.15
	yansi@1.0.1
	yoke-derive@0.7.5
	yoke@0.7.5
	zerofrom-derive@0.1.5
	zerofrom@0.1.5
	zeroize@1.7.0
	zeroize_derive@1.4.2
	zerovec-derive@0.10.3
	zerovec@0.10.4
"

inherit cargo optfeature

DESCRIPTION="A friendly language for building type-safe, scalable systems!"
HOMEPAGE="https://gleam.run/"
SRC_URI="
	https://github.com/gleam-lang/gleam/archive/refs/tags/v${PV}.tar.gz
		-> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="
	Apache-2.0 BSD Boost-1.0 CC0-1.0 ISC MIT MPL-2.0 MPL-2.0 Unicode-3.0
	Unicode-DFS-2016
"
SLOT="0"
KEYWORDS="~amd64"

RDEPEND="dev-lang/erlang:*"

src_prepare() {
	default

	# Requires https://bun.sh (not packaged in ::gentoo)
	sed -i /test-output/d Cargo.toml || die
}

src_install() {
	dodoc CHANGELOG.md
	cargo_src_install --path gleam-bin
}

pkg_postinst() {
	optfeature "erlang package support" dev-util/rebar:3
	optfeature "javascript runtime" net-libs/nodejs
}
