/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class UnparsedText
extends SystemFunction {
    String expressionBaseURI = null;
    public static final int UNPARSED_TEXT = 0;
    public static final int UNPARSED_TEXT_AVAILABLE = 1;
    public static final int UNPARSED_TEXT_LINES = 2;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public int computeSpecialProperties() {
        return super.computeSpecialProperties() & 0xFFBFFFFF;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        StringValue result;
        CharSequence content;
        try {
            StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
            if (hrefVal == null) {
                return null;
            }
            String href = hrefVal.getStringValue();
            String encoding = null;
            if (this.getNumberOfArguments() == 2) {
                encoding = this.argument[1].evaluateItem(context).getStringValue();
            }
            content = this.readFile(href, this.expressionBaseURI, encoding, context);
            result = new StringValue(content);
        }
        catch (XPathException err) {
            if (this.operation == 1) {
                return BooleanValue.FALSE;
            }
            err.maybeSetErrorCode("XTDE1170");
            throw err;
        }
        switch (this.operation) {
            case 1: {
                return BooleanValue.TRUE;
            }
            case 0: {
                return result;
            }
            case 2: {
                String contentString = ((Object)content).toString();
                if (contentString.indexOf(10) >= 0 || contentString.indexOf(13) >= 0) {
                    throw new XPathException("unparsed-text-lines() returned a sequence of more than one string", "XPTY0004");
                }
                return result;
            }
        }
        throw new UnsupportedOperationException(this.operation + "");
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        switch (this.operation) {
            case 0: 
            case 1: {
                return super.iterate(context);
            }
            case 2: {
                StringValue hrefVal = (StringValue)this.argument[0].evaluateItem(context);
                if (hrefVal == null) {
                    return null;
                }
                String href = hrefVal.getStringValue();
                String encoding = null;
                if (this.getNumberOfArguments() == 2) {
                    encoding = this.argument[1].evaluateItem(context).getStringValue();
                }
                Configuration config = context.getConfiguration();
                URI absoluteURI = this.getAbsoluteURI(href, this.expressionBaseURI);
                Reader reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
                LineNumberReader lnReader = new LineNumberReader(reader);
                return new UnparsedTextIterator(lnReader, absoluteURI, context);
            }
        }
        throw new UnsupportedOperationException(this.operation + "");
    }

    private CharSequence readFile(String href, String baseURI, String encoding, XPathContext context) throws XPathException {
        Reader reader;
        Configuration config = context.getConfiguration();
        NameChecker checker = config.getNameChecker();
        URI absoluteURI = this.getAbsoluteURI(href, baseURI);
        try {
            reader = context.getController().getUnparsedTextURIResolver().resolve(absoluteURI, encoding, config);
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTDE1170");
            err.maybeSetLocation(this);
            throw err;
        }
        try {
            return UnparsedText.readFile(checker, reader);
        }
        catch (UnsupportedEncodingException encErr) {
            XPathException e = new XPathException("Unknown encoding " + Err.wrap(encoding), encErr);
            e.setErrorCode("XTDE1190");
            throw e;
        }
        catch (IOException ioErr) {
            XPathException e = UnparsedText.handleIOError(absoluteURI, ioErr);
            e.setLocator(this);
            throw e;
        }
    }

    private URI getAbsoluteURI(String href, String baseURI) throws XPathException {
        URI absoluteURI;
        try {
            absoluteURI = ResolveURI.makeAbsolute(href, baseURI);
        }
        catch (URISyntaxException err) {
            XPathException e = new XPathException(err.getReason() + ": " + err.getInput(), err);
            e.setErrorCode("XTDE1170");
            throw e;
        }
        if (absoluteURI.getFragment() != null) {
            XPathException e = new XPathException("URI for unparsed-text() must not contain a fragment identifier");
            e.setErrorCode("XTDE1170");
            throw e;
        }
        EscapeURI.checkPercentEncoding(absoluteURI.toString());
        return absoluteURI;
    }

    private static XPathException handleIOError(URI absoluteURI, IOException ioErr) {
        String message = "Failed to read input file";
        if (!ioErr.getMessage().equals(absoluteURI.toString())) {
            message = message + ' ' + absoluteURI.toString();
        }
        message = message + " (" + ioErr.getClass().getName() + ')';
        XPathException e = new XPathException(message, ioErr);
        String errorCode = ioErr instanceof MalformedInputException ? "XTDE1200" : (ioErr instanceof CharacterCodingException ? "XTDE1200" : (ioErr instanceof UnmappableCharacterException ? "XTDE1190" : "XTDE1170"));
        e.setErrorCode(errorCode);
        return e;
    }

    public static CharSequence readFile(NameChecker checker, Reader reader) throws IOException, XPathException {
        int actual;
        FastStringBuffer sb = new FastStringBuffer(1024);
        char[] buffer = new char[2048];
        boolean first = true;
        int line = 1;
        int column = 1;
        while ((actual = reader.read(buffer, 0, 2048)) >= 0) {
            int c = 0;
            while (c < actual) {
                int ch32;
                if ((ch32 = buffer[c++]) == 10) {
                    ++line;
                    column = 0;
                }
                ++column;
                if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                    if (c == actual) {
                        actual = reader.read(buffer, 0, 2048);
                        c = 0;
                    }
                    char low = buffer[c++];
                    ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                }
                if (checker.isValidChar(ch32)) continue;
                XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + line + " column=" + column + " value=hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode("XTDE1190");
                throw err;
            }
            if (first) {
                first = false;
                if (buffer[0] == '\ufeff') {
                    sb.append(buffer, 1, actual - 1);
                    continue;
                }
                sb.append(buffer, 0, actual);
                continue;
            }
            sb.append(buffer, 0, actual);
        }
        reader.close();
        return sb.condense();
    }

    public static void main(String[] args) throws Exception {
        FastStringBuffer sb1 = new FastStringBuffer(256);
        FastStringBuffer sb2 = new FastStringBuffer(256);
        File file = new File(args[0]);
        FileInputStream is = new FileInputStream(file);
        while (true) {
            int b;
            if ((b = ((InputStream)is).read()) < 0) break;
            sb1.append(Integer.toHexString(b) + " ");
            sb2.append((char)b + " ");
            if (sb1.length() <= 80) continue;
            System.out.println(sb1.toString());
            System.out.println(sb2.toString());
            sb1 = new FastStringBuffer(256);
            sb2 = new FastStringBuffer(256);
        }
        System.out.println(sb1.toString());
        System.out.println(sb2.toString());
        ((InputStream)is).close();
    }

    private class UnparsedTextIterator
    implements SequenceIterator {
        LineNumberReader reader;
        NameChecker checker;
        URI absoluteURI;
        XPathContext context;
        StringValue current = null;
        int position = 0;

        public UnparsedTextIterator(LineNumberReader reader, URI absoluteURI, XPathContext context) {
            this.reader = reader;
            this.absoluteURI = absoluteURI;
            this.context = context;
            this.checker = context.getConfiguration().getNameChecker();
        }

        public Item next() throws XPathException {
            if (this.position < 0) {
                return null;
            }
            try {
                String s = this.reader.readLine();
                if (s == null) {
                    this.current = null;
                    this.position = -1;
                    return null;
                }
                this.checkLine(this.checker, s);
                this.current = new StringValue(s);
                ++this.position;
                return this.current;
            }
            catch (IOException err) {
                XPathException e = UnparsedText.handleIOError(this.absoluteURI, err);
                e.setLocator(UnparsedText.this);
                throw e;
            }
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.position;
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SequenceIterator getAnother() throws XPathException {
            return UnparsedText.this.iterate(this.context);
        }

        public int getProperties() {
            return 0;
        }

        private void checkLine(NameChecker checker, String buffer) throws XPathException {
            int c = 0;
            while (c < buffer.length()) {
                int ch32;
                if (UTF16CharacterSet.isHighSurrogate(ch32 = buffer.charAt(c++))) {
                    char low = buffer.charAt(c++);
                    ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
                }
                if (checker.isValidChar(ch32)) continue;
                XPathException err = new XPathException("The unparsed-text file contains a character that is illegal in XML (line=" + this.position + " column=" + (c + 1) + " value=hex " + Integer.toHexString(ch32) + ')');
                err.setErrorCode("XTDE1190");
                err.setLocator(UnparsedText.this);
                throw err;
            }
        }
    }
}

