/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.util.HexUtils;

@NonNullByDefault
public class ModbusRegisterArray {
    private final byte[] bytes;

    public ModbusRegisterArray(byte ... bytes) {
        if (bytes.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public ModbusRegisterArray(int ... registerValues) {
        this.bytes = new byte[registerValues.length * 2];
        int registerIndex = 0;
        while (registerIndex < registerValues.length) {
            int register = registerValues[registerIndex] & 0xFFFF;
            this.bytes[registerIndex * 2] = (byte)(register >> 8);
            this.bytes[registerIndex * 2 + 1] = (byte)register;
            ++registerIndex;
        }
    }

    public int getRegister(int i) {
        int hi = this.bytes[i * 2] & 0xFF;
        int lo = this.bytes[i * 2 + 1] & 0xFF;
        return (hi << 8 | lo) & 0xFFFF;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int size() {
        return this.bytes.length / 2;
    }

    public String toString() {
        if (this.bytes.length == 0) {
            return "ModbusRegisterArray(<empty>)";
        }
        return "ModbusRegisterArray(" + this.toHexString() + ")";
    }

    public String toHexString() {
        if (this.size() == 0) {
            return "";
        }
        return HexUtils.bytesToHex((byte[])this.getBytes());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModbusRegisterArray other = (ModbusRegisterArray)obj;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

