/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli.command;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIRunMeta;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.model.CommandLineAuthenticator;
import org.jkiss.dbeaver.model.cli.model.option.EclipseOptions;
import org.jkiss.dbeaver.model.cli.model.option.HiddenOptions;
import picocli.CommandLine;

public abstract class AbstractTopLevelCommand
implements Runnable,
CommandLine.IExitCodeGenerator {
    private final Log log = Log.getLog(this.getClass());
    public static final String HELP_OPTION = "--help";
    public static final String NOSPASH_OPTION = "-nosplash";
    public static final String DEBUG_LOGS_OPTION = "--debug-logs";
    public static final String TRACE_LOGS_OPTION = "--trace-logs";
    @CommandLine.Option(names={"-dump"}, description={"Print instance thread dump."})
    private boolean dump;
    @CommandLine.Option(names={"-h", "-help", "--help"}, description={"Show this help message and exit."}, usageHelp=true, scope=CommandLine.ScopeType.INHERIT)
    private boolean help;
    @CommandLine.Option(names={"-V", "--version"}, description={"Print version information and exit."}, versionHelp=true, scope=CommandLine.ScopeType.INHERIT)
    private boolean version;
    @CommandLine.Option(names={"--debug-logs"}, description={"Enable debug logging."}, scope=CommandLine.ScopeType.INHERIT)
    private boolean debugLogs;
    @CommandLine.Option(names={"--trace-logs"}, description={"Enable trace logging."}, scope=CommandLine.ScopeType.INHERIT, hidden=true)
    private boolean traceLogs;
    @CommandLine.Mixin
    private EclipseOptions eclipseOptions;
    @CommandLine.Mixin
    private HiddenOptions hiddenOptions;
    @NotNull
    protected final CLIRunMeta meta;
    @Nullable
    protected final ApplicationInstanceController controller;
    @NotNull
    protected final CommandLineContext context;
    private int code = 0;

    protected AbstractTopLevelCommand(@Nullable ApplicationInstanceController controller, @NotNull CommandLineContext context, @NotNull CLIRunMeta meta) {
        this.controller = controller;
        this.context = context;
        this.meta = meta;
    }

    @Override
    public void run() {
        if (this.debugLogs || this.traceLogs) {
            Log.setLogHandler(null);
            if (this.traceLogs) {
                Log.enableTraceLogs((boolean)true);
            }
        }
        try {
            if (this.dump) {
                if (this.controller == null) {
                    this.log.debug((Object)"Can't process commands because no running instance is present");
                    this.context.setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
                    return;
                }
                String threadDump = this.controller.getThreadDump();
                this.context.addResult(threadDump);
                this.context.setPostAction(CLIProcessResult.PostAction.SHUTDOWN);
                return;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error executing command", (Throwable)e);
            this.code = 1;
        }
    }

    public int getExitCode() {
        return this.code;
    }

    @NotNull
    public CommandLineContext getContext() {
        return this.context;
    }

    @Nullable
    public ApplicationInstanceController getController() {
        return this.controller;
    }

    @NotNull
    public CLIRunMeta getMeta() {
        return this.meta;
    }

    @Nullable
    public CommandLineAuthenticator getAuthenticator() {
        return null;
    }
}

