# Requirements for memx library

## Core Functionality

The `memx` library provides a set of functions for memory manipulation, similar to the standard C library's `<string.h>`, but implemented in pure Rust and optimized for performance.

### Memory Search Functions

- **`memchr(buf: &[u8], byte: u8) -> Option<usize>`**: Finds the first occurrence of `byte` in `buf`.
- **`memrchr(buf: &[u8], byte: u8) -> Option<usize>`**: Finds the last occurrence of `byte` in `buf`.
- **Multi-byte Search**:
    - `memchr_dbl`, `memchr_tpl`, `memchr_qpl`: Find the first occurrence of any byte from a set of 2, 3, or 4 bytes respectively.
    - `memrchr_dbl`, `memrchr_tpl`, `memrchr_qpl`: Find the last occurrence of any byte from a set of 2, 3, or 4 bytes respectively.
- **Negated Search**:
    - `memnechr`, `memnechr_dbl`, `memnechr_tpl`, `memnechr_qpl`: Find the first byte that is *not* in the given set.
    - `memrnechr`, `memrnechr_dbl`, `memrnechr_tpl`, `memrnechr_qpl`: Find the last byte that is *not* in the given set.
- **Sub-slice Search**:
    - **`memmem(haystack: &[u8], needle: &[u8]) -> Option<usize>`**: Finds the first occurrence of the sub-slice `needle` in `haystack`.
    - **`memrmem(haystack: &[u8], needle: &[u8]) -> Option<usize>`**: Finds the last occurrence of the sub-slice `needle` in `haystack`.

### Memory Comparison Functions

- **`memcmp(a: &[u8], b: &[u8]) -> Ordering`**: Compares two byte slices lexicographically.
- **`memeq(a: &[u8], b: &[u8]) -> bool`**: Checks if two byte slices are equal.

### Memory Manipulation Functions

- **`memcpy(dst: &mut [u8], src: &[u8]) -> Result<(), RangeError>`**: Copies bytes from `src` to `dst`. Returns an error if `dst` is smaller than `src`.
- **`memset(buf: &mut [u8], byte: u8)`**: Fills a byte slice with a given byte.

### Iterators

The library must provide iterator versions for all search functions to allow iterating over all occurrences of a byte or sub-slice.

- `memchr_iter`, `memrchr_iter`
- `memchr_dbl_iter`, `memrchr_dbl_iter`
- `memchr_tpl_iter`, `memrchr_tpl_iter`
- `memchr_qpl_iter`, `memrchr_qpl_iter`
- `memmem_iter`, `memrmem_iter`

## Performance

- The library must provide optimized implementations for x86 and x86-64 architectures.
- These optimizations should leverage SIMD instructions like SSE2 and AVX2 for significant performance gains.
- For other architectures, the library should provide safe and correct fallback implementations.

## API and Design

- The public API should be simple, intuitive, and well-documented.
- The function signatures should be clear and predictable.
- The library must be compatible with `no_std` environments, allowing its use in embedded systems and other resource-constrained environments.
- The library should be thoroughly tested to ensure correctness and reliability.
