/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.auth.HttpRequestAuthScope;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HttpHeaderFieldPreprocessor {
    @NotNull
    static HttpHeaderFieldPreprocessor create(@NotNull String name) {
        if (name == null) {
            HttpHeaderFieldPreprocessor.$$$reportNull$$$0(0);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"Authorization")) {
            HttpHeaderFieldPreprocessor httpHeaderFieldPreprocessor = HttpHeaderAuthorizationPreprocessor.AUTHORIZATION;
            if (httpHeaderFieldPreprocessor == null) {
                HttpHeaderFieldPreprocessor.$$$reportNull$$$0(1);
            }
            return httpHeaderFieldPreprocessor;
        }
        HttpHeaderFieldPreprocessor httpHeaderFieldPreprocessor = HttpHeaderDefaultPreprocessor.DEFAULT;
        if (httpHeaderFieldPreprocessor == null) {
            HttpHeaderFieldPreprocessor.$$$reportNull$$$0(2);
        }
        return httpHeaderFieldPreprocessor;
    }

    public abstract void addHeader(@NotNull RequestBuilder<?, ?> var1, @NotNull HttpHeaderField var2, @NotNull HttpRequestVariableSubstitutor var3) throws HttpRequestValidationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpHeaderFieldPreprocessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpHeaderFieldPreprocessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static class HttpHeaderAuthorizationPreprocessor
    extends HttpHeaderDefaultPreprocessor {
        private static final HttpHeaderFieldPreprocessor AUTHORIZATION = new HttpHeaderAuthorizationPreprocessor();

        @Override
        public void addHeader(@NotNull RequestBuilder<?, ?> requestBuilder, @NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
            HttpClientAuthData data;
            if (requestBuilder == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(1);
            }
            if (substitutor2 == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(2);
            }
            if ((data = this.generateAuthData(field, substitutor2)) != null) {
                requestBuilder.withAuthData(data);
            } else {
                super.addHeader(requestBuilder, field, substitutor2);
            }
        }

        @Nullable
        public HttpClientAuthData generateAuthData(@NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor2) {
            List<PsiElement> values;
            String protocol;
            HttpHeaderFieldValue value2;
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(3);
            }
            if (substitutor2 == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(4);
            }
            if ((value2 = field.getHeaderFieldValue()) != null && (StringUtil.equalsIgnoreCase((CharSequence)(protocol = HttpHeaderAuthorizationPreprocessor.getProtocol(value2, substitutor2)), (CharSequence)"Basic") || StringUtil.equalsIgnoreCase((CharSequence)protocol, (CharSequence)"Digest")) && (values = HttpHeaderAuthorizationPreprocessor.collectFieldValues((PsiElement)value2)).size() == 3) {
                String username = substitutor2.getValue(values.get(1));
                String password = substitutor2.getValue(values.get(2));
                HttpRequestAuthScope scope = new HttpRequestAuthScope(protocol);
                return new HttpClientAuthData(scope, new HttpRequestAuthCredentials.UsernamePassword(username, password));
            }
            return null;
        }

        @Nullable
        private static String getProtocol(@NotNull HttpHeaderFieldValue value2, @NotNull HttpRequestVariableSubstitutor substitutor2) {
            PsiElement first;
            if (value2 == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(5);
            }
            if (substitutor2 == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(6);
            }
            if ((first = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(value2.getFirstChild(), false)) != null && (HttpRequestPsiUtils.isOfType(first, HttpRequestElementTypes.FIELD_VALUE) || first instanceof HttpVariable)) {
                return substitutor2.getValue(first);
            }
            return null;
        }

        @NotNull
        private static List<PsiElement> collectFieldValues(@NotNull PsiElement field) {
            if (field == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(7);
            }
            ArrayList<PsiElement> values = new ArrayList<PsiElement>();
            for (PsiElement child = field.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
                values.add(child);
            }
            ArrayList<PsiElement> arrayList = values;
            if (arrayList == null) {
                HttpHeaderAuthorizationPreprocessor.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestBuilder";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/HttpHeaderFieldPreprocessor$HttpHeaderAuthorizationPreprocessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/HttpHeaderFieldPreprocessor$HttpHeaderAuthorizationPreprocessor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectFieldValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addHeader";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generateAuthData";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getProtocol";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFieldValues";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }

    public static class HttpHeaderDefaultPreprocessor
    extends HttpHeaderFieldPreprocessor {
        private static final HttpHeaderFieldPreprocessor DEFAULT = new HttpHeaderDefaultPreprocessor();

        @Override
        public void addHeader(@NotNull RequestBuilder<?, ?> requestBuilder, @NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor2) throws HttpRequestValidationException {
            String name;
            if (requestBuilder == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(0);
            }
            if (field == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(1);
            }
            if (substitutor2 == null) {
                HttpHeaderDefaultPreprocessor.$$$reportNull$$$0(2);
            }
            if ("Content-Length".equalsIgnoreCase(name = field.getHeaderFieldName().getText())) {
                return;
            }
            requestBuilder.withHeader(name, field.getValue(substitutor2), option -> (String)ObjectUtils.doIfNotNull((Object)field.getHeaderFieldValue(), value2 -> value2.getHeaderFieldOption((String)option)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "field";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/HttpHeaderFieldPreprocessor$HttpHeaderDefaultPreprocessor";
            objectArray[2] = "addHeader";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

