/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ToneTag;
import org.languagetool.UserConfig;
import org.languagetool.rules.CategoryId;

class InputSentence {
    private final String text;
    private final Language lang;
    private final Language motherTongue;
    private final Set<String> disabledRules;
    private final Set<CategoryId> disabledRuleCategories;
    private final Set<String> enabledRules;
    private final Set<CategoryId> enabledRuleCategories;
    private final UserConfig userConfig;
    private final List<Language> altLanguages;
    private final JLanguageTool.Mode mode;
    private final JLanguageTool.Level level;
    private final Long textSessionID;
    private final Set<ToneTag> toneTags;

    InputSentence(String text, Language lang, Language motherTongue, Set<String> disabledRules, Set<CategoryId> disabledRuleCategories, Set<String> enabledRules, Set<CategoryId> enabledRuleCategories, UserConfig userConfig, List<Language> altLanguages, JLanguageTool.Mode mode, JLanguageTool.Level level, Long textSessionID, Set<ToneTag> toneTags) {
        this.text = Objects.requireNonNull(text);
        this.lang = Objects.requireNonNull(lang);
        this.motherTongue = motherTongue;
        this.disabledRules = disabledRules;
        this.disabledRuleCategories = disabledRuleCategories;
        this.enabledRules = enabledRules;
        this.enabledRuleCategories = enabledRuleCategories;
        this.userConfig = userConfig;
        this.textSessionID = textSessionID;
        this.altLanguages = altLanguages;
        this.mode = Objects.requireNonNull(mode);
        this.level = Objects.requireNonNull(level);
        this.toneTags = toneTags != null ? toneTags : Collections.emptySet();
    }

    InputSentence(String text, Language lang, Language motherTongue, Set<String> disabledRules, Set<CategoryId> disabledRuleCategories, Set<String> enabledRules, Set<CategoryId> enabledRuleCategories, UserConfig userConfig, List<Language> altLanguages, JLanguageTool.Mode mode, JLanguageTool.Level level, Set<ToneTag> toneTags) {
        this(text, lang, motherTongue, disabledRules, disabledRuleCategories, enabledRules, enabledRuleCategories, userConfig, altLanguages, mode, level, userConfig != null ? userConfig.getTextSessionId() : null, toneTags);
    }

    InputSentence(String text, Language lang, Language motherTongue, Set<String> disabledRules, Set<CategoryId> disabledRuleCategories, Set<String> enabledRules, Set<CategoryId> enabledRuleCategories, UserConfig userConfig, List<Language> altLanguages, JLanguageTool.Mode mode, JLanguageTool.Level level) {
        this(text, lang, motherTongue, disabledRules, disabledRuleCategories, enabledRules, enabledRuleCategories, userConfig, altLanguages, mode, level, userConfig != null ? userConfig.getTextSessionId() : null, null);
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        InputSentence other = (InputSentence)o;
        return Objects.equals(this.text, other.text) && Objects.equals(this.lang, other.lang) && Objects.equals(this.motherTongue, other.motherTongue) && Objects.equals(this.disabledRules, other.disabledRules) && Objects.equals(this.disabledRuleCategories, other.disabledRuleCategories) && Objects.equals(this.enabledRules, other.enabledRules) && Objects.equals(this.enabledRuleCategories, other.enabledRuleCategories) && Objects.equals(this.userConfig, other.userConfig) && Objects.equals(this.textSessionID, other.textSessionID) && Objects.equals(this.altLanguages, other.altLanguages) && this.mode == other.mode && this.level == other.level && Objects.equals(this.toneTags, other.toneTags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.lang, this.motherTongue, this.disabledRules, this.disabledRuleCategories, this.enabledRules, this.enabledRuleCategories, this.userConfig, this.textSessionID, this.altLanguages, this.mode, this.level, this.toneTags});
    }

    public String toString() {
        return this.text;
    }
}

