/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_39;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_39.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_39.kt\ncom/intellij/database/model/serialization/converters/Converter_4_39\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1563#2:49\n1634#2,3:50\n*S KotlinDebug\n*F\n+ 1 Converter_4_39.kt\ncom/intellij/database/model/serialization/converters/Converter_4_39\n*L\n29#1:49\n29#1:50,3\n*E\n"})
public final class Converter_4_39
extends Converter {
    @NotNull
    public static final Converter_4_39 INSTANCE = new Converter_4_39();

    private Converter_4_39() {
        int[] nArray = new int[]{4, 39};
        super(nArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        boolean isH2 = Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.H2);
        boolean isMs = modelMem.getDbms().in(Dbms.MSSQL_LIKE);
        if (!isH2 && !isMs) {
            return;
        }
        String indexCode = ObjectKind.INDEX.code();
        for (ModelElementMem node : modelMem.getNodes()) {
            MutableNameAndValue mutableNameAndValue;
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)indexCode)) continue;
            if (isH2) {
                if (ModelSerializationFun.find(node.getProperties(), "ColExpressions") != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    List<String> expr;
                    MutableNameAndValue $this$convertMem_u24lambda_u241 = mutableNameAndValue;
                    boolean bl = false;
                    $this$convertMem_u24lambda_u241.setName("ColNames");
                    Intrinsics.checkNotNullExpressionValue(PropertyConverter.importListOfString($this$convertMem_u24lambda_u241.getValue()), (String)"importListOfString(...)");
                    Iterable iterable = expr;
                    MutableNameAndValue mutableNameAndValue2 = $this$convertMem_u24lambda_u241;
                    boolean $i$f$map = false;
                    void var14_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        char c2 = '\u001b';
                        Intrinsics.checkNotNull((Object)it);
                        void var23_23 = it;
                        collection.add(c2 + (String)var23_23);
                    }
                    String string = PropertyConverter.exportListOfString((List)destination$iv$iv);
                    if (string == null) {
                        string = "";
                    }
                    mutableNameAndValue2.setValue(string);
                    ModelSerializationFun.remove(node.getProperties(), "ColNames");
                }
                if (ModelSerializationFun.find(node.getProperties(), "SchemaName") != null) {
                    MutableNameAndValue $this$convertMem_u24lambda_u242 = mutableNameAndValue;
                    boolean bl = false;
                    $this$convertMem_u24lambda_u242.setName("IndexSchemaName");
                }
            }
            if (!isMs) continue;
            if (ModelSerializationFun.find(node.getProperties(), "FulltextUniqueIndexId") != null) {
                MutableNameAndValue $this$convertMem_u24lambda_u243 = mutableNameAndValue;
                boolean bl = false;
                $this$convertMem_u24lambda_u243.setName("FulltextUniqueIndexPosition");
            }
            if (ModelSerializationFun.find(node.getProperties(), "IncludeColNames") == null) continue;
            MutableNameAndValue $this$convertMem_u24lambda_u244 = mutableNameAndValue;
            boolean bl = false;
            $this$convertMem_u24lambda_u244.setName("IncludedColNames");
        }
    }
}

