/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.types.OraAssociativeArrayType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Version;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 %2\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\bJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer;", "", "routine", "Lcom/intellij/database/dialects/oracle/model/OraRoutine;", "<init>", "(Lcom/intellij/database/dialects/oracle/model/OraRoutine;)V", "outs", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "getOuts", "()Ljava/util/List;", "outs$delegate", "Lkotlin/Lazy;", "getCursorArguments", "getAssociativeArrayArguments", "getSqlTypeArrayArguments", "getPlTypeArrayArguments", "getSqlTypeNestedTableArguments", "getPlTypeNestedTableArguments", "getPrimitives", "Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "version", "Lcom/intellij/database/util/Version;", "getReturnArgument", "isReturn", "", "Lcom/intellij/database/model/ArgumentDirection;", "(Lcom/intellij/database/model/ArgumentDirection;)Z", "unwrappedType", "Lcom/intellij/database/types/DasType;", "getUnwrappedType", "(Lcom/intellij/database/dialects/oracle/model/OraArgument;)Lcom/intellij/database/types/DasType;", "isRefCursor", "argument", "isAssociativeArray", "isArray", "isNestedTable", "Companion", "PrimitivesPack", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraRoutineArgumentsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraRoutineArgumentsAnalyzer.kt\ncom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n774#2:91\n865#2,2:92\n774#2:94\n865#2,2:95\n774#2:97\n865#2,2:98\n774#2:100\n865#2,2:101\n774#2:103\n865#2,2:104\n774#2:106\n865#2,2:107\n774#2:128\n865#2,2:129\n996#3:109\n1025#3,3:110\n1028#3,3:120\n382#4,7:113\n126#5:123\n153#5,3:124\n1#6:127\n*S KotlinDebug\n*F\n+ 1 OraRoutineArgumentsAnalyzer.kt\ncom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer\n*L\n36#1:91\n36#1:92,2\n40#1:94\n40#1:95,2\n44#1:97\n44#1:98,2\n48#1:100\n48#1:101,2\n52#1:103\n52#1:104,2\n56#1:106\n56#1:107,2\n29#1:128\n29#1:129,2\n62#1:109\n62#1:110,3\n62#1:120,3\n62#1:113,7\n63#1:123\n63#1:124,3\n*E\n"})
public final class OraRoutineArgumentsAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OraRoutine routine;
    @NotNull
    private final Lazy outs$delegate;

    public OraRoutineArgumentsAnalyzer(@NotNull OraRoutine routine2) {
        Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
        this.routine = routine2;
        this.outs$delegate = LazyKt.lazy(() -> OraRoutineArgumentsAnalyzer.outs_delegate$lambda$1(this));
    }

    private final List<OraArgument> getOuts() {
        Lazy lazy = this.outs$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getCursorArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!this.isRefCursor(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getAssociativeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && this.isAssociativeArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && Companion.isSqlTypeArgument(it) && this.isArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeArrayArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && !Companion.isSqlTypeArgument(it) && this.isArray(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getSqlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && Companion.isSqlTypeArgument(it) && this.isNestedTable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<OraArgument> getPlTypeNestedTableArguments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getOuts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            if (!(!this.isRefCursor(it) && !Companion.isSqlTypeArgument(it) && this.isNestedTable(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PrimitivesPack> getPrimitives(@NotNull Version version) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        OraArgument it;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getOuts()), arg_0 -> OraRoutineArgumentsAnalyzer.getPrimitives$lambda$8(this, arg_0));
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            it = (OraArgument)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = Companion.isSqlTypeArgument(it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(new PrimitivesPack((Boolean)it.getKey() != false || Companion.supportPlTypesInSql(version), (List)it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final OraArgument getReturnArgument() {
        Object v1;
        block1: {
            Iterable iterable = this.getOuts();
            for (Object t : iterable) {
                OraArgument it = (OraArgument)t;
                boolean bl = false;
                ArgumentDirection argumentDirection = it.getArgumentDirection();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)argumentDirection), (String)"getArgumentDirection(...)");
                if (!this.isReturn(argumentDirection)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isReturn(ArgumentDirection $this$isReturn) {
        return $this$isReturn == ArgumentDirection.RETURN;
    }

    private final DasType getUnwrappedType(OraArgument $this$unwrappedType) {
        DasType dasType = $this$unwrappedType.getDasType();
        Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
        return DasTypeUtilsKt.unwrap$default(dasType, false, $this$unwrappedType, 1, null);
    }

    private final boolean isRefCursor(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraRefCursorType;
    }

    private final boolean isAssociativeArray(OraArgument argument) {
        DasType dasType = this.getUnwrappedType(argument);
        OraAssociativeArrayType oraAssociativeArrayType = dasType instanceof OraAssociativeArrayType ? (OraAssociativeArrayType)dasType : null;
        return (oraAssociativeArrayType != null ? oraAssociativeArrayType.getIndexType() : null) != null;
    }

    private final boolean isArray(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraVaryingArrayType;
    }

    private final boolean isNestedTable(OraArgument argument) {
        return this.getUnwrappedType(argument) instanceof OraNestedTableType;
    }

    /*
     * WARNING - void declaration
     */
    private static final List outs_delegate$lambda$1(OraRoutineArgumentsAnalyzer this$0) {
        void $this$filterTo$iv$iv;
        PositioningNamingFamily positioningNamingFamily = this$0.routine.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)positioningNamingFamily, (String)"getArguments(...)");
        Iterable $this$filter$iv = positioningNamingFamily;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArgumentDirection direction;
            OraArgument it = (OraArgument)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)it.getArgumentDirection()), (String)"getArgumentDirection(...)");
            if (!(direction.isOut() || this$0.isReturn(direction))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean getPrimitives$lambda$8(OraRoutineArgumentsAnalyzer this$0, OraArgument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.isRefCursor(it) && !this$0.isArray(it) && !this$0.isAssociativeArray(it) && !this$0.isNestedTable(it);
    }

    @JvmStatic
    public static final boolean supportPlTypesInSql(@NotNull Version version) {
        return Companion.supportPlTypesInSql(version);
    }

    @JvmStatic
    public static final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
        return Companion.isSqlTypeArgument(argument);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$Companion;", "", "<init>", "()V", "supportPlTypesInSql", "", "version", "Lcom/intellij/database/util/Version;", "isSqlTypeArgument", "argument", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean supportPlTypesInSql(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{12, 1};
            return version.isOrGreater(nArray);
        }

        @JvmStatic
        public final boolean isSqlTypeArgument(@NotNull OraArgument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            DasType dasType = argument.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType dasType2 = DasTypeUtilsKt.resolve(dasType, argument);
            Object object = dasType2 instanceof DasDefinedType ? (DasDefinedType)dasType2 : null;
            return (object != null && (object = object.getTypeClass()) != null ? object.getPackageName() : null) == null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/generator/OraRoutineArgumentsAnalyzer$PrimitivesPack;", "", "enabled", "", "arguments", "", "Lcom/intellij/database/dialects/oracle/model/OraArgument;", "<init>", "(ZLjava/util/List;)V", "getEnabled", "()Z", "getArguments", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.dialects.oracle"})
    public static final class PrimitivesPack {
        private final boolean enabled;
        @NotNull
        private final List<OraArgument> arguments;

        public PrimitivesPack(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            this.enabled = enabled;
            this.arguments = arguments;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> getArguments() {
            return this.arguments;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final List<OraArgument> component2() {
            return this.arguments;
        }

        @NotNull
        public final PrimitivesPack copy(boolean enabled, @NotNull List<? extends OraArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            return new PrimitivesPack(enabled, arguments);
        }

        public static /* synthetic */ PrimitivesPack copy$default(PrimitivesPack primitivesPack, boolean bl, List list, int n, Object object) {
            if ((n & 1) != 0) {
                bl = primitivesPack.enabled;
            }
            if ((n & 2) != 0) {
                list = primitivesPack.arguments;
            }
            return primitivesPack.copy(bl, list);
        }

        @NotNull
        public String toString() {
            return "PrimitivesPack(enabled=" + this.enabled + ", arguments=" + this.arguments + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.enabled);
            result2 = result2 * 31 + ((Object)this.arguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrimitivesPack)) {
                return false;
            }
            PrimitivesPack primitivesPack = (PrimitivesPack)other;
            if (this.enabled != primitivesPack.enabled) {
                return false;
            }
            return Intrinsics.areEqual(this.arguments, primitivesPack.arguments);
        }
    }
}

