/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.navigation;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.highlighting.LspDocumentLink;
import com.intellij.platform.lsp.impl.navigation.LspNavigatableSymbol;
import com.intellij.platform.lsp.impl.navigation.LspOpenBrowserNavigatableSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lsp/impl/navigation/LspDocumentLinkSymbolReference;", "Lcom/intellij/model/psi/PsiSymbolReference;", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "psiFile", "Lcom/intellij/psi/PsiFile;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "documentLink", "Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;", "LspDocumentLinkSymbolReference", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/platform/lsp/impl/highlighting/LspDocumentLink;)V", "getElement", "Lcom/intellij/psi/PsiElement;", "getRangeInElement", "resolvesTo", "", "target", "Lcom/intellij/model/Symbol;", "resolveReference", "", "intellij.platform.lsp.impl"})
final class LspDocumentLinkSymbolReference
implements PsiSymbolReference {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final LspDocumentLink documentLink;

    public LspDocumentLinkSymbolReference(@NotNull LspServerImpl lspServer, @NotNull PsiFile psiFile, @NotNull TextRange textRange, @NotNull LspDocumentLink documentLink) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)documentLink, (String)"documentLink");
        this.lspServer = lspServer;
        this.psiFile = psiFile;
        this.textRange = textRange;
        this.documentLink = documentLink;
    }

    @NotNull
    public PsiElement getElement() {
        return (PsiElement)this.psiFile;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.textRange;
    }

    public boolean resolvesTo(@NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    @NotNull
    public List<Symbol> resolveReference() {
        this.documentLink.resolveDocumentLink(this.lspServer);
        String string = this.documentLink.getTargetUri();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String string2 = string;
        if (StringsKt.startsWith$default((String)string2, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string2, (String)"https://", (boolean)false, (int)2, null)) {
            return CollectionsKt.listOf((Object)new LspOpenBrowserNavigatableSymbol(string2));
        }
        VirtualFile virtualFile = this.lspServer.getDescriptor().findFileByUri(string2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        return CollectionsKt.listOf((Object)new LspNavigatableSymbol(virtualFile2, null));
    }
}

