/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwaggerLanguagesModificationTracker;
import com.intellij.swagger.core.hub.SwaggerHubManager;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLPsiElement;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u0007H\u0000\u001a&\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0006\b\u0000\u0010\t\u0018\u0001*\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0006H\u0080\b\u00a2\u0006\u0002\u0010\n\u001a#\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u000e\u001a\f\u0010\u000f\u001a\u00020\u0010*\u0004\u0018\u00010\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u0010*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a9\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\t0\u001d\"\u0004\b\u0000\u0010\t*\n\u0012\u0004\u0012\u0002H\t\u0018\u00010\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\r\"\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\u001f\u001a!\u0010 \u001a\u0002H\t\"\u0004\b\u0000\u0010\t*\u0004\u0018\u0001H\t2\u0006\u0010!\u001a\u0002H\tH\u0000\u00a2\u0006\u0002\u0010\"\u001a \u0010#\u001a\b\u0012\u0004\u0012\u0002H\t0\u001d\"\u0004\b\u0000\u0010\t*\n\u0012\u0004\u0012\u0002H\t\u0018\u00010$H\u0000\u001a\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0001H\u0000\u001a\u0010\u0010(\u001a\u0004\u0018\u00010\u00012\u0006\u0010)\u001a\u00020\u0019\u001a\u0014\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0014\u0010-\u001a\u00020+*\u00020+2\u0006\u0010.\u001a\u00020\u0001H\u0000\u001a\u001e\u0010/\u001a\u00020+*\u00020+2\u0006\u00100\u001a\u00020\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001e\u00102\u001a\u00020+*\u00020+2\u0006\u00100\u001a\u00020\u00012\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0000\u001a,\u00103\u001a\u00020\u00012\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00012\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001d2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u00108\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\u00a8\u00069"}, d2={"orDefaultPath", "", "getYamlIndent", "property", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "createPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "castOrNull", "T", "(Lcom/intellij/psi/SmartPsiElementPointer;)Ljava/lang/Object;", "buildUrlFromSegments", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "isElementValid", "", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "getYamlJsonModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "withLeadingSlash", "withEndingSlash", "isLocatedInScope", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "orDefaultValues", "", "defaultValues", "(Ljava/util/List;[Ljava/lang/Object;)Ljava/util/List;", "or", "default", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "toListOrEmpty", "Lkotlin/sequences/Sequence;", "getBundledResource", "Lcom/intellij/openapi/vfs/VirtualFile;", "resourceName", "suggestRemoteSpecificationUrl", "specification", "buildUrlFrom", "Lorg/apache/http/client/utils/URIBuilder;", "url", "addPathSegment", "segment", "addQueryParameter", "name", "value", "addParameterIfNotNull", "getEndpointLocation", "authority", "basePaths", "Lcom/intellij/swagger/core/model/api/SwUrl;", "endpointUrl", "toSystemDependentPath", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerUtils.kt\ncom/intellij/swagger/core/SwaggerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n1#2:122\n14#3:123\n*S KotlinDebug\n*F\n+ 1 SwaggerUtils.kt\ncom/intellij/swagger/core/SwaggerUtilsKt\n*L\n92#1:123\n*E\n"})
public final class SwaggerUtilsKt {
    @NotNull
    public static final String orDefaultPath(@Nullable String $this$orDefaultPath) {
        String string = $this$orDefaultPath;
        if (string == null) {
            string = "/";
        }
        return string;
    }

    @NotNull
    public static final String getYamlIndent(@NotNull YAMLPsiElement property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        String string = StringUtil.repeatSymbol((char)' ', (int)YAMLUtil.getIndentInThisLine((PsiElement)((PsiElement)property)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
        return string;
    }

    @NotNull
    public static final SmartPsiElementPointer<PsiElement> createPointer(@NotNull PsiElement $this$createPointer) {
        Intrinsics.checkNotNullParameter((Object)$this$createPointer, (String)"<this>");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)$this$createPointer);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        return smartPsiElementPointer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ <T> T castOrNull(SmartPsiElementPointer<? extends PsiElement> $this$castOrNull) {
        PsiElement psiElement;
        PsiElement element;
        boolean $i$f$castOrNull = false;
        SmartPsiElementPointer<? extends PsiElement> smartPsiElementPointer = $this$castOrNull;
        Object object = element = smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        if (element != null) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (element instanceof Object && element.isValid()) {
                psiElement = element;
                return (T)psiElement;
            }
        }
        psiElement = null;
        return (T)psiElement;
    }

    @Nullable
    public static final String buildUrlFromSegments(String ... segments) {
        Intrinsics.checkNotNullParameter((Object)segments, (String)"segments");
        StringBuilder stringBuilder = new StringBuilder();
        for (String segment : segments) {
            StringBuilder stringBuilder2 = StringsKt.endsWith$default((CharSequence)stringBuilder, (CharSequence)"/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)segment, (String)"/", (boolean)false, (int)2, null) ? stringBuilder.append(StringsKt.drop((String)segment, (int)1)) : stringBuilder.append(segment);
        }
        return ((CharSequence)stringBuilder).length() == 0 ? null : stringBuilder.toString();
    }

    public static final boolean isElementValid(@Nullable SwModelElement $this$isElementValid) {
        SwModelElement swModelElement = $this$isElementValid;
        return swModelElement != null && (swModelElement = swModelElement.getSourcePsi()) != null ? swModelElement.isValid() : false;
    }

    @NotNull
    public static final ModificationTracker getYamlJsonModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getService(SwaggerLanguagesModificationTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
        return (ModificationTracker)object;
    }

    @NotNull
    public static final String withLeadingSlash(@NotNull String $this$withLeadingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withLeadingSlash, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$withLeadingSlash, (String)"/", (boolean)false, (int)2, null) ? $this$withLeadingSlash : "/" + $this$withLeadingSlash;
    }

    @NotNull
    public static final String withEndingSlash(@NotNull String $this$withEndingSlash) {
        Intrinsics.checkNotNullParameter((Object)$this$withEndingSlash, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$withEndingSlash, (String)"://", (boolean)false, (int)2, null) ? $this$withEndingSlash : $this$withEndingSlash + "://";
    }

    public static final boolean isLocatedInScope(@NotNull SwSpecificationFile $this$isLocatedInScope, @NotNull GlobalSearchScope scope) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocatedInScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        PsiFile psiFile = $this$isLocatedInScope.getSourcePsi();
        if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
            PsiFile it = psiFile;
            boolean bl2 = false;
            bl = scope.contains((VirtualFile)it);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final <T> List<T> orDefaultValues(@Nullable List<? extends T> $this$orDefaultValues, T ... defaultValues) {
        Intrinsics.checkNotNullParameter(defaultValues, (String)"defaultValues");
        Collection collection = $this$orDefaultValues;
        return collection == null || collection.isEmpty() ? ArraysKt.asList((Object[])defaultValues) : $this$orDefaultValues;
    }

    public static final <T> T or(@Nullable T $this$or, T t) {
        T t2 = $this$or;
        if (t2 == null) {
            t2 = t;
        }
        return t2;
    }

    @NotNull
    public static final <T> List<T> toListOrEmpty(@Nullable Sequence<? extends T> $this$toListOrEmpty) {
        Sequence<? extends T> sequence = $this$toListOrEmpty;
        List list = sequence != null ? SequencesKt.toList(sequence) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final VirtualFile getBundledResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        String[] stringArray = new String[]{"com.intellij.swagger"};
        PluginId pluginId = PluginId.Companion.findId(stringArray);
        if (pluginId == null) return null;
        PluginId it = pluginId;
        boolean bl = false;
        stringArray = PluginManagerCore.getPlugin((PluginId)it);
        if (stringArray == null) return null;
        ClassLoader classLoader = stringArray.getPluginClassLoader();
        if (classLoader == null) return null;
        URL uRL = classLoader.getResource(resourceName);
        if (uRL == null) return null;
        URL it2 = uRL;
        boolean bl2 = false;
        VirtualFile virtualFile = VfsUtil.findFileByURL((URL)it2);
        return virtualFile;
    }

    @Nullable
    public static final String suggestRemoteSpecificationUrl(@NotNull SwSpecificationFile specification) {
        String string;
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        if (specification.isRemote()) {
            String location;
            String string2;
            SwModelElement swModelElement = specification;
            String authority = swModelElement != null && (swModelElement = swModelElement.getAuthorities()) != null && (swModelElement = (SwAuthority)CollectionsKt.firstOrNull((List)((Object)swModelElement))) != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? swModelElement.getValue() : null;
            String it = string2 = (location = SwaggerUtilsKt.getEndpointLocation$default(authority, specification.getBasePaths(), null, 4, null));
            boolean bl = false;
            string = ((CharSequence)it).length() > 0 ? string2 : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final URIBuilder buildUrlFrom(@Nullable String url2) {
        CharSequence charSequence = url2;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        try {
            URIBuilder builder = new URIBuilder(url2);
            charSequence = builder.getHost() == null ? null : charSequence;
        }
        catch (URISyntaxException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwaggerHubManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to parse URL: " + url2);
            charSequence = null;
        }
        return charSequence;
    }

    @NotNull
    public static final URIBuilder addPathSegment(@NotNull URIBuilder $this$addPathSegment, @NotNull String segment) {
        Intrinsics.checkNotNullParameter((Object)$this$addPathSegment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        List list = $this$addPathSegment.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathSegments(...)");
        $this$addPathSegment.setPathSegments(CollectionsKt.plus((Collection)list, (Object)segment));
        return $this$addPathSegment;
    }

    @NotNull
    public static final URIBuilder addQueryParameter(@NotNull URIBuilder $this$addQueryParameter, @NotNull String name2, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        $this$addQueryParameter.setParameter(name2, value);
        return $this$addQueryParameter;
    }

    @NotNull
    public static final URIBuilder addParameterIfNotNull(@NotNull URIBuilder $this$addParameterIfNotNull, @NotNull String name2, @Nullable String value) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$addParameterIfNotNull, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                string = value;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                URIBuilder uRIBuilder = SwaggerUtilsKt.addQueryParameter($this$addParameterIfNotNull, name2, it);
                string = uRIBuilder;
                if (uRIBuilder != null) break block3;
            }
            string = $this$addParameterIfNotNull;
        }
        return string;
    }

    @NotNull
    public static final String getEndpointLocation(@Nullable String authority, @NotNull List<? extends SwUrl> basePaths2, @Nullable String endpointUrl) {
        Intrinsics.checkNotNullParameter(basePaths2, (String)"basePaths");
        SwUrl swUrl = (SwUrl)CollectionsKt.firstOrNull(basePaths2);
        String string = swUrl != null ? swUrl.getUrlString() : null;
        if (string == null) {
            string = "";
        }
        String string2 = StringsKt.removeSuffix((String)string, (CharSequence)"/");
        String string3 = endpointUrl;
        if (string3 == null) {
            string3 = "";
        }
        String presentablePath = string2 + string3;
        return authority != null ? StringsKt.removeSuffix((String)authority, (CharSequence)"/") + presentablePath : presentablePath;
    }

    public static /* synthetic */ String getEndpointLocation$default(String string, List list, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SwaggerUtilsKt.getEndpointLocation(string, list, string2);
    }

    @NotNull
    public static final String toSystemDependentPath(@Nullable String $this$toSystemDependentPath) {
        String string;
        String string2 = $this$toSystemDependentPath;
        if (string2 == null) {
            string = "";
        } else {
            String string3 = FileUtil.toSystemDependentName((String)string2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toSystemDependentName(...)");
        }
        return string;
    }
}

