/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import java.rmi.RemoteException;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0007H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020&H\u0016J\b\u0010+\u001a\u00020$H\u0016J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010/\u001a\u00020-H\u0016J\b\u00100\u001a\u00020$H\u0016J\u0006\u00101\u001a\u00020\u0005J\u0006\u00102\u001a\u00020$R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/database/dataSource/SimpleDatabaseConnection;", "Lcom/intellij/database/dataSource/DatabaseConnection;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "jdbcConnection", "Lcom/intellij/database/remote/jdbc/RemoteConnection;", "configuration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "requestor", "Lcom/intellij/database/dataSource/connection/ConnectionRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;Lcom/intellij/database/remote/jdbc/RemoteConnection;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/database/dataSource/connection/ConnectionRequestor;Lcom/intellij/openapi/project/Project;)V", "myJdbcConnection", "myConfiguration", "myConnectionPoint", "myAuditService", "Lcom/intellij/database/dataSource/connection/audit/AdvancedAuditService;", "myRequestor", "myDbms", "Lcom/intellij/database/Dbms;", "myVersion", "Lcom/intellij/database/util/Version;", "myDriverVersion", "getRequestor", "getDbms", "getVersion", "getDriverVersion", "getAuditService", "getConnectionPoint", "getRemoteMetaData", "Lcom/intellij/database/remote/jdbc/RemoteDatabaseMetaData;", "getRemoteConnection", "getConfiguration", "setAutoCommit", "", "autoCommit", "", "getAutoCommit", "setReadOnly", "only", "isReadOnly", "rollback", "savepoint", "Lcom/intellij/database/remote/jdbc/RemoteSavepoint;", "releaseSavepoint", "setSavepoint", "commit", "release", "cancelAll", "intellij.database.connectivity"})
public final class SimpleDatabaseConnection
implements DatabaseConnection {
    @NotNull
    private final RemoteConnection myJdbcConnection;
    @NotNull
    private final ConsoleRunConfiguration myConfiguration;
    @NotNull
    private final DatabaseConnectionPoint myConnectionPoint;
    @NotNull
    private final AdvancedAuditService myAuditService;
    @NotNull
    private final ConnectionRequestor myRequestor;
    @NotNull
    private final Dbms myDbms;
    @NotNull
    private final Version myVersion;
    @NotNull
    private final Version myDriverVersion;

    public SimpleDatabaseConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull RemoteConnection jdbcConnection, @NotNull ConsoleRunConfiguration configuration, @NotNull ConnectionRequestor requestor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)connectionPoint, (String)"connectionPoint");
        Intrinsics.checkNotNullParameter((Object)jdbcConnection, (String)"jdbcConnection");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myJdbcConnection = jdbcConnection;
        this.myConfiguration = configuration;
        this.myConnectionPoint = connectionPoint;
        this.myRequestor = requestor;
        DataSourceInfo.DetectedDbms detectedDbms = DataSourceInfo.getDetected((RemoteConnection)jdbcConnection);
        Intrinsics.checkNotNullExpressionValue((Object)detectedDbms, (String)"getDetected(...)");
        DataSourceInfo.DetectedDbms detected = detectedDbms;
        DatabaseDriver driver = this.myConnectionPoint.getDatabaseDriver();
        Dbms dbms = driver.getForcedDbms();
        if (dbms == null) {
            Dbms dbms2 = detected.dbms;
            dbms = dbms2;
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"dbms");
        }
        this.myDbms = dbms;
        Version version = detected.version;
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        this.myVersion = version;
        Version version2 = detected.driverVersion;
        Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"driverVersion");
        this.myDriverVersion = version2;
        this.myAuditService = new AdvancedAuditService((DatabaseConnectionCore)this, requestor, project);
    }

    @Override
    @NotNull
    public ConnectionRequestor getRequestor() {
        return this.myRequestor;
    }

    @NotNull
    public Dbms getDbms() {
        return this.myDbms;
    }

    @NotNull
    public Version getVersion() {
        return this.myVersion;
    }

    @NotNull
    public Version getDriverVersion() {
        return this.myDriverVersion;
    }

    @NotNull
    public AdvancedAuditService getAuditService() {
        return this.myAuditService;
    }

    @Override
    @NotNull
    public DatabaseConnectionPoint getConnectionPoint() {
        return this.myConnectionPoint;
    }

    @Nullable
    public RemoteDatabaseMetaData getRemoteMetaData() throws SQLException {
        return (RemoteDatabaseMetaData)JdbcNativeUtil.computeRemote(() -> SimpleDatabaseConnection.getRemoteMetaData$lambda$0(this));
    }

    @NotNull
    public RemoteConnection getRemoteConnection() {
        return this.myJdbcConnection;
    }

    @Override
    @NotNull
    public ConsoleRunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.myJdbcConnection.setAutoCommit(autoCommit);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.myJdbcConnection.getAutoCommit();
    }

    @Override
    public void setReadOnly(boolean only) throws SQLException {
        this.myJdbcConnection.setReadOnly(only);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.myJdbcConnection.isReadOnly();
    }

    @Override
    public void rollback() throws SQLException {
        this.myJdbcConnection.rollback();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public void rollback(@NotNull RemoteSavepoint savepoint) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.myJdbcConnection.rollback(savepoint);
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @Override
    public void releaseSavepoint(@NotNull RemoteSavepoint savepoint) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)savepoint, (String)"savepoint");
        this.myJdbcConnection.releaseSavepoint(savepoint);
    }

    @Override
    @NotNull
    public RemoteSavepoint setSavepoint() throws SQLException {
        RemoteSavepoint remoteSavepoint = this.myJdbcConnection.setSavepoint();
        Intrinsics.checkNotNullExpressionValue((Object)remoteSavepoint, (String)"setSavepoint(...)");
        return remoteSavepoint;
    }

    public void commit() throws SQLException {
        this.myJdbcConnection.commit();
        this.myAuditService.getWarningsListener().printConnectionWarnings();
    }

    @NotNull
    public final RemoteConnection release() {
        DbImplUtilCore.closeSafe((AutoCloseable)((AutoCloseable)this.myAuditService));
        return this.myJdbcConnection;
    }

    public final void cancelAll() {
        try {
            this.myJdbcConnection.cancelAll();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final RemoteDatabaseMetaData getRemoteMetaData$lambda$0(SimpleDatabaseConnection this$0) {
        return this$0.myJdbcConnection.getMetaData();
    }
}

