/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.BaseDataTypeConversion;
import com.intellij.database.data.types.ConversionGraph;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.data.types.DataTypeConversionUtil;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.DbObjectFormatterUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataTypeConversion
extends BaseDataTypeConversion {
    private final Dbms myFirstDbms;
    private final DasDataSource myFirstSystem;
    private final Dbms mySecondDbms;
    private final DasDataSource mySecondSystem;

    public DbDataTypeConversion(@NotNull Dbms firstDbms, @Nullable DasDataSource firstSystem, @NotNull GridColumn firstColumn, @NotNull Dbms secondDbms, @Nullable DasDataSource secondSystem, @NotNull ModelIndex<GridColumn> secondColIdx, @NotNull ModelIndex<GridRow> secondRowIdx, @NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable Object object) {
        if (firstDbms == null) {
            DbDataTypeConversion.$$$reportNull$$$0(0);
        }
        if (firstColumn == null) {
            DbDataTypeConversion.$$$reportNull$$$0(1);
        }
        if (secondDbms == null) {
            DbDataTypeConversion.$$$reportNull$$$0(2);
        }
        if (secondColIdx == null) {
            DbDataTypeConversion.$$$reportNull$$$0(3);
        }
        if (secondRowIdx == null) {
            DbDataTypeConversion.$$$reportNull$$$0(4);
        }
        if (grid == null) {
            DbDataTypeConversion.$$$reportNull$$$0(5);
        }
        super(firstColumn, secondColIdx, secondRowIdx, grid, object);
        this.myFirstDbms = firstDbms;
        this.myFirstSystem = firstSystem;
        this.mySecondSystem = secondSystem;
        this.mySecondDbms = secondDbms;
    }

    @NotNull
    public CellMutation.Builder convert(@NotNull ConversionGraph graph) {
        if (graph == null) {
            DbDataTypeConversion.$$$reportNull$$$0(6);
        }
        Object unwrapped = DbObjectFormatterUtil.unwrap((Object)this.myObject);
        CellMutation.Builder builder = new CellMutation.Builder().row(this.mySecondRowIdx).column(this.mySecondColumnIdx).value(null);
        GridColumn column2 = (GridColumn)this.mySecondGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(this.mySecondColumnIdx);
        if (column2 == null) {
            CellMutation.Builder builder2 = builder;
            if (builder2 == null) {
                DbDataTypeConversion.$$$reportNull$$$0(7);
            }
            return builder2;
        }
        Function converter = DataTypeConversionUtil.getConverter((ConversionGraph)graph, (Dbms)this.myFirstDbms, (Dbms)this.mySecondDbms, (DasDataSource)this.myFirstSystem, (DasDataSource)this.mySecondSystem, (ColumnDescriptor)this.myFirstColumn, (ColumnDescriptor)column2, (Object)unwrapped);
        CellMutation.Builder builder3 = converter == null ? builder : builder.value(converter.fun(unwrapped));
        if (builder3 == null) {
            DbDataTypeConversion.$$$reportNull$$$0(8);
        }
        return builder3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstDbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstColumn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondDbms";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondColIdx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondRowIdx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/DbDataTypeConversion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/DbDataTypeConversion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class Builder
    extends BaseDataTypeConversion.Builder {
        private Dbms myFirstDbms;
        private DasDataSource myFirstSystem;
        private Dbms mySecondDbms;
        private DasDataSource mySecondSystem;

        public Builder() {
        }

        private Builder(@Nullable Dbms firstDbms, @Nullable GridColumn firstColumn, int firstRowIdx, int firstColumnIdx, @Nullable DasDataSource firstSystem, @Nullable Object object, @Nullable Dbms secondDbms, @Nullable CoreGrid<GridRow, GridColumn> secondGrid, @Nullable DasDataSource secondSystem, @Nullable ModelIndex<GridColumn> secondColumnIdx, @Nullable ModelIndex<GridRow> secondRowIdx) {
            super(firstColumn, firstRowIdx, firstColumnIdx, object, secondGrid, secondColumnIdx, secondRowIdx);
            this.myFirstDbms = firstDbms;
            this.myFirstSystem = firstSystem;
            this.mySecondDbms = secondDbms;
            this.mySecondSystem = secondSystem;
        }

        @NotNull
        public Builder secondGrid(@NotNull CoreGrid<GridRow, GridColumn> grid) {
            if (grid == null) {
                Builder.$$$reportNull$$$0(0);
            }
            super.secondGrid(grid);
            this.mySecondDbms = DataGridUtilCore.getDbms(grid);
            this.mySecondSystem = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)DataGridUtilCore.getDatabaseSystem(grid));
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder firstGrid(@Nullable CoreGrid<GridRow, GridColumn> grid) {
            this.myFirstSystem = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)DataGridUtilCore.getDatabaseSystem(grid));
            this.myFirstDbms = DataGridUtilCore.getDbms(grid);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder copy() {
            return new Builder(this.myFirstDbms, this.myFirstColumn, this.myFirstRowIdx, this.myFirstColumnIdx, this.myFirstSystem, this.myObject, this.mySecondDbms, (CoreGrid<GridRow, GridColumn>)this.mySecondGrid, this.mySecondSystem, (ModelIndex<GridColumn>)this.mySecondColumnIdx, (ModelIndex<GridRow>)this.mySecondRowIdx);
        }

        @NotNull
        public DataTypeConversion build() {
            return new DbDataTypeConversion(this.myFirstDbms, this.myFirstSystem, this.myFirstColumn, this.mySecondDbms, this.mySecondSystem, (ModelIndex<GridColumn>)this.mySecondColumnIdx, (ModelIndex<GridRow>)this.mySecondRowIdx, (CoreGrid<GridRow, GridColumn>)this.mySecondGrid, this.myObject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/DbDataTypeConversion$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/DbDataTypeConversion$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "secondGrid";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "firstGrid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "secondGrid";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

