/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.lang.typescript.lsp.LspAnnotationErrorFilter;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/typescript/lsp/JSFrameworkLspAnnotationErrorFilter;", "Lcom/intellij/lang/typescript/lsp/LspAnnotationErrorFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tailwindCssAtRules", "", "", "isProblemEnabled", "", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "intellij.javascript.impl"})
public class JSFrameworkLspAnnotationErrorFilter
extends LspAnnotationErrorFilter {
    @NotNull
    private final List<String> tailwindCssAtRules;

    public JSFrameworkLspAnnotationErrorFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Object[] objectArray = new String[]{"@tailwind", "@apply", "@config", "@variants", "@responsive", "@screen", "@theme", "@source", "@utility", "@variant", "@custom-variant", "@reference", "@plugin"};
        this.tailwindCssAtRules = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isProblemEnabled(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        String string = diagnostic.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        String atRule = StringsKt.substringAfter((String)string, (String)"Unknown at rule ", (String)"");
        if (((CharSequence)atRule).length() > 0 && this.tailwindCssAtRules.contains(atRule)) {
            return false;
        }
        return super.isProblemEnabled(diagnostic);
    }
}

