/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceInfoReporter;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0014\u0010\u0011\u001a\u00020\u000f2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J \u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceInfoReporter;", "myProject", "Lcom/intellij/openapi/project/Project;", "presentableServiceName", "", "myManager", "Lcom/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager;", "myActive", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager;Z)V", "getPresentableServiceName", "()Ljava/lang/String;", "startingError", "", "errorText", "setProcess", "text", "logCurrentErrors", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "results", "", "Lcom/intellij/lang/javascript/integration/JSAnnotationError;", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceToolWindowInfoReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceToolWindowInfoReporter.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1056#2:53\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceToolWindowInfoReporter.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter\n*L\n34#1:53\n*E\n"})
public final class JSLanguageServiceToolWindowInfoReporter
implements JSLanguageServiceInfoReporter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String presentableServiceName;
    @NotNull
    private final JSLanguageServiceToolWindowManager myManager;
    private final boolean myActive;

    public JSLanguageServiceToolWindowInfoReporter(@NotNull Project myProject, @NotNull String presentableServiceName, @NotNull JSLanguageServiceToolWindowManager myManager, boolean myActive) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)presentableServiceName, (String)"presentableServiceName");
        Intrinsics.checkNotNullParameter((Object)myManager, (String)"myManager");
        this.myProject = myProject;
        this.presentableServiceName = presentableServiceName;
        this.myManager = myManager;
        this.myActive = myActive;
    }

    @Override
    @NotNull
    public String getPresentableServiceName() {
        return this.presentableServiceName;
    }

    @Override
    public void startingError(@NotNull String errorText) {
        Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
        ApplicationManager.getApplication().invokeLater(() -> JSLanguageServiceToolWindowInfoReporter.startingError$lambda$0(this, errorText));
    }

    @Override
    public void setProcess(@NlsSafe @Nullable String text) {
        ApplicationManager.getApplication().invokeLater(() -> JSLanguageServiceToolWindowInfoReporter.setProcess$lambda$1(this, text), this.myProject.getDisposed());
    }

    @Override
    public void logCurrentErrors(@Nullable VirtualFile virtualFile, @NotNull List<? extends JSAnnotationError> results) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Iterable $this$sortedBy$iv = results;
        boolean $i$f$sortedBy = false;
        List subSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JSAnnotationError it = (JSAnnotationError)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getAbsoluteFilePath());
                it = (JSAnnotationError)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAbsoluteFilePath())));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> JSLanguageServiceToolWindowInfoReporter.logCurrentErrors$lambda$5(this, virtualFile, subSorted), this.myProject.getDisposed());
    }

    private static final void startingError$lambda$0(JSLanguageServiceToolWindowInfoReporter this$0, String $errorText) {
        if (this$0.myProject.isInitialized()) {
            this$0.myManager.logCurrentErrors(JSLanguageServiceAnnotationResult.buildError($errorText), this$0.myActive);
        }
    }

    private static final void setProcess$lambda$1(JSLanguageServiceToolWindowInfoReporter this$0, String $text) {
        this$0.myManager.setProgressText($text);
    }

    private static final Integer logCurrentErrors$lambda$5$lambda$3(String $editorFilePath, JSAnnotationError el) {
        return Intrinsics.areEqual((Object)el.getAbsoluteFilePath(), (Object)$editorFilePath) ? -1 : 0;
    }

    private static final Integer logCurrentErrors$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final void logCurrentErrors$lambda$5(JSLanguageServiceToolWindowInfoReporter this$0, VirtualFile $virtualFile, List $subSorted) {
        Editor editor = FileEditorManager.getInstance((Project)this$0.myProject).getSelectedTextEditor();
        if (editor instanceof EditorEx) {
            VirtualFile editorFile = ((EditorEx)editor).getVirtualFile();
            if ($virtualFile == null || Intrinsics.areEqual((Object)$virtualFile, (Object)editorFile)) {
                if (editorFile != null) {
                    String editorFilePath = JSLanguageServiceUtil.normalizeNameAndPath(editorFile);
                    ContainerUtil.sort((List)$subSorted, Comparator.comparing(arg_0 -> JSLanguageServiceToolWindowInfoReporter.logCurrentErrors$lambda$5$lambda$4(arg_0 -> JSLanguageServiceToolWindowInfoReporter.logCurrentErrors$lambda$5$lambda$3(editorFilePath, arg_0), arg_0)));
                }
                this$0.myManager.logCurrentErrors($subSorted, false);
            }
        }
    }
}

