/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeSource {
    public static final JSTypeSource EMPTY = new JSTypeSource(null, SourceLanguage.JS, false);
    public static final JSTypeSource EMPTY_AS = new JSTypeSource(null, SourceLanguage.AS, false);
    public static final JSTypeSource EXPLICITLY_DECLARED = new JSTypeSource(null, SourceLanguage.JS, true);
    public static final JSTypeSource EMPTY_TS = new JSTypeSource(null, SourceLanguage.TS, false);
    public static final JSTypeSource EMPTY_TS_EXPLICITLY_DECLARED = new JSTypeSource(null, SourceLanguage.TS, true);
    private final PsiElement mySourceElement;
    private final boolean isStrict;
    private final SourceLanguage myLanguage;

    public JSTypeSource(@Nullable PsiElement sourceElement, @NotNull SourceLanguage language, boolean isStrict) {
        if (language == null) {
            JSTypeSource.$$$reportNull$$$0(0);
        }
        this.isStrict = isStrict;
        this.myLanguage = language;
        this.mySourceElement = sourceElement;
    }

    @Deprecated
    @Nullable
    public PsiFile getScope() {
        return this.mySourceElement != null && this.mySourceElement.isValid() ? this.mySourceElement.getContainingFile() : null;
    }

    @Nullable
    public PsiElement getSourceElement() {
        return this.mySourceElement;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    @Nullable
    public Project getProject() {
        return this.mySourceElement != null ? this.mySourceElement.getProject() : null;
    }

    public boolean isEcma() {
        return this.myLanguage == SourceLanguage.AS;
    }

    public boolean isTypeScript() {
        return this.myLanguage == SourceLanguage.TS;
    }

    public boolean isJavaScript() {
        return this.myLanguage == SourceLanguage.JS;
    }

    @NotNull
    public SourceLanguage getLanguage() {
        SourceLanguage sourceLanguage = this.myLanguage;
        if (sourceLanguage == null) {
            JSTypeSource.$$$reportNull$$$0(1);
        }
        return sourceLanguage;
    }

    @NotNull
    public JSTypeSource copyWithNewLanguage(@NotNull SourceLanguage language) {
        if (language == null) {
            JSTypeSource.$$$reportNull$$$0(2);
        }
        return new JSTypeSource(this.mySourceElement, language, this.isStrict);
    }

    @NotNull
    public JSTypeSource copyWithStrict(boolean isStrict) {
        return new JSTypeSource(this.mySourceElement, this.myLanguage, isStrict);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum SourceLanguage {
        JS,
        AS,
        TS;

    }
}

