/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeIdCache;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSTypeComparingContextService {
    public static final Key<Boolean> NULL_CHECKS = Key.create((String)"js.type.comparison.null.checks");
    public static final Key<PsiElement> LOCATION = Key.create((String)"js.type.comparison.location");
    public static final Key<JSTypeComparingCache> TYPE_COMPARATOR = Key.create((String)"js.type.comparator.cache");
    @NotNull
    private final CachedValue<JSTypeComparingCache> myCachedContext;
    @NotNull
    private final CachedValue<JSTypeComparingCache> mySubtypingCachedContext;
    @NotNull
    private final CachedValue<JSResolvedTypeIdCache> myRecordTypesCache;

    @NotNull
    public static JSTypeComparingContextService getService(@NotNull Project project) {
        if (project == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(0);
        }
        JSTypeComparingContextService jSTypeComparingContextService = (JSTypeComparingContextService)project.getService(JSTypeComparingContextService.class);
        if (jSTypeComparingContextService == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(1);
        }
        return jSTypeComparingContextService;
    }

    @NotNull
    private JSTypeComparingCache getComparingCache() {
        JSTypeComparingCache jSTypeComparingCache = (JSTypeComparingCache)this.myCachedContext.getValue();
        if (jSTypeComparingCache == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(2);
        }
        return jSTypeComparingCache;
    }

    @NotNull
    private JSTypeComparingCache getSubtypingComparingCache() {
        JSTypeComparingCache jSTypeComparingCache = (JSTypeComparingCache)this.mySubtypingCachedContext.getValue();
        if (jSTypeComparingCache == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(3);
        }
        return jSTypeComparingCache;
    }

    public JSTypeComparingContextService(@NotNull Project project) {
        if (project == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(4);
        }
        this.myCachedContext = JSTypeComparingContextService.buildCache(project);
        this.mySubtypingCachedContext = JSTypeComparingContextService.buildCache(project);
        this.myRecordTypesCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)new JSResolvedTypeIdCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    @NotNull
    private static CachedValue<JSTypeComparingCache> buildCache(@NotNull Project project) {
        if (project == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(5);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create((Object)new JSTypeComparingCache(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
        if (cachedValue == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(6);
        }
        return cachedValue;
    }

    @Nullable
    public static JSTypeComparingCache getComparingCache(@NotNull Project project, boolean subtyping) {
        if (project == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(7);
        }
        if (DumbService.isDumb((Project)project) || project.isDefault()) {
            return null;
        }
        JSTypeComparingContextService service = JSTypeComparingContextService.getService(project);
        return subtyping ? service.getSubtypingComparingCache() : service.getComparingCache();
    }

    @NotNull
    public JSResolvedTypeIdCache getResolvedTypeIdCacheCache() {
        JSResolvedTypeIdCache jSResolvedTypeIdCache = (JSResolvedTypeIdCache)this.myRecordTypesCache.getValue();
        if (jSResolvedTypeIdCache == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(8);
        }
        return jSResolvedTypeIdCache;
    }

    @NotNull
    public static JSRecordType buildRecordType(@NotNull JSType type2) {
        PsiElement element2;
        if (type2 == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(9);
        }
        if ((element2 = type2.getSource().getSourceElement()) == null || !element2.isValid()) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), type2);
            if (jSRecordType == null) {
                JSTypeComparingContextService.$$$reportNull$$$0(10);
            }
            return jSRecordType;
        }
        Project project = element2.getProject();
        if (DumbService.isDumb((Project)project) || project.isDefault()) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(ContainerUtil.emptyList(), type2);
            if (jSRecordType == null) {
                JSTypeComparingContextService.$$$reportNull$$$0(11);
            }
            return jSRecordType;
        }
        JSTypeComparingContextService service = JSTypeComparingContextService.getService(project);
        JSRecordType jSRecordType = service.getResolvedTypeIdCacheCache().buildRecordType(type2, element2);
        if (jSRecordType == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(12);
        }
        return jSRecordType;
    }

    @NotNull
    public static ProcessingContext createProcessingContextWithCallEnvironment(@Nullable PsiElement element2) {
        ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache(element2, false);
        context2.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)true);
        ProcessingContext processingContext = context2;
        if (processingContext == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(13);
        }
        return processingContext;
    }

    @NotNull
    public static ProcessingContext createProcessingContextWithCache(@Nullable PsiElement element2) {
        return JSTypeComparingContextService.createProcessingContextWithCache(element2, false);
    }

    @NotNull
    private static ProcessingContext createProcessingContextWithCache(@Nullable PsiElement element2, boolean subTyping) {
        PsiElement location;
        ProcessingContext processingContext = new ProcessingContext();
        if (element2 == null || !element2.isValid()) {
            ProcessingContext processingContext2 = processingContext;
            if (processingContext2 == null) {
                JSTypeComparingContextService.$$$reportNull$$$0(14);
            }
            return processingContext2;
        }
        JSTypeComparingCache cache = JSTypeComparingContextService.getComparingCache(element2.getProject(), subTyping);
        if (cache != null) {
            processingContext.put(TYPE_COMPARATOR, (Object)cache);
        }
        if ((location = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation()) == null) {
            location = element2;
        }
        processingContext.put(LOCATION, (Object)location);
        processingContext.put(NULL_CHECKS, (Object)TypeScriptConfigUtil.strictNullChecks(location));
        ProcessingContext processingContext3 = processingContext;
        if (processingContext3 == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(15);
        }
        return processingContext3;
    }

    public static ProcessingContext createSubtypingProcessingContext(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(16);
        }
        ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache(element2, true);
        context2.put(JSTypeComparingCache.SUBTYPING_CONTEXT, (Object)true);
        return context2;
    }

    public static boolean isSubtyping(@Nullable ProcessingContext processingContext) {
        return processingContext != null && processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == Boolean.TRUE;
    }

    @NotNull
    public static ProcessingContext setCallEnvironment(@NotNull ProcessingContext context2, boolean isCall) {
        Boolean isCallOld;
        if (context2 == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(17);
        }
        if ((isCallOld = (Boolean)context2.get(JSTypeBaseImpl.CALL_ENV_KEY)) == null && !isCall || isCallOld != null && isCallOld == isCall) {
            ProcessingContext processingContext = context2;
            if (processingContext == null) {
                JSTypeComparingContextService.$$$reportNull$$$0(18);
            }
            return processingContext;
        }
        context2.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)(isCall ? Boolean.valueOf(true) : null));
        context2.put(JSTypeComparingCache.CONTEXT_MAP_KEY, null);
        ProcessingContext processingContext = context2;
        if (processingContext == null) {
            JSTypeComparingContextService.$$$reportNull$$$0(19);
        }
        return processingContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 8, 10, 11, 12, 13, 14, 15, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeComparingContextService";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeComparingContextService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparingCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtypingComparingCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeIdCacheCache";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessingContextWithCallEnvironment";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessingContextWithCache";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setCallEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getComparingCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSubtypingProcessingContext";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCallEnvironment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 8, 10, 11, 12, 13, 14, 15, 18, 19 -> new IllegalStateException(string);
        };
    }
}

