/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.remoteDev.thinClientLink.ClientToGtwMessage;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.thinClientLink.LinkedClientManager;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketHandshakeHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f\u0018\u00010\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0002H\u0014J\u0018\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientRequestHandler;", "Lorg/jetbrains/io/webSocket/WebSocketHandshakeHandler;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "<init>", "()V", "connected", "", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "parameters", "", "", "", "isAccessible", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "isSupported", "Lio/netty/handler/codec/http/FullHttpRequest;", "disconnected", "getMessageServer", "messageReceived", "message", "", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nClientRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientRequestHandler.kt\ncom/jetbrains/gateway/thinClientLink/ClientRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n1#2:88\n14#3:89\n*S KotlinDebug\n*F\n+ 1 ClientRequestHandler.kt\ncom/jetbrains/gateway/thinClientLink/ClientRequestHandler\n*L\n85#1:89\n*E\n"})
public final class ClientRequestHandler
extends WebSocketHandshakeHandler
implements MessageServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<ThinClientHandle> handleKey;
    @NotNull
    private static final Key<LifetimeDefinition> clientLifetimeKey;
    @NotNull
    private static final KSerializer<ClientToGtwMessage> deserializer;
    @NotNull
    private static final Json jsonSettings;
    @NotNull
    private static final Logger logger;

    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (!(client instanceof WebSocketClient)) {
            return;
        }
        ThinClientHandle state = LinkedClientManager.Companion.getInstance().getState$intellij_gateway_core((object = parameters) != null && (object = object.get("uid")) != null ? (String)CollectionsKt.firstOrNull((List)object) : null);
        if (state == null) {
            logger.debug("Client connected without uid parameter");
            ((WebSocketClient)client).disconnect(new CloseWebSocketFrame(WebSocketCloseStatus.ENDPOINT_UNAVAILABLE));
            return;
        }
        logger.debug("New connection from client with uid " + state.getUid());
        LifetimeDefinition lifetime = new LifetimeDefinition();
        client.putUserData(clientLifetimeKey, (Object)lifetime);
        client.putUserData(handleKey, (Object)state);
        state.clientConnected$intellij_gateway_core((Lifetime)lifetime, (WebSocketClient)client);
    }

    public boolean isAccessible(@NotNull HttpRequest request) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URI uri = URI.create(request.uri());
        Intrinsics.checkNotNull((Object)uri);
        Map params = UriUtilKt.getQueryParameters((URI)uri);
        String string = (String)params.get("uid");
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            bl = LinkedClientManager.Companion.getInstance().isKnownClientUid$intellij_gateway_core(it);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"/gateway/clientLink", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public void disconnected(@NotNull Client client) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            ThinClientHandle thinClientHandle = (ThinClientHandle)client.getUserData(handleKey);
            logger.debug("Disconnecting client with uid " + (thinClientHandle != null ? thinClientHandle.getUid() : null));
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)client.getUserData(clientLifetimeKey);
            if (lifetimeDefinition == null) break block0;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    @NotNull
    protected MessageServer getMessageServer() {
        return this;
    }

    public void messageReceived(@NotNull Client client, @NotNull CharSequence message) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ThinClientHandle state = (ThinClientHandle)client.getUserData(handleKey);
        if (state == null) {
            logger.debug("Client send a message for unknown state");
            WebSocketClient webSocketClient = client instanceof WebSocketClient ? (WebSocketClient)client : null;
            if (webSocketClient != null) {
                webSocketClient.disconnect(new CloseWebSocketFrame(WebSocketCloseStatus.ENDPOINT_UNAVAILABLE));
            }
            return;
        }
        try {
            String string = ((Object)message).toString();
            logger.trace("Client for " + state.getUid() + " sent a message of length " + message.length());
            ClientToGtwMessage parsed = (ClientToGtwMessage)jsonSettings.decodeFromString((DeserializationStrategy)deserializer, string);
            if (!Intrinsics.areEqual((Object)parsed, (Object)ClientToGtwMessage.Ping.INSTANCE)) {
                logger.debug("Message contents: " + message + " = " + parsed);
            }
            state.getOnMessage$intellij_gateway_core().fire((Object)parsed);
        }
        catch (SerializationException ex) {
            logger.debug("Client send an invalid message", (Throwable)ex);
        }
    }

    private static final Unit jsonSettings$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"ClientHandle");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        handleKey = key;
        Key key2 = Key.create((String)"ClientLifetime");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        clientLifetimeKey = key2;
        deserializer = ClientToGtwMessage.Companion.serializer();
        jsonSettings = JsonKt.Json$default(null, ClientRequestHandler::jsonSettings$lambda$1, (int)1, null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClientRequestHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ClientRequestHandler.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ClientRequestHandler$Companion;", "", "<init>", "()V", "handleKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "clientLifetimeKey", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "deserializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/remoteDev/thinClientLink/ClientToGtwMessage;", "jsonSettings", "Lkotlinx/serialization/json/Json;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

