/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.data.input;

import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellsBundle;
import com.intellij.dataspell.jupyter.customCells.data.input.PythonDataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.LanguageTableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.core.jupyter.utils.JupyterPathUtils;
import com.intellij.jupyter.py.psi.JupyterPyDialect;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/data/input/JupyterCsvDropHandler;", "Lcom/intellij/jupyter/core/editor/handlers/LanguageTableDataFileDropHandler;", "<init>", "()V", "nameSuggester", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "getNameSuggester", "()Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "generateCellCode", "", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.dataspell.jupyter.customCells"})
public final class JupyterCsvDropHandler
extends LanguageTableDataFileDropHandler {
    public JupyterCsvDropHandler() {
        Object[] objectArray = new String[]{"csv", "tsv"};
        super((Language)JupyterPyDialect.INSTANCE, JupyterCustomCellsBundle.message("jupyter.drop.csv.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @NotNull
    public DataframeVariableNameSuggester getNameSuggester() {
        return PythonDataframeVariableNameSuggester.INSTANCE;
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        String string;
        TableDataFileDropHandlerContext.PathData pathData;
        Object separatorArg;
        block13: {
            Object object;
            block12: {
                Character csvSeparator;
                Character c;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TableDataFileDropHandlerContext.PathData pathData2 = context.getPathData();
                if (pathData2 instanceof TableDataFileDropHandlerContext.PathData.FileBased) {
                    c = CsvDropUtilKt.guessCsvSeparator((File)((TableDataFileDropHandlerContext.PathData.FileBased)pathData2).getTableDataFile());
                } else if (pathData2 instanceof TableDataFileDropHandlerContext.PathData.Lightweight) {
                    c = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((object = (csvSeparator = c)) == null) break block12;
                char separator = ((Character)object).charValue();
                boolean bl = false;
                Object escapedSeparator = separator == '\t' ? "\\t" : Character.valueOf(separator);
                String string2 = ", sep = '" + escapedSeparator + "'";
                object = string2;
                if (string2 != null) break block13;
            }
            object = separatorArg = "";
        }
        if ((pathData = context.getPathData()) instanceof TableDataFileDropHandlerContext.PathData.FileBased) {
            Path path = ((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getTableDataFile().toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Project project = ((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getProject();
            Path path2 = ((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getNotebookFile().getFile().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
            string = JupyterPathUtils.INSTANCE.getFileNotebookRelativedString(path, project, path2);
        } else if (pathData instanceof TableDataFileDropHandlerContext.PathData.Lightweight) {
            string = ((TableDataFileDropHandlerContext.PathData.Lightweight)pathData).getPathToDataFile();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String csvPath = string;
        String string3 = context.getDataframeName();
        if (string3 == null) {
            string3 = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension());
        }
        String dfName = string3;
        return StringsKt.trimIndent((String)("\n      import pandas as pd\n      " + dfName + " = pd.read_csv('" + csvPath + "'" + (String)separatorArg + ")\n      " + dfName + "\n    "));
    }
}

