// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature
// RUN: %clang_cc1 -triple wasm32 -target-feature +reference-types -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck %s
// REQUIRES: webassembly-registered-target

static __externref_t table[0];

// CHECK-LABEL: define {{[^@]+}}@test_builtin_wasm_table_get
// CHECK-SAME: (i32 noundef [[INDEX:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call ptr addrspace(10) @llvm.wasm.table.get.externref(ptr addrspace(1) @table, i32 [[INDEX]])
// CHECK-NEXT:    ret ptr addrspace(10) [[TMP0]]
//
__externref_t test_builtin_wasm_table_get(int index) {
  return __builtin_wasm_table_get(table, index);
}

// CHECK-LABEL: define {{[^@]+}}@test_builtin_wasm_table_set
// CHECK-SAME: (i32 noundef [[INDEX:%.*]], ptr addrspace(10) [[REF:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @llvm.wasm.table.set.externref(ptr addrspace(1) @table, i32 [[INDEX]], ptr addrspace(10) [[REF]])
// CHECK-NEXT:    ret void
//
void test_builtin_wasm_table_set(int index, __externref_t ref) {
  return __builtin_wasm_table_set(table, index, ref);
}

// CHECK-LABEL: define {{[^@]+}}@test_builtin_wasm_table_size
// CHECK-SAME: () #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.wasm.table.size(ptr addrspace(1) @table)
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_builtin_wasm_table_size() {
  return __builtin_wasm_table_size(table);
}

// CHECK-LABEL: define {{[^@]+}}@test_builtin_wasm_table_grow
// CHECK-SAME: (ptr addrspace(10) [[REF:%.*]], i32 noundef [[NELEM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.wasm.table.grow.externref(ptr addrspace(1) @table, ptr addrspace(10) [[REF]], i32 [[NELEM]])
// CHECK-NEXT:    ret i32 [[TMP0]]
//
int test_builtin_wasm_table_grow(__externref_t ref, int nelem) {
  return __builtin_wasm_table_grow(table, ref, nelem);
}

// CHECK-LABEL: define {{[^@]+}}@test_builtin_wasm_table_fill
// CHECK-SAME: (i32 noundef [[INDEX:%.*]], ptr addrspace(10) [[REF:%.*]], i32 noundef [[NELEM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @llvm.wasm.table.fill.externref(ptr addrspace(1) @table, i32 [[INDEX]], ptr addrspace(10) [[REF]], i32 [[NELEM]])
// CHECK-NEXT:    ret void
//
void test_builtin_wasm_table_fill(int index, __externref_t ref, int nelem) {
  __builtin_wasm_table_fill(table, index, ref, nelem);
}

static __externref_t other_table[0];

// CHECK-LABEL: define {{[^@]+}}@test_table_copy
// CHECK-SAME: (i32 noundef [[DST_IDX:%.*]], i32 noundef [[SRC_IDX:%.*]], i32 noundef [[NELEM:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    call void @llvm.wasm.table.copy(ptr addrspace(1) @table, ptr addrspace(1) @other_table, i32 [[SRC_IDX]], i32 [[DST_IDX]], i32 [[NELEM]])
// CHECK-NEXT:    ret void
//
void test_table_copy(int dst_idx, int src_idx, int nelem) {
  __builtin_wasm_table_copy(table, other_table, dst_idx, src_idx, nelem);
}
