
Uniformly Distributed Random Parse Trees
----------------------------------------
The dictionary define here will parse "any" language, exploring all
combinatoric possibilities of the arrangement of words into a parse
tree.  The sampling provides a uniform distribution in the space of
parse trees, in that each tree will occur with equal probability
(because they are exhaustively enumerated.) This is kind of uniform
distribution is useful in some machine learning tasks.

Some important design notes to be kept in mind.

* The code implicitly assumes that white-space is a word-separator.
  This works great for most modern languages, but can present
  difficulties for certain languages, as well as ancient and academic
  texts.

  In particular, Chinese texts are NOT written with white-space
  separated words, and word segmentation is outside the bounds
  of what can be supported here.

* Punctuation: the `4.0.affix` file defines a set of leading and
  trailing punctuation that is automatically stripped from the
  beginnings and endings of words. This list of punctuation in manually
  assembled, based on practical experience with common English and
  European text corpora found on the net.  It is not "complete" or
  "precise"; it is a stop-gap measure in place of proper text
  segmentation. Its a bit ad hoc and can be problematic.

  A proper approach would preface this stage by a text segmentation
  stage. Ideally, the segmentation should be learned. There are text
  segmenters available on the net; they are of mediocre quality.
  A proper, trained-from-first-principles text segmenter does not
  seem to be available.

* Root word of parse trees: The current dictionary allows the
  identification of multiple "root" words, e.g. of words that could
  be interpreted as root-verbs and root-nouns (subjects).  This may
  come as a surprise to some linguists, as there is only one root in
  the Chomskian tradition, and many dependency grammars share this
  tradition and only link to a single root, usually the root verb.

  Multiple roots are generated by having `LEFT-WALL` attach with `@ANY+`.
