/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadService;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.java.jdk.JdkAliases;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStore;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexChunkLocatorKt;
import com.intellij.indexing.shared.java.jdk.SharedJdkIndexSuggestion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallerListener;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexPreloader;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallerListener;", "<init>", "()V", "toSuggestion", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/java/jdk/JdkIndexLookupRequest;", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkIndexSuggestion;", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkInstallRequest;", "project", "Lcom/intellij/openapi/project/Project;", "onJdkDownloadStarted", "", "request", "onJdkDownloadFinished", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedJdkIndexChunkLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedJdkIndexChunkLocator.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkIndexPreloader\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,182:1\n40#2,3:183\n40#2,3:186\n40#2,3:189\n*S KotlinDebug\n*F\n+ 1 SharedJdkIndexChunkLocator.kt\ncom/intellij/indexing/shared/java/jdk/SharedJdkIndexPreloader\n*L\n62#1:183,3\n71#1:186,3\n88#1:189,3\n*E\n"})
public final class SharedJdkIndexPreloader
implements JdkInstallerListener {
    private final Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> toSuggestion(JdkInstallRequest $this$toSuggestion, Project project) {
        SharedJdkIndexSuggestion sharedJdkIndexSuggestion;
        JdkInstallRequest request = $this$toSuggestion;
        SharedIndexId sharedIndexId = SharedJdkIndexChunkLocatorKt.access$toSharedIndexId(request);
        if (sharedIndexId == null) {
            return null;
        }
        SharedIndexId id = sharedIndexId;
        JdkItem jdk = request.getItem();
        JdkIndexLookupRequest jdkRequest = new JdkIndexLookupRequest(jdk.getSuggestedSdkName(), null, CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)jdk.getSharedIndexAliases(), (Iterable)JdkAliases.INSTANCE.computeAliasesForJdkVersion(jdk.getVersionString()))), null, 10, null);
        SharedJdkIndexSuggestion it = sharedJdkIndexSuggestion = new SharedJdkIndexSuggestion(jdk, id, jdkRequest){
            private final String sdkName;
            private final SharedIndexId sharedIndexId;
            final /* synthetic */ SharedIndexId $id;
            final /* synthetic */ JdkIndexLookupRequest $jdkRequest;
            {
                this.$id = $id;
                this.$jdkRequest = $jdkRequest;
                this.sdkName = $jdk.getSuggestedSdkName();
                this.sharedIndexId = $id;
            }

            public String getSdkName() {
                return this.sdkName;
            }

            public SharedIndexId getSharedIndexId() {
                return this.sharedIndexId;
            }

            public JdkIndexLookupRequest resolveRequest(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                return this.$jdkRequest;
            }

            public String toString() {
                return "JdkSharedIndexSuggestion(" + this.$id + ", " + this.$jdkRequest + ")";
            }
        };
        boolean bl = false;
        boolean $i$f$service = false;
        Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SharedJdkIndexSuggestion sharedJdkIndexSuggestion2 = !((Collection)((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(CollectionsKt.listOf((Object)it), project)).isEmpty() ? sharedJdkIndexSuggestion : null;
        if (sharedJdkIndexSuggestion2 == null) {
            return null;
        }
        SharedJdkIndexSuggestion suggestion2 = sharedJdkIndexSuggestion2;
        return TuplesKt.to((Object)jdkRequest, (Object)suggestion2);
    }

    public void onJdkDownloadStarted(@NotNull JdkInstallRequest request, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!SharedJdkIndexChunkLocatorKt.access$isEnabled()) {
            return;
        }
        Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> pair = this.toSuggestion(request, project);
        if (pair == null) {
            return;
        }
        SharedJdkIndexSuggestion suggestion2 = (SharedJdkIndexSuggestion)pair.component2();
        boolean $i$f$service = false;
        Class<SharedIndexDownloadService> serviceClass$iv = SharedIndexDownloadService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SharedIndexDownloadService)object).applySuggestions(project, CollectionsKt.listOf((Object)suggestion2));
    }

    public void onJdkDownloadFinished(@NotNull JdkInstallRequest request, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!SharedJdkIndexChunkLocatorKt.access$isEnabled()) {
            return;
        }
        AppExecutorUtil.getAppExecutorService().submit(() -> SharedJdkIndexPreloader.onJdkDownloadFinished$lambda$1(this, request, project));
    }

    private static final void onJdkDownloadFinished$lambda$1(SharedJdkIndexPreloader this$0, JdkInstallRequest $request, Project $project) {
        Pair<JdkIndexLookupRequest, SharedJdkIndexSuggestion> pair = this$0.toSuggestion($request, $project);
        if (pair == null) {
            return;
        }
        JdkIndexLookupRequest jdkLookupRequest = (JdkIndexLookupRequest)pair.component1();
        Path home = $request.getJavaHome();
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(home);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualHome = virtualFile;
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualHome};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
        boolean $i$f$service = false;
        Class<SharedJdkChunkStore> serviceClass$iv = SharedJdkChunkStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((SharedJdkChunkStore)((Object)object)).registerDownloadingJdkRequest($request.getItem().getSuggestedSdkName(), virtualHome, jdkLookupRequest);
    }
}

