/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts;

import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.indexing.FileContent;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class TxtFactIndexer
implements PuppetFactDataIndexer {
    private static final Pattern TXT_FACT_PATTERN = Pattern.compile("^(\\S+)=.*$", 8);

    TxtFactIndexer() {
    }

    @NotNull
    public Map<String, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            TxtFactIndexer.$$$reportNull$$$0(0);
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Matcher matcher = TXT_FACT_PATTERN.matcher(inputData.getContentAsText());
        while (matcher.find()) {
            String factName = matcher.group(1);
            result.put(factName, matcher.start());
        }
        HashMap<String, Integer> hashMap = result;
        if (hashMap == null) {
            TxtFactIndexer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            TxtFactIndexer.$$$reportNull$$$0(2);
        }
        if (parentDirName == null) {
            TxtFactIndexer.$$$reportNull$$$0(3);
        }
        return parentDirName.equals("facts.d") && StringUtil.endsWithIgnoreCase((String)fileName, (String)".txt");
    }

    @Override
    @NotNull
    public FileType getSuitableFileType() {
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            TxtFactIndexer.$$$reportNull$$$0(4);
        }
        return plainTextFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/TxtFactIndexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/TxtFactIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

