/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0000J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDfaColumn;", "", "element", "Lcom/intellij/psi/PsiElement;", "dfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/dataFlow/types/DfType;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getDfType", "()Lcom/intellij/codeInspection/dataFlow/types/DfType;", "nullability", "Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "getNullability", "()Lcom/intellij/sql/inspections/dataflow/SqlDfaNullability;", "changeElement", "setNullability", "dropNullability", "toString", "", "equals", "", "other", "hashCode", "", "intellij.database.sql.core.impl"})
public final class SqlDfaColumn {
    @NotNull
    private final PsiElement element;
    @NotNull
    private final DfType dfType;

    public SqlDfaColumn(@NotNull PsiElement element, @NotNull DfType dfType) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)dfType, (String)"dfType");
        this.element = element;
        this.dfType = dfType;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public final DfType getDfType() {
        return this.dfType;
    }

    @NotNull
    public final SqlDfaNullability getNullability() {
        return SqlDfTypesKt.nullability(this.dfType);
    }

    @NotNull
    public final SqlDfaColumn changeElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)element, (Object)this.element) ? this : new SqlDfaColumn(element, this.dfType);
    }

    @NotNull
    public final SqlDfaColumn setNullability(@NotNull SqlDfaNullability nullability) {
        Intrinsics.checkNotNullParameter((Object)((Object)nullability), (String)"nullability");
        return new SqlDfaColumn(this.element, SqlDfTypesKt.setNullability(this.dfType, nullability));
    }

    @NotNull
    public final SqlDfaColumn dropNullability() {
        return this.setNullability(SqlDfaNullability.UNKNOWN);
    }

    @NotNull
    public String toString() {
        return this.dfType.toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof SqlDfaColumn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.element, (Object)((SqlDfaColumn)other).element)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dfType, (Object)((SqlDfaColumn)other).dfType);
    }

    public int hashCode() {
        return 31 * this.element.hashCode() + this.dfType.hashCode();
    }
}

