/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.dialects.sqlite.plan.SqlitePlanModelBuilder;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqliteRawPlanData
extends RawPlanData {
    public String statement;
    public boolean newFmt;
    public final List<SqlitePlanModelBuilder.PlanRow> rows = new ArrayList<SqlitePlanModelBuilder.PlanRow>();

    @Override
    public void load(final @NotNull DatabaseConnectionCore connection, final @NotNull String statement, boolean run2) {
        if (connection == null) {
            SqliteRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            SqliteRawPlanData.$$$reportNull$$$0(1);
        }
        this.statement = statement;
        SqliteRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                SqliteRawPlanData.this.newFmt = connection.getVersion().isOrGreater(3, 24);
                s.noisy().execute("EXPLAIN QUERY PLAN " + statement, SqliteRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    if (rs.getMetaData().getColumnCount() != 4) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    while (rs.next()) {
                        SqliteRawPlanData.this.rows.add(new SqlitePlanModelBuilder.PlanRow(rs.getInt(SqliteRawPlanData.this.newFmt ? "id" : "selectid"), rs.getInt(SqliteRawPlanData.this.newFmt ? "parent" : "order"), rs.getInt(3), rs.getString("detail")));
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            SqliteRawPlanData.$$$reportNull$$$0(2);
        }
        this.statement = "";
        this.rows.clear();
        Boolean fmtNew = null;
        for (String line : dump.split("\\r?\\n")) {
            List split = StringUtil.split((String)line, (String)"\t", (boolean)true, (boolean)false);
            assert (split.size() == 5);
            if (fmtNew == null) {
                fmtNew = !"0".equals(split.get(1));
            }
            this.rows.add(new SqlitePlanModelBuilder.PlanRow(Integer.parseInt((String)split.get(1)), Integer.parseInt((String)split.get(2)), Integer.parseInt((String)split.get(3)), (String)split.get(4)));
        }
        this.newFmt = Boolean.TRUE.equals(fmtNew);
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (SqlitePlanModelBuilder.PlanRow row : this.rows) {
            sb.append("\t").append(row.subqueryId).append("\t").append(row.order).append("\t").append(row.from).append("\t").append(row.detail).append("\n");
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/sqlite/plan/SqliteRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

