/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.openapi.util.text.StringUtil;

public enum PgDataTypeSubKind {
    NONE('\u0000'),
    BASE_TYPE('b'),
    COMPOSITE('c'),
    DOMAIN('d'),
    ENUM('e'),
    PSEUDO('p'),
    UNKNOWN('x');

    public final char code;

    private PgDataTypeSubKind(char code) {
        this.code = code;
    }

    public static PgDataTypeSubKind of(char c2) {
        return switch (Character.toLowerCase(c2)) {
            case 'b' -> BASE_TYPE;
            case 'c' -> COMPOSITE;
            case 'd' -> DOMAIN;
            case 'e' -> ENUM;
            case 'p' -> PSEUDO;
            case '\u0000' -> NONE;
            default -> UNKNOWN;
        };
    }

    public String human_readable_name() {
        return StringUtil.toLowerCase((String)this.name()).replace('_', ' ');
    }
}

